/*
 * Decompiled with CFR 0.152.
 */
package glair.vision.model;

import glair.vision.api.Config;
import glair.vision.logger.Logger;
import glair.vision.model.Request;
import glair.vision.model.VisionSettings;
import glair.vision.model.param.sessions.BaseSessionsParam;
import glair.vision.util.Json;
import glair.vision.util.Util;
import java.util.HashMap;
import okhttp3.MediaType;
import okhttp3.RequestBody;

public class BaseSessions<T extends BaseSessionsParam> {
    protected static final Logger logger = Logger.getInstance();
    protected final Config config;
    protected final String sessionType;
    protected final String baseUrl;

    protected BaseSessions(Config config, String sessionType, String baseUrl) {
        this.config = config;
        this.sessionType = sessionType;
        this.baseUrl = baseUrl;
    }

    public String getSessionType() {
        return this.sessionType;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String create(T param) throws Exception {
        return this.create(param, null);
    }

    public String create(T param, VisionSettings newVisionSettings) throws Exception {
        this.log("Create", param);
        RequestBody body = RequestBody.create((String)Json.toJsonString(this.createBody(param)), (MediaType)MediaType.get((String)"application/json; charset=utf-8"));
        Request request = new Request.RequestBuilder(this.baseUrl, "POST").body(body).build();
        return this.fetch(request, newVisionSettings);
    }

    public String retrieve(String sid) throws Exception {
        return this.retrieve(sid, null);
    }

    public String retrieve(String sid, VisionSettings newVisionSettings) throws Exception {
        this.log("Retrieve", Json.toJsonString("sid", sid));
        String url = this.baseUrl + "/" + sid;
        Request request = new Request.RequestBuilder(url, "GET").build();
        return this.fetch(request, newVisionSettings);
    }

    protected HashMap<String, String> createBody(T param) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("success_url", ((BaseSessionsParam)param).getSuccessUrl());
        if (((BaseSessionsParam)param).getCancelUrl() != null) {
            map.put("cancel_url", ((BaseSessionsParam)param).getCancelUrl());
        }
        return map;
    }

    private String fetch(Request request, VisionSettings visionSettings) throws Exception {
        VisionSettings settingsToUse = visionSettings == null ? this.config.getSettings() : visionSettings;
        return Util.visionFetch(this.config.getConfig(settingsToUse), request);
    }

    private void log(String type, Object param) {
        logger.info(this.sessionType, "Sessions -", type);
        logger.debug("Param", param);
    }
}

