/*
 * Decompiled with CFR 0.152.
 */
package glair.vision.model.param;

import glair.vision.util.Json;
import glair.vision.util.Util;
import java.util.HashMap;

public class IdentityFaceVerificationParam {
    private final String nik;
    private final String name;
    private final String dateOfBirth;
    private final String faceImagePath;

    private IdentityFaceVerificationParam(Builder builder) {
        this.nik = builder.nik;
        this.name = builder.name;
        this.dateOfBirth = builder.dateOfBirth;
        this.faceImagePath = builder.faceImagePath;
    }

    public String getNik() {
        return this.nik;
    }

    public String getName() {
        return this.name;
    }

    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    public String getFaceImagePath() {
        return this.faceImagePath;
    }

    public String toString() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("nik", this.nik);
        map.put("name", this.name);
        map.put("date_of_birth", this.dateOfBirth);
        map.put("face_image_path", this.faceImagePath);
        return Json.toJsonString(map, 2);
    }

    public static class Builder {
        private String nik;
        private String name;
        private String dateOfBirth;
        private String faceImagePath;

        public Builder nik(String nik) {
            this.nik = nik;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder dateOfBirth(String dateOfBirth) {
            this.dateOfBirth = dateOfBirth;
            return this;
        }

        public Builder faceImagePath(String faceImagePath) {
            this.faceImagePath = faceImagePath;
            return this;
        }

        public IdentityFaceVerificationParam build() throws Exception {
            Util.require("NIK", this.nik);
            Util.require("Name", this.name);
            Util.require("Date of Birth", this.dateOfBirth);
            Util.require("Face Image Path", this.faceImagePath);
            return new IdentityFaceVerificationParam(this);
        }
    }
}

