/*
 * Decompiled with CFR 0.152.
 */
package glair.vision.model.param;

import glair.vision.util.Json;
import glair.vision.util.Util;
import java.util.HashMap;

public class IdentityVerificationParam {
    private final String nik;
    private final String name;
    private final String dateOfBirth;

    private IdentityVerificationParam(Builder builder) {
        this.nik = builder.nik;
        this.name = builder.name;
        this.dateOfBirth = builder.dateOfBirth;
    }

    public String getNik() {
        return this.nik;
    }

    public String getName() {
        return this.name;
    }

    public String getDateOfBirth() {
        return this.dateOfBirth;
    }

    public String toString() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("nik", this.nik);
        map.put("name", this.name);
        map.put("date_of_birth", this.dateOfBirth);
        return Json.toJsonString(map, 2);
    }

    public static class Builder {
        private String nik;
        private String name;
        private String dateOfBirth;

        public Builder nik(String nik) {
            this.nik = nik;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder dateOfBirth(String dateOfBirth) {
            this.dateOfBirth = dateOfBirth;
            return this;
        }

        public IdentityVerificationParam build() throws Exception {
            Util.require("NIK", this.nik);
            Util.require("Name", this.name);
            Util.require("Date of Birth", this.dateOfBirth);
            return new IdentityVerificationParam(this);
        }
    }
}

