/*
 * Decompiled with CFR 0.152.
 */
package glair.vision.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class Env {
    private final Properties properties = new Properties();

    public Env() throws Exception {
        this("config.properties", false);
    }

    public Env(String propertiesPath, boolean debug) throws Exception {
        try (FileInputStream fileInputStream = new FileInputStream(propertiesPath);){
            this.properties.load(fileInputStream);
        }
        if (debug) {
            File file = new File(propertiesPath);
            System.out.println(file.getAbsolutePath());
        }
    }

    private String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String getUsername() {
        return this.getProperty("username");
    }

    public String getPassword() {
        return this.getProperty("password");
    }

    public String getApiKey() {
        return this.getProperty("apiKey");
    }

    public String getKtp() {
        return this.getProperty("ktp");
    }

    public String getNpwp() {
        return this.getProperty("npwp");
    }

    public String getKk() {
        return this.getProperty("kk");
    }

    public String getStnk() {
        return this.getProperty("stnk");
    }

    public String getBpkb() {
        return this.getProperty("bpkb");
    }

    public String getPassport() {
        return this.getProperty("passport");
    }

    public String getLicensePlate() {
        return this.getProperty("licensePlate");
    }

    public String getGeneralDocument() {
        return this.getProperty("generalDocument");
    }

    public String getInvoice() {
        return this.getProperty("invoice");
    }

    public String getReceipt() {
        return this.getProperty("receipt");
    }

    public String getIdentityBasicVerification() {
        return this.getProperty("identityBasicVerification");
    }

    public String getIdentityFaceVerification() {
        return this.getProperty("identityFaceVerification");
    }

    public String getFace() {
        return this.getProperty("face");
    }
}

