/*
 * Decompiled with CFR 0.152.
 */
package glair.vision.util;

import java.util.HashMap;
import java.util.Map;

public class Json {
    private static String formatJsonProperty(String key, String value) {
        return "\"" + key + "\": \"" + value + "\"";
    }

    public static String toJsonString(String key, String value) {
        return "{" + Json.formatJsonProperty(key, value) + "}";
    }

    public static String toJsonString(HashMap<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean first = true;
        stringBuilder.append("{");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!first) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(Json.formatJsonProperty(entry.getKey(), entry.getValue()));
            first = false;
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static String toJsonString(HashMap<String, String> map, int indent) {
        String tab = Json.createTab(indent);
        StringBuilder stringBuilder = new StringBuilder("{\n");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuilder.append(tab).append(Json.formatJsonProperty(entry.getKey(), entry.getValue()));
            if (!entry.equals(map.entrySet().iterator().next())) {
                stringBuilder.append(",");
            }
            stringBuilder.append("\n");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private static String createTab(int indent) {
        StringBuilder indentation = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            indentation.append(" ");
        }
        return indentation.toString();
    }
}

