/*
 * Decompiled with CFR 0.152.
 */
package glair.vision.util;

import glair.vision.api.Config;
import glair.vision.logger.Logger;
import glair.vision.model.Request;
import glair.vision.util.Base64;
import glair.vision.util.Json;
import java.io.File;
import java.io.FileInputStream;
import java.net.URLConnection;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class Util {
    private static final Logger logger = Logger.getInstance();
    private static final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(5L, TimeUnit.MINUTES).writeTimeout(5L, TimeUnit.MINUTES).readTimeout(5L, TimeUnit.MINUTES).build();

    public static String visionFetch(Config config, Request request) throws Exception {
        String method = request.getMethod();
        String apiEndpoint = config.getUrl(request.getPath());
        logger.debug("URL", Json.toJsonString("url", apiEndpoint));
        logger.debug(config);
        Request.Builder httpRequestBuilder = new Request.Builder().header("Authorization", config.getBasicAuth()).header("x-api-key", config.getApiKey()).header("GLAIR-Vision-Java-SDK-Version", "0.0.1-beta.1").url(apiEndpoint);
        if (method.equalsIgnoreCase("GET")) {
            httpRequestBuilder.get();
        } else if (method.equalsIgnoreCase("POST")) {
            httpRequestBuilder.post(request.getBody());
        }
        okhttp3.Request httpRequest = httpRequestBuilder.build();
        try (Response response = client.newCall(httpRequest).execute();){
            String body;
            String string = body = response.body() != null ? response.body().string() : "null";
            if (response.isSuccessful()) {
                String string2 = body;
                return string2;
            }
            throw new Exception(body);
        }
    }

    public static MultipartBody.Builder createFormData() {
        return new MultipartBody.Builder().setType(MultipartBody.FORM);
    }

    public static void addFileToFormData(MultipartBody.Builder builder, String fieldName, String filePath) {
        File file = new File(filePath);
        RequestBody filePart = RequestBody.create((File)file, (MediaType)MediaType.parse((String)Util.getMimeType(file)));
        builder.addFormDataPart(fieldName, file.getName(), filePart);
    }

    public static void addTextToFormData(MultipartBody.Builder builder, String fieldName, String fieldValue) {
        builder.addFormDataPart(fieldName, fieldValue);
    }

    private static String getMimeType(File file) {
        return URLConnection.guessContentTypeFromName(file.getName());
    }

    public static String fileToBase64(String filePath) throws Exception {
        File file = new File(filePath);
        byte[] buffer = new byte[(int)file.length() + 100];
        int length = new FileInputStream(file).read(buffer);
        return Base64.encodeToString(buffer, 0, length, 0);
    }

    public static void require(String key, String value) throws Exception {
        if (value == null) {
            throw new Exception("Require " + key);
        }
    }

    public static String trimAll(String str) {
        return str.replaceAll("\\s+", "");
    }

    public static void checkFileExist(String filePath) throws Exception {
        File file = new File(filePath);
        if (!file.exists()) {
            throw new Exception("The file does not exist.");
        }
    }
}

