/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.factory;

import ai.grakn.Keyspace;
import ai.grakn.factory.JanusPreviousPropertyStepStrategy;
import ai.grakn.factory.TxFactoryAbstract;
import ai.grakn.kb.internal.GraknTxJanus;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.LazyBarrierStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.PathRetractionStrategy;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.Namifiable;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.core.VertexLabel;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TxFactoryJanus
extends TxFactoryAbstract<GraknTxJanus, JanusGraph> {
    private static final Logger LOG = LoggerFactory.getLogger(TxFactoryJanus.class);
    private static final AtomicBoolean strategiesApplied = new AtomicBoolean(false);
    static final Properties DEFAULT_PROPERTIES;
    private static final Map<String, String> overrideMap;
    private static final Map<String, String> storageBackendMapper;

    TxFactoryJanus(Keyspace keyspace, String engineUrl, Properties properties) {
        super(keyspace, engineUrl, properties);
    }

    public JanusGraph getGraphWithNewTransaction(JanusGraph graph, boolean batchloading) {
        if (graph.isClosed()) {
            graph = this.buildTinkerPopGraph(batchloading);
        }
        if (!graph.tx().isOpen()) {
            graph.tx().open();
        }
        return graph;
    }

    GraknTxJanus buildGraknGraphFromTinker(JanusGraph graph) {
        return new GraknTxJanus(graph, this.keyspace, this.engineUrl, this.properties);
    }

    JanusGraph buildTinkerPopGraph(boolean batchLoading) {
        return this.newJanusGraph(this.keyspace, this.engineUrl, this.properties, batchLoading);
    }

    private synchronized JanusGraph newJanusGraph(Keyspace keyspace, String address, Properties properties, boolean batchLoading) {
        JanusGraph JanusGraph2 = this.configureGraph(keyspace, address, properties, batchLoading);
        TxFactoryJanus.buildJanusIndexes(JanusGraph2);
        JanusGraph2.tx().onClose((Consumer)Transaction.CLOSE_BEHAVIOR.ROLLBACK);
        if (!strategiesApplied.getAndSet(true)) {
            TraversalStrategies strategies = TraversalStrategies.GlobalCache.getStrategies(StandardJanusGraph.class);
            strategies = strategies.clone().addStrategies(new TraversalStrategy[]{new JanusPreviousPropertyStepStrategy()});
            strategies.removeStrategies(new Class[]{PathRetractionStrategy.class, LazyBarrierStrategy.class});
            TraversalStrategies.GlobalCache.registerStrategies(StandardJanusGraph.class, (TraversalStrategies)strategies);
            TraversalStrategies.GlobalCache.registerStrategies(StandardJanusGraphTx.class, (TraversalStrategies)strategies);
        }
        return JanusGraph2;
    }

    private JanusGraph configureGraph(Keyspace keyspace, String address, Properties properties, boolean batchLoading) {
        JanusGraphFactory.Builder builder = JanusGraphFactory.build().set("storage.hostname", (Object)address).set("storage.cassandra.keyspace", (Object)keyspace.getValue()).set("storage.batch-loading", (Object)batchLoading);
        String storageBackend = "storage.backend";
        DEFAULT_PROPERTIES.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> builder.set(key.toString(), value)));
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (key.equals(storageBackend)) {
                value = storageBackendMapper.get(value);
            }
            if (overrideMap.containsKey(key)) {
                builder.set(overrideMap.get(key), value);
            }
            builder.set(key.toString(), value);
        }));
        LOG.debug("Opening graph on {}", (Object)address);
        return builder.open();
    }

    private static void buildJanusIndexes(JanusGraph graph) {
        JanusGraphManagement management = graph.openManagement();
        TxFactoryJanus.makeVertexLabels(management);
        TxFactoryJanus.makeEdgeLabels(management);
        TxFactoryJanus.makePropertyKeys(management);
        TxFactoryJanus.makeIndicesVertexCentric(management);
        TxFactoryJanus.makeIndicesComposite(management);
        management.commit();
    }

    private static void makeEdgeLabels(JanusGraphManagement management) {
        for (Schema.EdgeLabel edgeLabel : Schema.EdgeLabel.values()) {
            EdgeLabel label = management.getEdgeLabel(edgeLabel.getLabel());
            if (label != null) continue;
            management.makeEdgeLabel(edgeLabel.getLabel()).make();
        }
    }

    private static void makeVertexLabels(JanusGraphManagement management) {
        for (Schema.BaseType baseType : Schema.BaseType.values()) {
            VertexLabel foundLabel = management.getVertexLabel(baseType.name());
            if (foundLabel != null) continue;
            management.makeVertexLabel(baseType.name()).make();
        }
    }

    private static void makeIndicesVertexCentric(JanusGraphManagement management) {
        ResourceBundle keys = ResourceBundle.getBundle("indices-edges");
        Set<String> edgeLabels = keys.keySet();
        for (String edgeLabel : edgeLabels) {
            String[] propertyKeyStrings = keys.getString(edgeLabel).split(",");
            Set<PropertyKey> propertyKeys = Arrays.stream(propertyKeyStrings).map(keyId -> {
                PropertyKey key = management.getPropertyKey(keyId);
                if (key == null) {
                    throw new RuntimeException("Trying to create edge index on label [" + edgeLabel + "] but the property [" + keyId + "] does not exist");
                }
                return key;
            }).collect(Collectors.toSet());
            RelationType relationType = management.getRelationType(edgeLabel);
            EdgeLabel label = management.getEdgeLabel(edgeLabel);
            for (PropertyKey key : propertyKeys) {
                if (management.getRelationIndex(relationType, edgeLabel + "by" + key.name()) != null) continue;
                management.buildEdgeIndex(label, edgeLabel + "by" + key.name(), Direction.BOTH, Order.decr, new PropertyKey[]{key});
            }
            String propertyKeyId = propertyKeys.stream().map(Namifiable::name).collect(Collectors.joining("_"));
            if (management.getRelationIndex(relationType, edgeLabel + "by" + propertyKeyId) != null) continue;
            PropertyKey[] allKeys = propertyKeys.toArray(new PropertyKey[propertyKeys.size()]);
            management.buildEdgeIndex(label, edgeLabel + "by" + propertyKeyId, Direction.BOTH, Order.decr, allKeys);
        }
    }

    private static void makePropertyKeys(JanusGraphManagement management) {
        Arrays.stream(Schema.VertexProperty.values()).forEach(property -> TxFactoryJanus.makePropertyKey(management, property.name(), property.getDataType()));
        Arrays.stream(Schema.EdgeProperty.values()).forEach(property -> TxFactoryJanus.makePropertyKey(management, property.name(), property.getDataType()));
    }

    private static void makePropertyKey(JanusGraphManagement management, String propertyKey, Class type) {
        if (management.getPropertyKey(propertyKey) == null) {
            management.makePropertyKey(propertyKey).dataType(type).make();
        }
    }

    private static void makeIndicesComposite(JanusGraphManagement management) {
        ResourceBundle keys = ResourceBundle.getBundle("indices-composite");
        Set<String> keyString = keys.keySet();
        for (String propertyKeyLabel : keyString) {
            String indexLabel = "by" + propertyKeyLabel;
            JanusGraphIndex index = management.getGraphIndex(indexLabel);
            if (index != null) continue;
            boolean isUnique = Boolean.parseBoolean(keys.getString(propertyKeyLabel));
            PropertyKey key = management.getPropertyKey(propertyKeyLabel);
            JanusGraphManagement.IndexBuilder indexBuilder = management.buildIndex(indexLabel, Vertex.class).addKey(key);
            if (isUnique) {
                indexBuilder.unique();
            }
            indexBuilder.buildCompositeIndex();
        }
    }

    static {
        String DEFAULT_CONFIG = "default-configs.properties";
        DEFAULT_PROPERTIES = new Properties();
        try (InputStream in = TxFactoryJanus.class.getClassLoader().getResourceAsStream(DEFAULT_CONFIG);){
            DEFAULT_PROPERTIES.load(in);
            in.close();
        }
        catch (IOException e) {
            throw new RuntimeException(ErrorMessage.INVALID_PATH_TO_CONFIG.getMessage(new Object[]{DEFAULT_CONFIG}), e);
        }
        overrideMap = ImmutableMap.of((Object)"storage.backend", (Object)"janusmr.ioformat.conf.storage.backend", (Object)"storage.hostname", (Object)"janusmr.ioformat.conf.storage.hostname");
        storageBackendMapper = ImmutableMap.of((Object)"grakn-production", (Object)"cassandra");
    }
}

