/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.kb.internal;

import ai.grakn.GraknTxType;
import ai.grakn.Keyspace;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.exception.GraknBackendException;
import ai.grakn.exception.TemporaryWriteException;
import ai.grakn.kb.internal.GraknTxAbstract;
import ai.grakn.kb.internal.concept.ConceptImpl;
import ai.grakn.kb.internal.structure.VertexElement;
import ai.grakn.util.Schema;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.util.JanusGraphCleanup;
import org.janusgraph.diskstorage.locking.PermanentLockingException;
import org.janusgraph.diskstorage.locking.TemporaryLockingException;
import org.janusgraph.graphdb.database.StandardJanusGraph;

public class GraknTxJanus
extends GraknTxAbstract<JanusGraph> {
    public GraknTxJanus(JanusGraph graph, Keyspace keyspace, String engineUrl, Properties properties) {
        super((Graph)graph, keyspace, engineUrl, properties);
    }

    public boolean isConceptModified(Concept concept) {
        if (concept instanceof ConceptImpl) {
            JanusGraphVertex vertex = (JanusGraphVertex)((ConceptImpl)concept).vertex().element();
            return vertex.isModified() || vertex.isNew();
        }
        return true;
    }

    public void openTransaction(GraknTxType txType) {
        super.openTransaction(txType);
        if (((JanusGraph)this.getTinkerPopGraph()).isOpen() && !((JanusGraph)this.getTinkerPopGraph()).tx().isOpen()) {
            ((JanusGraph)this.getTinkerPopGraph()).tx().open();
        }
    }

    public boolean isSessionClosed() {
        return ((JanusGraph)this.getTinkerPopGraph()).isClosed();
    }

    public int numOpenTx() {
        return ((StandardJanusGraph)this.getTinkerPopGraph()).getOpenTransactions().size();
    }

    protected void clearGraph() {
        JanusGraphCleanup.clear((JanusGraph)((JanusGraph)this.getTinkerPopGraph()));
    }

    public void commitTransactionInternal() {
        this.executeLockingMethod(() -> {
            super.commitTransactionInternal();
            return null;
        });
    }

    public VertexElement addVertexElement(Schema.BaseType baseType, ConceptId ... conceptIds) {
        return this.executeLockingMethod(() -> super.addVertexElement(baseType, conceptIds));
    }

    private <X> X executeLockingMethod(Supplier<X> method) {
        try {
            return method.get();
        }
        catch (JanusGraphException e) {
            if (e.isCausedBy(TemporaryLockingException.class) || e.isCausedBy(PermanentLockingException.class)) {
                throw TemporaryWriteException.temporaryLock((Exception)((Object)e));
            }
            throw GraknBackendException.unknown((Exception)((Object)e));
        }
    }

    public boolean validElement(Element element) {
        return super.validElement(element) && !((JanusGraphElement)element).isRemoved();
    }
}

