/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.owl;

import ai.grakn.concept.TypeLabel;
import ai.grakn.migration.owl.OwlModel;
import ai.grakn.util.Schema;
import org.semanticweb.owlapi.model.IRI;

public interface Namer {
    default public String fromIri(IRI iri) {
        return iri.getShortForm();
    }

    default public String fromIri(String iriAsString) {
        return this.fromIri(IRI.create((String)iriAsString));
    }

    default public String individualEntityName(IRI individualIri) {
        return "e" + this.fromIri(individualIri);
    }

    default public String classEntityTypeLabel(IRI classIri) {
        return "t" + this.fromIri(classIri);
    }

    default public String objectPropertyName(IRI propIri) {
        return "op-" + this.fromIri(propIri);
    }

    default public String resourceRelation(IRI dataPropertyIRI) {
        return "has-" + dataPropertyIRI.getShortForm();
    }

    default public TypeLabel objectRole(TypeLabel relationLabel) {
        return relationLabel.map(relation -> OwlModel.OBJECT.owlname() + "-" + relation);
    }

    default public TypeLabel subjectRole(TypeLabel relationLabel) {
        return relationLabel.map(relation -> OwlModel.SUBJECT.owlname() + "-" + relation);
    }

    default public TypeLabel entityRole(TypeLabel resourceTypeLabel) {
        return Schema.ImplicitType.HAS_OWNER.getLabel(resourceTypeLabel);
    }

    default public TypeLabel resourceRelation(TypeLabel resourceTypeLabel) {
        return Schema.ImplicitType.HAS.getLabel(resourceTypeLabel);
    }

    default public TypeLabel resourceRole(TypeLabel resourceTypeLabel) {
        return Schema.ImplicitType.HAS_VALUE.getLabel(resourceTypeLabel);
    }
}

