/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.owl;

import ai.grakn.Grakn;
import ai.grakn.GraknGraph;
import ai.grakn.GraknTxType;
import ai.grakn.migration.base.MigrationCLI;
import ai.grakn.migration.base.MigrationOptions;
import ai.grakn.migration.owl.OWLMigrator;
import ai.grakn.migration.owl.OwlMigrationOptions;
import java.io.File;
import java.util.Optional;
import org.semanticweb.owlapi.apibinding.OWLManager;

public class Main {
    public static void main(String[] args) {
        try {
            MigrationCLI.init((String[])args, OwlMigrationOptions::new).stream().filter(Optional::isPresent).map(Optional::get).forEach(Main::runOwl);
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
        }
    }

    private static void runOwl(OwlMigrationOptions options) {
        File owlfile = new File(options.getInput());
        if (!owlfile.exists()) {
            throw new IllegalArgumentException("Cannot find file: " + options.getInput());
        }
        MigrationCLI.printInitMessage((MigrationOptions)options);
        OWLMigrator migrator = new OWLMigrator();
        try (GraknGraph graph = Grakn.session((String)options.getUri(), (String)options.getKeyspace()).open(GraknTxType.WRITE);){
            migrator.graph(graph).ontology(OWLManager.createOWLOntologyManager().loadOntologyFromOntologyDocument(owlfile)).migrate();
            MigrationCLI.printWholeCompletionMessage((MigrationOptions)options);
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
        }
    }
}

