/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.owl;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Entity;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Label;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.Resource;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Thing;
import ai.grakn.exception.GraphOperationException;
import ai.grakn.graql.internal.reasoner.utils.ReasonerUtils;
import ai.grakn.migration.owl.OWLMigrator;
import ai.grakn.migration.owl.OwlModel;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.util.Pair;
import org.semanticweb.owlapi.model.AsOWLObjectProperty;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

public class OwlGraknGraphStoringVisitor
implements OWLAxiomVisitorEx<Concept>,
OWLEntityVisitorEx<Concept> {
    private final OWLMigrator migrator;

    public OwlGraknGraphStoringVisitor(OWLMigrator migrator) {
        this.migrator = migrator;
    }

    public OwlGraknGraphStoringVisitor prepareOWL() {
        this.migrator.entityType(this.migrator.ontology().getOWLOntologyManager().getOWLDataFactory().getOWLClass(OwlModel.THING.owlname()));
        this.migrator.relation(this.migrator.ontology().getOWLOntologyManager().getOWLDataFactory().getOWLObjectProperty(OwlModel.OBJECT_PROPERTY.owlname())).relates(this.migrator.graph().putRole(OwlModel.OBJECT.owlname())).relates(this.migrator.graph().putRole(OwlModel.SUBJECT.owlname()));
        return this;
    }

    public Concept visit(OWLClass ce) {
        return this.migrator.entityType(ce);
    }

    public Concept visit(OWLObjectProperty property) {
        return this.migrator.relation(property);
    }

    public Concept visit(OWLDataProperty property) {
        return this.migrator.resourceType(property);
    }

    public Concept visit(OWLAnnotationProperty property) {
        return this.migrator.relation(property);
    }

    public Concept visit(OWLNamedIndividual individual) {
        return this.migrator.entity(individual);
    }

    public Concept visit(OWLDeclarationAxiom axiom) {
        return (Concept)axiom.getEntity().accept((OWLEntityVisitorEx)this);
    }

    public Concept visit(OWLSubClassOfAxiom axiom) {
        OWLClassExpression subclass = axiom.getSubClass();
        if (!subclass.isOWLClass()) {
            return null;
        }
        EntityType subtype = this.migrator.entityType(subclass.asOWLClass());
        OWLClassExpression superclass = axiom.getSuperClass();
        if (!superclass.isOWLClass()) {
            return null;
        }
        EntityType supertype = this.migrator.entityType(superclass.asOWLClass());
        if (!supertype.equals(subtype.sup())) {
            subtype.sup(supertype);
        }
        return null;
    }

    public Concept visit(OWLObjectPropertyDomainAxiom axiom) {
        if (!((OWLObjectPropertyExpression)axiom.getProperty()).isOWLObjectProperty()) {
            return null;
        }
        RelationType objectRelation = this.migrator.relation(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty());
        if (((OWLClassExpression)axiom.getDomain()).isOWLClass()) {
            EntityType entityType = this.migrator.entityType(((OWLClassExpression)axiom.getDomain()).asOWLClass());
            Role domain = this.migrator.subjectRole(objectRelation);
            this.migrator.owlThingEntityType().deletePlays(domain);
            entityType.plays(domain);
            objectRelation.relates(domain);
        }
        return objectRelation;
    }

    public Concept visit(OWLObjectPropertyRangeAxiom axiom) {
        if (!((OWLObjectPropertyExpression)axiom.getProperty()).isOWLObjectProperty()) {
            return null;
        }
        RelationType objectRelation = this.migrator.relation(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty());
        if (((OWLClassExpression)axiom.getRange()).isOWLClass()) {
            EntityType entityType = this.migrator.entityType(((OWLClassExpression)axiom.getRange()).asOWLClass());
            Role range = this.migrator.objectRole(objectRelation);
            objectRelation.relates(range);
            this.migrator.owlThingEntityType().deletePlays(range);
            entityType.plays(range);
        }
        return objectRelation;
    }

    public Concept visit(OWLSubObjectPropertyOfAxiom axiom) {
        if (!((OWLObjectPropertyExpression)axiom.getSubProperty()).isOWLObjectProperty() || !((OWLObjectPropertyExpression)axiom.getSuperProperty()).isOWLObjectProperty()) {
            return null;
        }
        RelationType subRelation = this.migrator.relation(((OWLObjectPropertyExpression)axiom.getSubProperty()).asOWLObjectProperty());
        RelationType superRelation = this.migrator.relation(((OWLObjectPropertyExpression)axiom.getSuperProperty()).asOWLObjectProperty());
        HashMap<Label, Label> roleMap = new HashMap<Label, Label>();
        roleMap.put(this.migrator.namer().subjectRole(superRelation.getLabel()), this.migrator.namer().subjectRole(subRelation.getLabel()));
        roleMap.put(this.migrator.namer().objectRole(superRelation.getLabel()), this.migrator.namer().objectRole(subRelation.getLabel()));
        ReasonerUtils.createSubPropertyRule((RelationType)superRelation, (RelationType)subRelation, roleMap, (GraknGraph)this.migrator.graph());
        this.migrator.subjectRole(subRelation).sup(this.migrator.subjectRole(superRelation));
        this.migrator.objectRole(subRelation).sup(this.migrator.objectRole(superRelation));
        subRelation.sup(superRelation);
        return null;
    }

    public Concept visit(OWLSubDataPropertyOfAxiom axiom) {
        if (!((OWLDataPropertyExpression)axiom.getSubProperty()).isOWLDataProperty() || !((OWLDataPropertyExpression)axiom.getSuperProperty()).isOWLDataProperty()) {
            return null;
        }
        RelationType subRelation = this.migrator.relation(((OWLDataPropertyExpression)axiom.getSubProperty()).asOWLDataProperty());
        RelationType superRelation = this.migrator.relation(((OWLDataPropertyExpression)axiom.getSuperProperty()).asOWLDataProperty());
        subRelation.sup(superRelation);
        return null;
    }

    public Concept visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        Set<OWLObjectPropertyExpression> properties = axiom.getAxiomWithoutAnnotations().properties().filter(AsOWLObjectProperty::isOWLObjectProperty).collect(Collectors.toSet());
        if ((long)properties.size() != axiom.getAxiomWithoutAnnotations().properties().count()) {
            return null;
        }
        for (OWLObjectPropertyExpression property : properties) {
            RelationType relation = this.migrator.relation(property.asOWLObjectProperty());
            properties.forEach(prop -> {
                RelationType eqRelation = this.migrator.relation(prop.asOWLObjectProperty());
                if (!relation.equals(eqRelation)) {
                    HashMap<Label, Label> roleMap = new HashMap<Label, Label>();
                    roleMap.put(this.migrator.namer().subjectRole(relation.getLabel()), this.migrator.namer().subjectRole(eqRelation.getLabel()));
                    roleMap.put(this.migrator.namer().objectRole(relation.getLabel()), this.migrator.namer().objectRole(eqRelation.getLabel()));
                    ReasonerUtils.createSubPropertyRule((RelationType)relation, (RelationType)eqRelation, roleMap, (GraknGraph)this.migrator.graph());
                }
            });
        }
        return null;
    }

    public Concept visit(OWLInverseObjectPropertiesAxiom axiom) {
        if (!axiom.getFirstProperty().isOWLObjectProperty() || !axiom.getSecondProperty().isOWLObjectProperty()) {
            return null;
        }
        RelationType relation = this.migrator.relation(axiom.getFirstProperty().asOWLObjectProperty());
        RelationType inverseRelation = this.migrator.relation(axiom.getSecondProperty().asOWLObjectProperty());
        HashMap<Label, Label> roleMapFD = new HashMap<Label, Label>();
        roleMapFD.put(this.migrator.namer().subjectRole(relation.getLabel()), this.migrator.namer().objectRole(inverseRelation.getLabel()));
        roleMapFD.put(this.migrator.namer().objectRole(relation.getLabel()), this.migrator.namer().subjectRole(inverseRelation.getLabel()));
        ReasonerUtils.createSubPropertyRule((RelationType)relation, (RelationType)inverseRelation, roleMapFD, (GraknGraph)this.migrator.graph());
        HashMap<Label, Label> roleMapBD = new HashMap<Label, Label>();
        roleMapBD.put(this.migrator.namer().subjectRole(inverseRelation.getLabel()), this.migrator.namer().objectRole(relation.getLabel()));
        roleMapBD.put(this.migrator.namer().objectRole(inverseRelation.getLabel()), this.migrator.namer().subjectRole(relation.getLabel()));
        ReasonerUtils.createSubPropertyRule((RelationType)inverseRelation, (RelationType)relation, roleMapBD, (GraknGraph)this.migrator.graph());
        return null;
    }

    public Concept visit(OWLTransitiveObjectPropertyAxiom axiom) {
        if (!((OWLObjectPropertyExpression)axiom.getProperty()).isOWLObjectProperty()) {
            return null;
        }
        RelationType relation = this.migrator.relation(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty());
        ReasonerUtils.createTransitiveRule((RelationType)relation, (Label)this.migrator.namer().subjectRole(relation.getLabel()), (Label)this.migrator.namer().objectRole(relation.getLabel()), (GraknGraph)this.migrator.graph());
        return null;
    }

    public Concept visit(OWLReflexiveObjectPropertyAxiom axiom) {
        if (!((OWLObjectPropertyExpression)axiom.getProperty()).isOWLObjectProperty()) {
            return null;
        }
        RelationType relation = this.migrator.relation(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty());
        ReasonerUtils.createReflexiveRule((RelationType)relation, (Label)this.migrator.namer().subjectRole(relation.getLabel()), (Label)this.migrator.namer().objectRole(relation.getLabel()), (GraknGraph)this.migrator.graph());
        return null;
    }

    public Concept visit(OWLSubPropertyChainOfAxiom axiom) {
        if (!axiom.getSuperProperty().isOWLObjectProperty()) {
            return null;
        }
        RelationType superRelation = this.migrator.relation(axiom.getSuperProperty().asOWLObjectProperty());
        LinkedHashMap chain = new LinkedHashMap();
        axiom.getPropertyChain().forEach(property -> {
            RelationType relation = this.migrator.relation(property.asOWLObjectProperty());
            chain.put(relation, new Pair((Object)this.migrator.namer().subjectRole(relation.getLabel()), (Object)this.migrator.namer().objectRole(relation.getLabel())));
        });
        ReasonerUtils.createPropertyChainRule((RelationType)superRelation, (Label)this.migrator.namer().subjectRole(superRelation.getLabel()), (Label)this.migrator.namer().objectRole(superRelation.getLabel()), chain, (GraknGraph)this.migrator.graph());
        return null;
    }

    public Concept visit(OWLClassAssertionAxiom axiom) {
        if (!axiom.getIndividual().isNamed()) {
            return null;
        }
        return this.migrator.entity(axiom.getIndividual().asOWLNamedIndividual());
    }

    public Concept visit(OWLObjectPropertyAssertionAxiom axiom) {
        if (!(axiom.getSubject().isNamed() && ((OWLIndividual)axiom.getObject()).isNamed() && ((OWLObjectPropertyExpression)axiom.getProperty()).isOWLObjectProperty())) {
            return null;
        }
        Entity subject = this.migrator.entity(axiom.getSubject().asOWLNamedIndividual());
        Entity object = this.migrator.entity(((OWLIndividual)axiom.getObject()).asOWLNamedIndividual());
        RelationType relationType = this.migrator.relation(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty());
        return relationType.addRelation().addRolePlayer(this.migrator.subjectRole(relationType), (Thing)subject).addRolePlayer(this.migrator.objectRole(relationType), (Thing)object);
    }

    public Concept visit(OWLDataPropertyAssertionAxiom axiom) {
        if (!((OWLDataPropertyExpression)axiom.getProperty()).isOWLDataProperty() || !axiom.getSubject().isNamed()) {
            return null;
        }
        ResourceType<?> resourceType = this.migrator.resourceType(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty());
        Entity entity = this.migrator.entity(axiom.getSubject().asOWLNamedIndividual());
        String valueAsString = ((OWLLiteral)axiom.getObject()).getLiteral();
        Object value = valueAsString;
        if (resourceType.getDataType() == ResourceType.DataType.BOOLEAN) {
            value = Boolean.parseBoolean(valueAsString);
        } else if (resourceType.getDataType() == ResourceType.DataType.LONG) {
            value = Long.parseLong(valueAsString);
        } else if (resourceType.getDataType() == ResourceType.DataType.DOUBLE) {
            value = Double.parseDouble(valueAsString);
        }
        Resource resource = resourceType.putResource(value);
        RelationType propertyRelation = this.migrator.relation(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty());
        Role entityRole = this.migrator.entityRole(entity.type(), resource.type());
        Role resourceRole = this.migrator.resourceRole(resource.type());
        try {
            return propertyRelation.addRelation().addRolePlayer(entityRole, (Thing)entity).addRolePlayer(resourceRole, (Thing)resource);
        }
        catch (GraphOperationException ex) {
            if (ex.getMessage().contains("The Relation with the provided role players already exists")) {
                System.err.println("[WARN] Grakn does not support multiple values per data property/resource, ignoring axiom " + axiom);
            } else {
                ex.printStackTrace(System.err);
            }
            return null;
        }
    }

    public Concept visit(OWLAnnotationAssertionAxiom axiom) {
        if (!(axiom.getSubject() instanceof OWLNamedIndividual)) {
            return null;
        }
        Optional value = axiom.getValue().asLiteral();
        if (!value.isPresent()) {
            return null;
        }
        ResourceType resourceType = (ResourceType)this.visit((OWLAnnotationProperty)axiom.getProperty());
        Entity entity = this.migrator.entity((OWLNamedIndividual)axiom.getSubject());
        Resource resource = resourceType.putResource((Object)((OWLLiteral)value.get()).getLiteral());
        RelationType propertyRelation = this.migrator.relation((OWLAnnotationProperty)axiom.getProperty());
        return propertyRelation.addRelation().addRolePlayer(this.migrator.entityRole(entity.type(), resource.type()), (Thing)entity).addRolePlayer(this.migrator.resourceRole(resource.type()), (Thing)resource);
    }

    public Concept visit(SWRLRule node) {
        return null;
    }
}

