/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.owl;

import ai.grakn.GraknTx;
import ai.grakn.concept.Attribute;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Entity;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Label;
import ai.grakn.concept.RelationshipType;
import ai.grakn.concept.Role;
import ai.grakn.concept.Thing;
import ai.grakn.exception.InvalidKBException;
import ai.grakn.migration.owl.Namer;
import ai.grakn.migration.owl.OwlGraknTxStoringVisitor;
import ai.grakn.migration.owl.OwlModel;
import ai.grakn.util.Schema;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class OWLMigrator {
    private Namer namer = new DefaultNamer();
    private OWLOntology ontology;
    private GraknTx tx;

    private <T> T eval(Supplier<T> f) {
        return f.get();
    }

    public OWLMigrator namer(Namer namer) {
        this.namer = namer;
        return this;
    }

    public Namer namer() {
        return this.namer;
    }

    public OWLMigrator ontology(OWLOntology ontology) {
        this.ontology = ontology;
        return this;
    }

    public OWLOntology ontology() {
        return this.ontology;
    }

    public OWLMigrator tx(GraknTx graph) {
        this.tx = graph;
        return this;
    }

    public GraknTx tx() {
        return this.tx;
    }

    public void migrate() throws InvalidKBException {
        OwlGraknTxStoringVisitor visitor = new OwlGraknTxStoringVisitor(this);
        visitor.prepareOWL();
        this.ontology.axioms().forEach(ax -> {
            Concept cfr_ignored_0 = (Concept)ax.accept((OWLAxiomVisitorEx)visitor);
        });
        this.tx.commit();
    }

    public AttributeType.DataType<?> owlBuiltInToGraknDatatype(OWL2Datatype propertyType) {
        if (propertyType == OWL2Datatype.XSD_BOOLEAN) {
            return AttributeType.DataType.BOOLEAN;
        }
        if (propertyType == OWL2Datatype.XSD_FLOAT || propertyType == OWL2Datatype.XSD_DOUBLE || propertyType == OWL2Datatype.OWL_REAL || propertyType == OWL2Datatype.OWL_RATIONAL || propertyType == OWL2Datatype.XSD_DECIMAL) {
            return AttributeType.DataType.DOUBLE;
        }
        if (propertyType.isNumeric()) {
            return AttributeType.DataType.LONG;
        }
        return AttributeType.DataType.STRING;
    }

    public EntityType owlThingEntityType() {
        return this.tx.putEntityType(this.namer.classEntityTypeLabel(this.ontology.getOWLOntologyManager().getOWLDataFactory().getOWLClass(OwlModel.THING.owlname()).getIRI()));
    }

    public AttributeType<String> owlIriResource() {
        return this.tx.putAttributeType(OwlModel.IRI.owlname(), AttributeType.DataType.STRING);
    }

    @Nullable
    public <T> Entity getEntity(T id, AttributeType<T> rtype) {
        Attribute iri = rtype.getAttribute(id);
        Thing inst = iri != null ? (Thing)iri.ownerInstances().findFirst().orElse(null) : null;
        return inst != null ? inst.asEntity() : null;
    }

    public Entity putEntity(String id, EntityType type) {
        Entity current = this.getEntity(id, this.owlIriResource());
        if (current != null) {
            return current;
        }
        Label hasIriResourceId = Label.of((String)OwlModel.IRI.owlname());
        AttributeType<String> iriResource = this.owlIriResource();
        Role hasIriOwner = this.entityRole(type, iriResource);
        Role hasIriValue = this.resourceRole(iriResource);
        RelationshipType hasIriRelation = this.tx.putRelationshipType(this.namer.resourceRelation(hasIriResourceId)).relates(hasIriOwner).relates(hasIriValue);
        Entity entity = type.addEntity();
        Attribute attributeInstance = iriResource.putAttribute((Object)id);
        hasIriRelation.addRelationship().addRolePlayer(hasIriOwner, (Thing)entity).addRolePlayer(hasIriValue, (Thing)attributeInstance);
        return entity;
    }

    public EntityType entityType(OWLClass owlclass) {
        EntityType type = this.tx.putEntityType(this.namer.classEntityTypeLabel(owlclass.getIRI()));
        EntityType thing = this.owlThingEntityType();
        if (Schema.MetaSchema.isMetaLabel((Label)type.sup().getLabel()) && !type.equals(thing)) {
            type.sup(thing);
        }
        return type;
    }

    public Entity entity(OWLNamedIndividual individual) {
        String id = this.namer.individualEntityName(individual.getIRI());
        Entity entity = (Entity)this.tx.getConcept(ConceptId.of((String)id));
        if (entity != null) {
            return entity;
        }
        OWLClass owlclass = this.eval(() -> {
            Optional<OWLClassAssertionAxiom> expr = this.ontology.classAssertionAxioms((OWLIndividual)individual).filter(ax -> ax.getClassExpression().isOWLClass()).findFirst();
            return expr.isPresent() ? expr.get().getClassExpression().asOWLClass() : null;
        });
        return this.putEntity(id, owlclass == null ? this.owlThingEntityType() : this.entityType(owlclass));
    }

    public RelationshipType relation(OWLObjectProperty property) {
        RelationshipType relType = this.tx.putRelationshipType(this.namer.objectPropertyName(property.getIRI()));
        Role subjectRole = this.subjectRole(relType);
        Role objectRole = this.objectRole(relType);
        relType.relates(subjectRole);
        relType.relates(objectRole);
        EntityType top = this.owlThingEntityType();
        top.plays(subjectRole);
        top.plays(objectRole);
        return relType;
    }

    public RelationshipType relation(OWLDataProperty property) {
        RelationshipType relType = this.tx.putRelationshipType(this.namer.resourceRelation(property.getIRI()));
        AttributeType<?> attributeType = this.resourceType(property);
        relType.relates(this.entityRole(this.owlThingEntityType(), attributeType));
        relType.relates(this.resourceRole(attributeType));
        return relType;
    }

    public RelationshipType relation(OWLAnnotationProperty property) {
        RelationshipType relType = this.tx.putRelationshipType(this.namer.resourceRelation(property.getIRI()));
        AttributeType attributeType = this.tx.putAttributeType(this.namer.fromIri(property.getIRI()), AttributeType.DataType.STRING);
        relType.relates(this.entityRole(this.owlThingEntityType(), attributeType));
        relType.relates(this.resourceRole(attributeType));
        return relType;
    }

    public Role subjectRole(RelationshipType relType) {
        return this.tx.putRole(this.namer.subjectRole(relType.getLabel()));
    }

    public Role objectRole(RelationshipType relType) {
        return this.tx.putRole(this.namer.objectRole(relType.getLabel()));
    }

    public Role entityRole(EntityType entityType, AttributeType<?> attributeType) {
        Role role = this.tx.putRole(this.namer.entityRole(attributeType.getLabel()));
        entityType.plays(role);
        return role;
    }

    public Role resourceRole(AttributeType<?> attributeType) {
        Role role = this.tx.putRole(this.namer.resourceRole(attributeType.getLabel()));
        attributeType.plays(role);
        return role;
    }

    public AttributeType<?> resourceType(OWLDataProperty property) {
        OWL2Datatype propertyType = this.eval(() -> {
            Optional<OWLDataPropertyRangeAxiom> ax = this.ontology.dataPropertyRangeAxioms(property).filter(rangeAxiom -> ((OWLDataRange)rangeAxiom.getRange()).isOWLDatatype() && ((OWLDataRange)rangeAxiom.getRange()).asOWLDatatype().isBuiltIn()).findFirst();
            return ax.isPresent() ? ((OWLDataRange)ax.get().getRange()).asOWLDatatype().getBuiltInDatatype() : null;
        });
        AttributeType.DataType<?> graknType = propertyType == null ? AttributeType.DataType.STRING : this.owlBuiltInToGraknDatatype(propertyType);
        AttributeType attributeType = this.tx.putAttributeType(this.namer.fromIri(property.getIRI()), graknType);
        return attributeType;
    }

    private static class DefaultNamer
    implements Namer {
        private DefaultNamer() {
        }
    }
}

