/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.owl;

import ai.grakn.migration.base.io.MigrationCLI;
import ai.grakn.migration.owl.OWLMigrator;
import java.io.File;
import org.apache.commons.cli.Options;
import org.semanticweb.owlapi.apibinding.OWLManager;

public class Main {
    private static Options options = new Options();

    public static void main(String[] args) {
        MigrationCLI.create((String[])args, (Options)options).ifPresent(Main::runOwl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runOwl(MigrationCLI cli) {
        String owlFilename = cli.getRequiredOption("input", "Please specify owl file with the -i option.");
        File owlfile = new File(owlFilename);
        if (!owlfile.exists()) {
            cli.die("Cannot find file: " + owlFilename);
        }
        cli.printInitMessage(owlfile.getPath());
        OWLMigrator migrator = new OWLMigrator();
        try {
            migrator.graph(cli.getGraph()).ontology(OWLManager.createOWLOntologyManager().loadOntologyFromOntologyDocument(owlfile)).migrate();
            cli.printWholeCompletionMessage();
        }
        catch (Throwable t) {
            cli.die(t);
        }
        finally {
            if (migrator.graph() != null) {
                migrator.graph().close();
            }
        }
        cli.initiateShutdown();
    }

    static {
        options.addOption("i", "input", true, "input owl file");
    }
}

