/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.owl;

import ai.grakn.concept.Entity;
import ai.grakn.concept.ResourceType;
import ai.grakn.migration.owl.OwlModel;
import org.semanticweb.owlapi.model.IRI;

public interface Namer {
    default public String fromIri(IRI iri) {
        return iri.getShortForm();
    }

    default public String fromIri(String iriAsString) {
        return this.fromIri(IRI.create((String)iriAsString));
    }

    default public String individualEntityName(IRI individualIri) {
        return "e" + this.fromIri(individualIri);
    }

    default public String classEntityTypeName(IRI classIri) {
        return "t" + this.fromIri(classIri);
    }

    default public String objectPropertyName(IRI propIri) {
        return "op-" + this.fromIri(propIri);
    }

    default public String resourceRelation(IRI dataPropertyIRI) {
        return "has-" + dataPropertyIRI.getShortForm();
    }

    default public String objectRole(String relationId) {
        return OwlModel.OBJECT.owlname() + "-" + relationId;
    }

    default public String subjectRole(String relationId) {
        return OwlModel.SUBJECT.owlname() + "-" + relationId;
    }

    default public String entityRole(String resourceId) {
        return "has-" + resourceId + "-owner";
    }

    default public String resourceRelation(String resourceId) {
        return "has-" + resourceId;
    }

    default public String resourceRole(String resourceId) {
        return "has-" + resourceId + "-value";
    }

    default public String resourceId(Entity entity, ResourceType<?> resourceType) {
        return "resource-" + resourceType.getId() + "-" + entity.getId();
    }
}

