/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.owl;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Entity;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Instance;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.Resource;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.RoleType;
import ai.grakn.exception.GraknValidationException;
import ai.grakn.migration.owl.Namer;
import ai.grakn.migration.owl.OwlGraknGraphStoringVisitor;
import ai.grakn.migration.owl.OwlModel;
import java.util.Optional;
import java.util.function.Supplier;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class OWLMigrator {
    private Namer namer = new Namer(){};
    private OWLOntology ontology;
    private GraknGraph graph;

    private <T> T eval(Supplier<T> f) {
        return f.get();
    }

    public OWLMigrator namer(Namer namer) {
        this.namer = namer;
        return this;
    }

    public Namer namer() {
        return this.namer;
    }

    public OWLMigrator ontology(OWLOntology ontology) {
        this.ontology = ontology;
        return this;
    }

    public OWLOntology ontology() {
        return this.ontology;
    }

    public OWLMigrator graph(GraknGraph graph) {
        this.graph = graph;
        return this;
    }

    public GraknGraph graph() {
        return this.graph;
    }

    public void migrate() throws GraknValidationException {
        OwlGraknGraphStoringVisitor visitor = new OwlGraknGraphStoringVisitor(this);
        visitor.prepareOWL();
        this.ontology.axioms().forEach(ax -> ax.accept((OWLAxiomVisitorEx)visitor));
        this.graph.commit();
    }

    public ResourceType.DataType<?> owlBuiltInToGraknDatatype(OWL2Datatype propertyType) {
        if (propertyType == OWL2Datatype.XSD_BOOLEAN) {
            return ResourceType.DataType.BOOLEAN;
        }
        if (propertyType == OWL2Datatype.XSD_FLOAT || propertyType == OWL2Datatype.XSD_DOUBLE || propertyType == OWL2Datatype.OWL_REAL || propertyType == OWL2Datatype.OWL_RATIONAL || propertyType == OWL2Datatype.XSD_DECIMAL) {
            return ResourceType.DataType.DOUBLE;
        }
        if (propertyType.isNumeric()) {
            return ResourceType.DataType.LONG;
        }
        return ResourceType.DataType.STRING;
    }

    public EntityType owlThingEntityType() {
        return this.graph.putEntityType(this.namer.classEntityTypeName(this.ontology.getOWLOntologyManager().getOWLDataFactory().getOWLClass(OwlModel.THING.owlname()).getIRI()));
    }

    public ResourceType<String> owlIriResource() {
        return this.graph.putResourceType(OwlModel.IRI.owlname(), ResourceType.DataType.STRING);
    }

    public <T> Entity getEntity(T id, ResourceType<T> rtype) {
        Resource iri = this.graph.getResource(id, rtype);
        Instance inst = iri != null ? (Instance)iri.ownerInstances().stream().findFirst().orElse(null) : null;
        return inst != null ? inst.asEntity() : null;
    }

    public Entity putEntity(String id, EntityType type) {
        Entity current = this.getEntity(id, this.owlIriResource());
        if (current != null) {
            return current;
        }
        String hasIriResourceId = OwlModel.IRI.owlname();
        ResourceType<String> iriResource = this.owlIriResource();
        RoleType hasIriOwner = this.entityRole(type, iriResource);
        RoleType hasIriValue = this.resourceRole(iriResource);
        RelationType hasIriRelation = this.graph.putRelationType(this.namer.resourceRelation(hasIriResourceId)).hasRole(hasIriOwner).hasRole(hasIriValue);
        Entity entity = type.addEntity();
        Resource resourceInstance = iriResource.putResource((Object)id);
        hasIriRelation.addRelation().putRolePlayer(hasIriOwner, (Instance)entity).putRolePlayer(hasIriValue, (Instance)resourceInstance);
        return entity;
    }

    public EntityType entityType(OWLClass owlclass) {
        EntityType type = this.graph.putEntityType(this.namer.classEntityTypeName(owlclass.getIRI()));
        EntityType thing = this.owlThingEntityType();
        if (type.superType() == null && !type.equals(thing)) {
            type.superType(thing);
        }
        return type;
    }

    public Entity entity(OWLNamedIndividual individual) {
        String id = this.namer.individualEntityName(individual.getIRI());
        Entity entity = this.graph.getEntity(id);
        if (entity != null) {
            return entity;
        }
        OWLClass owlclass = this.eval(() -> {
            Optional<OWLClassAssertionAxiom> expr = this.ontology.classAssertionAxioms((OWLIndividual)individual).filter(ax -> ax.getClassExpression().isOWLClass()).findFirst();
            return expr.isPresent() ? expr.get().getClassExpression().asOWLClass() : null;
        });
        return this.putEntity(id, owlclass == null ? this.owlThingEntityType() : this.entityType(owlclass));
    }

    public RelationType relation(OWLObjectProperty property) {
        RelationType relType = this.graph.putRelationType(this.namer.objectPropertyName(property.getIRI()));
        RoleType subjectRole = this.subjectRole(relType);
        RoleType objectRole = this.objectRole(relType);
        relType.hasRole(subjectRole);
        relType.hasRole(objectRole);
        EntityType top = this.owlThingEntityType();
        top.playsRole(subjectRole);
        top.playsRole(objectRole);
        return relType;
    }

    public RelationType relation(OWLDataProperty property) {
        RelationType relType = this.graph.putRelationType(this.namer.resourceRelation(property.getIRI()));
        ResourceType<?> resourceType = this.resourceType(property);
        relType.hasRole(this.entityRole(this.owlThingEntityType(), resourceType));
        relType.hasRole(this.resourceRole(resourceType));
        return relType;
    }

    public RelationType relation(OWLAnnotationProperty property) {
        RelationType relType = this.graph.putRelationType(this.namer.resourceRelation(property.getIRI()));
        ResourceType resourceType = this.graph.putResourceType(this.namer.fromIri(property.getIRI()), ResourceType.DataType.STRING);
        relType.hasRole(this.entityRole(this.owlThingEntityType(), resourceType));
        relType.hasRole(this.resourceRole(resourceType));
        return relType;
    }

    public RoleType subjectRole(RelationType relType) {
        return this.graph.putRoleType(this.namer.subjectRole(relType.getId()));
    }

    public RoleType objectRole(RelationType relType) {
        return this.graph.putRoleType(this.namer.objectRole(relType.getId()));
    }

    public RoleType entityRole(EntityType entityType, ResourceType<?> resourceType) {
        RoleType roleType = this.graph.putRoleType(this.namer.entityRole(resourceType.getId()));
        entityType.playsRole(roleType);
        return roleType;
    }

    public RoleType resourceRole(ResourceType<?> resourceType) {
        RoleType roleType = this.graph.putRoleType(this.namer.resourceRole(resourceType.getId()));
        resourceType.playsRole(roleType);
        return roleType;
    }

    public ResourceType<?> resourceType(OWLDataProperty property) {
        OWL2Datatype propertyType = this.eval(() -> {
            Optional<OWLDataPropertyRangeAxiom> ax = this.ontology.dataPropertyRangeAxioms(property).filter(rangeAxiom -> ((OWLDataRange)rangeAxiom.getRange()).isOWLDatatype() && ((OWLDataRange)rangeAxiom.getRange()).asOWLDatatype().isBuiltIn()).findFirst();
            return ax.isPresent() ? ((OWLDataRange)ax.get().getRange()).asOWLDatatype().getBuiltInDatatype() : null;
        });
        ResourceType.DataType<?> graknType = propertyType == null ? ResourceType.DataType.STRING : this.owlBuiltInToGraknDatatype(propertyType);
        ResourceType resourceType = this.graph.putResourceType(this.namer.fromIri(property.getIRI()), graknType);
        return resourceType;
    }
}

