/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.migration.owl;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Entity;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Instance;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.Resource;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.RoleType;
import ai.grakn.exception.ConceptException;
import ai.grakn.graql.internal.reasoner.Utility;
import ai.grakn.migration.owl.OWLMigrator;
import ai.grakn.migration.owl.OwlModel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.util.Pair;
import org.semanticweb.owlapi.model.AsOWLObjectProperty;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntityVisitorEx;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;

public class OwlGraknGraphStoringVisitor
implements OWLAxiomVisitorEx<Concept>,
OWLEntityVisitorEx<Concept> {
    private OWLMigrator migrator;

    public OwlGraknGraphStoringVisitor(OWLMigrator migrator) {
        this.migrator = migrator;
    }

    public OwlGraknGraphStoringVisitor prepareOWL() {
        this.migrator.entityType(this.migrator.ontology().getOWLOntologyManager().getOWLDataFactory().getOWLClass(OwlModel.THING.owlname()));
        this.migrator.relation(this.migrator.ontology().getOWLOntologyManager().getOWLDataFactory().getOWLObjectProperty(OwlModel.OBJECT_PROPERTY.owlname())).hasRole(this.migrator.graph().putRoleType(OwlModel.OBJECT.owlname())).hasRole(this.migrator.graph().putRoleType(OwlModel.SUBJECT.owlname()));
        return this;
    }

    public Concept visit(OWLClass ce) {
        return this.migrator.entityType(ce);
    }

    public Concept visit(OWLObjectProperty property) {
        return this.migrator.relation(property);
    }

    public Concept visit(OWLDataProperty property) {
        return this.migrator.resourceType(property);
    }

    public Concept visit(OWLAnnotationProperty property) {
        return this.migrator.relation(property);
    }

    public Concept visit(OWLNamedIndividual individual) {
        return this.migrator.entity(individual);
    }

    public Concept visit(OWLDeclarationAxiom axiom) {
        return (Concept)axiom.getEntity().accept((OWLEntityVisitorEx)this);
    }

    public Concept visit(OWLSubClassOfAxiom axiom) {
        OWLClassExpression subclass = axiom.getSubClass();
        EntityType subtype = null;
        if (!subclass.isOWLClass()) {
            return null;
        }
        subtype = this.migrator.entityType(subclass.asOWLClass());
        OWLClassExpression superclass = axiom.getSuperClass();
        EntityType supertype = null;
        if (!superclass.isOWLClass()) {
            return null;
        }
        supertype = this.migrator.entityType(superclass.asOWLClass());
        if (!supertype.equals(subtype.superType())) {
            subtype.superType(supertype);
        }
        return null;
    }

    public Concept visit(OWLObjectPropertyDomainAxiom axiom) {
        if (!((OWLObjectPropertyExpression)axiom.getProperty()).isOWLObjectProperty()) {
            return null;
        }
        RelationType objectRelation = this.migrator.relation(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty());
        if (((OWLClassExpression)axiom.getDomain()).isOWLClass()) {
            EntityType entityType = this.migrator.entityType(((OWLClassExpression)axiom.getDomain()).asOWLClass());
            RoleType domain = this.migrator.subjectRole(objectRelation);
            this.migrator.owlThingEntityType().deletePlaysRole(domain);
            entityType.playsRole(domain);
            objectRelation.hasRole(domain);
        }
        return objectRelation;
    }

    public Concept visit(OWLObjectPropertyRangeAxiom axiom) {
        if (!((OWLObjectPropertyExpression)axiom.getProperty()).isOWLObjectProperty()) {
            return null;
        }
        RelationType objectRelation = this.migrator.relation(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty());
        if (((OWLClassExpression)axiom.getRange()).isOWLClass()) {
            EntityType entityType = this.migrator.entityType(((OWLClassExpression)axiom.getRange()).asOWLClass());
            RoleType range = this.migrator.objectRole(objectRelation);
            objectRelation.hasRole(range);
            this.migrator.owlThingEntityType().deletePlaysRole(range);
            entityType.playsRole(range);
        }
        return objectRelation;
    }

    public Concept visit(OWLSubObjectPropertyOfAxiom axiom) {
        if (!((OWLObjectPropertyExpression)axiom.getSubProperty()).isOWLObjectProperty() || !((OWLObjectPropertyExpression)axiom.getSuperProperty()).isOWLObjectProperty()) {
            return null;
        }
        RelationType subRelation = this.migrator.relation(((OWLObjectPropertyExpression)axiom.getSubProperty()).asOWLObjectProperty());
        RelationType superRelation = this.migrator.relation(((OWLObjectPropertyExpression)axiom.getSuperProperty()).asOWLObjectProperty());
        HashMap<String, String> roleMap = new HashMap<String, String>();
        roleMap.put(this.migrator.namer().subjectRole(superRelation.getId()), this.migrator.namer().subjectRole(subRelation.getId()));
        roleMap.put(this.migrator.namer().objectRole(superRelation.getId()), this.migrator.namer().objectRole(subRelation.getId()));
        Utility.createSubPropertyRule((RelationType)superRelation, (RelationType)subRelation, roleMap, (GraknGraph)this.migrator.graph());
        subRelation.superType(superRelation);
        return null;
    }

    public Concept visit(OWLSubDataPropertyOfAxiom axiom) {
        if (!((OWLDataPropertyExpression)axiom.getSubProperty()).isOWLDataProperty() || !((OWLDataPropertyExpression)axiom.getSuperProperty()).isOWLDataProperty()) {
            return null;
        }
        RelationType subRelation = this.migrator.relation(((OWLDataPropertyExpression)axiom.getSubProperty()).asOWLDataProperty());
        RelationType superRelation = this.migrator.relation(((OWLDataPropertyExpression)axiom.getSuperProperty()).asOWLDataProperty());
        subRelation.superType(superRelation);
        return null;
    }

    public Concept visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        Set<OWLObjectPropertyExpression> properties = axiom.getAxiomWithoutAnnotations().properties().filter(AsOWLObjectProperty::isOWLObjectProperty).collect(Collectors.toSet());
        if ((long)properties.size() != axiom.getAxiomWithoutAnnotations().properties().count()) {
            return null;
        }
        Iterator it = properties.iterator();
        while (it.hasNext()) {
            RelationType relation = this.migrator.relation(((OWLObjectPropertyExpression)it.next()).asOWLObjectProperty());
            properties.forEach(prop -> {
                RelationType eqRelation = this.migrator.relation(prop.asOWLObjectProperty());
                if (!relation.equals(eqRelation)) {
                    HashMap<String, String> roleMap = new HashMap<String, String>();
                    roleMap.put(this.migrator.namer().subjectRole(relation.getId()), this.migrator.namer().subjectRole(eqRelation.getId()));
                    roleMap.put(this.migrator.namer().objectRole(relation.getId()), this.migrator.namer().objectRole(eqRelation.getId()));
                    Utility.createSubPropertyRule((RelationType)relation, (RelationType)eqRelation, roleMap, (GraknGraph)this.migrator.graph());
                }
            });
        }
        return null;
    }

    public Concept visit(OWLInverseObjectPropertiesAxiom axiom) {
        if (!axiom.getFirstProperty().isOWLObjectProperty() || !axiom.getSecondProperty().isOWLObjectProperty()) {
            return null;
        }
        RelationType relation = this.migrator.relation(axiom.getFirstProperty().asOWLObjectProperty());
        RelationType inverseRelation = this.migrator.relation(axiom.getSecondProperty().asOWLObjectProperty());
        HashMap<String, String> roleMapFD = new HashMap<String, String>();
        roleMapFD.put(this.migrator.namer().subjectRole(relation.getId()), this.migrator.namer().objectRole(inverseRelation.getId()));
        roleMapFD.put(this.migrator.namer().objectRole(relation.getId()), this.migrator.namer().subjectRole(inverseRelation.getId()));
        Utility.createSubPropertyRule((RelationType)relation, (RelationType)inverseRelation, roleMapFD, (GraknGraph)this.migrator.graph());
        HashMap<String, String> roleMapBD = new HashMap<String, String>();
        roleMapBD.put(this.migrator.namer().subjectRole(inverseRelation.getId()), this.migrator.namer().objectRole(relation.getId()));
        roleMapBD.put(this.migrator.namer().objectRole(inverseRelation.getId()), this.migrator.namer().subjectRole(relation.getId()));
        Utility.createSubPropertyRule((RelationType)inverseRelation, (RelationType)relation, roleMapBD, (GraknGraph)this.migrator.graph());
        return null;
    }

    public Concept visit(OWLTransitiveObjectPropertyAxiom axiom) {
        if (!((OWLObjectPropertyExpression)axiom.getProperty()).isOWLObjectProperty()) {
            return null;
        }
        RelationType relation = this.migrator.relation(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty());
        Utility.createTransitiveRule((RelationType)relation, (String)this.migrator.namer().subjectRole(relation.getId()), (String)this.migrator.namer().objectRole(relation.getId()), (GraknGraph)this.migrator.graph());
        return null;
    }

    public Concept visit(OWLReflexiveObjectPropertyAxiom axiom) {
        if (!((OWLObjectPropertyExpression)axiom.getProperty()).isOWLObjectProperty()) {
            return null;
        }
        RelationType relation = this.migrator.relation(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty());
        Utility.createReflexiveRule((RelationType)relation, (GraknGraph)this.migrator.graph());
        return null;
    }

    public Concept visit(OWLSubPropertyChainOfAxiom axiom) {
        if (!axiom.getSuperProperty().isOWLObjectProperty()) {
            return null;
        }
        RelationType superRelation = this.migrator.relation(axiom.getSuperProperty().asOWLObjectProperty());
        LinkedHashMap chain = new LinkedHashMap();
        axiom.getPropertyChain().forEach(property -> {
            RelationType relation = this.migrator.relation(property.asOWLObjectProperty());
            chain.put(relation, new Pair((Object)this.migrator.namer().subjectRole(relation.getId()), (Object)this.migrator.namer().objectRole(relation.getId())));
        });
        Utility.createPropertyChainRule((RelationType)superRelation, (String)this.migrator.namer().subjectRole(superRelation.getId()), (String)this.migrator.namer().objectRole(superRelation.getId()), chain, (GraknGraph)this.migrator.graph());
        return null;
    }

    public Concept visit(OWLClassAssertionAxiom axiom) {
        if (!axiom.getIndividual().isNamed()) {
            return null;
        }
        return this.migrator.entity(axiom.getIndividual().asOWLNamedIndividual());
    }

    public Concept visit(OWLObjectPropertyAssertionAxiom axiom) {
        if (!(axiom.getSubject().isNamed() && ((OWLIndividual)axiom.getObject()).isNamed() && ((OWLObjectPropertyExpression)axiom.getProperty()).isOWLObjectProperty())) {
            return null;
        }
        Entity subject = this.migrator.entity(axiom.getSubject().asOWLNamedIndividual());
        Entity object = this.migrator.entity(((OWLIndividual)axiom.getObject()).asOWLNamedIndividual());
        RelationType relationType = this.migrator.relation(((OWLObjectPropertyExpression)axiom.getProperty()).asOWLObjectProperty());
        return relationType.addRelation().putRolePlayer(this.migrator.subjectRole(relationType), (Instance)subject).putRolePlayer(this.migrator.objectRole(relationType), (Instance)object);
    }

    public Concept visit(OWLDataPropertyAssertionAxiom axiom) {
        if (!((OWLDataPropertyExpression)axiom.getProperty()).isOWLDataProperty() || !axiom.getSubject().isNamed()) {
            return null;
        }
        ResourceType<?> resourceType = this.migrator.resourceType(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty());
        Entity entity = this.migrator.entity(axiom.getSubject().asOWLNamedIndividual());
        String valueAsString = ((OWLLiteral)axiom.getObject()).getLiteral();
        Object value = valueAsString;
        if (resourceType.getDataType() == ResourceType.DataType.BOOLEAN) {
            value = Boolean.parseBoolean(valueAsString);
        } else if (resourceType.getDataType() == ResourceType.DataType.LONG) {
            value = Long.parseLong(valueAsString);
        } else if (resourceType.getDataType() == ResourceType.DataType.DOUBLE) {
            value = Double.parseDouble(valueAsString);
        }
        Resource resource = resourceType.putResource(value);
        RelationType propertyRelation = this.migrator.relation(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty());
        RoleType entityRole = this.migrator.entityRole(entity.type(), resource.type());
        RoleType resourceRole = this.migrator.resourceRole(resource.type());
        try {
            return propertyRelation.addRelation().putRolePlayer(entityRole, (Instance)entity).putRolePlayer(resourceRole, (Instance)resource);
        }
        catch (ConceptException ex) {
            if (ex.getMessage().contains("The Relation with the provided role players already exists")) {
                System.err.println("[WARN] Grakn does not support multiple values per data property/resource, ignoring axiom " + axiom);
            } else {
                ex.printStackTrace(System.err);
            }
            return null;
        }
    }

    public Concept visit(OWLAnnotationAssertionAxiom axiom) {
        if (!(axiom.getSubject() instanceof OWLNamedIndividual)) {
            return null;
        }
        Optional value = axiom.getValue().asLiteral();
        if (!value.isPresent()) {
            return null;
        }
        ResourceType resourceType = (ResourceType)this.visit((OWLAnnotationProperty)axiom.getProperty());
        Entity entity = this.migrator.entity((OWLNamedIndividual)axiom.getSubject());
        Resource resource = resourceType.putResource((Object)((OWLLiteral)value.get()).getLiteral());
        RelationType propertyRelation = this.migrator.relation((OWLAnnotationProperty)axiom.getProperty());
        return propertyRelation.addRelation().putRolePlayer(this.migrator.entityRole(entity.type(), resource.type()), (Instance)entity).putRolePlayer(this.migrator.resourceRole(resource.type()), (Instance)resource);
    }

    public Concept visit(SWRLRule node) {
        return null;
    }
}

