/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graph.internal;

import ai.grakn.GraknTxType;
import ai.grakn.exception.GraknBackendException;
import ai.grakn.exception.GraknLockingException;
import ai.grakn.graph.internal.AbstractGraknGraph;
import ai.grakn.graph.internal.ConceptImpl;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.util.TitanCleanup;
import com.thinkaurelius.titan.diskstorage.locking.PermanentLockingException;
import com.thinkaurelius.titan.diskstorage.locking.TemporaryLockingException;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class GraknTitanGraph
extends AbstractGraknGraph<TitanGraph> {
    private final StandardTitanGraph rootGraph;

    public GraknTitanGraph(TitanGraph graph, String name, String engineUrl, boolean batchLoading) {
        super((Graph)graph, name, engineUrl, batchLoading);
        this.rootGraph = (StandardTitanGraph)graph;
    }

    public boolean isConceptModified(ConceptImpl concept) {
        TitanVertex vertex = (TitanVertex)concept.getVertex();
        return vertex.isModified() || vertex.isNew();
    }

    public void openTransaction(GraknTxType txType) {
        super.openTransaction(txType);
        if (((TitanGraph)this.getTinkerPopGraph()).isOpen() && !((TitanGraph)this.getTinkerPopGraph()).tx().isOpen()) {
            ((TitanGraph)this.getTinkerPopGraph()).tx().open();
        }
    }

    public boolean isConnectionClosed() {
        return this.rootGraph.isClosed();
    }

    public int numOpenTx() {
        return this.rootGraph.getOpenTxs();
    }

    protected void clearGraph() {
        this.rootGraph.close();
        TitanCleanup.clear((TitanGraph)this.rootGraph);
    }

    public void commitTransactionInternal() {
        try {
            super.commitTransactionInternal();
        }
        catch (TitanException e) {
            if (e.isCausedBy(TemporaryLockingException.class) || e.isCausedBy(PermanentLockingException.class)) {
                throw new GraknLockingException((Exception)((Object)e));
            }
            throw new GraknBackendException((Exception)((Object)e));
        }
    }

    public void validVertex(Vertex vertex) {
        super.validVertex(vertex);
        if (((TitanVertex)vertex).isRemoved()) {
            throw new IllegalStateException("The vertex [" + vertex + "] has been removed and is no longer valid");
        }
    }
}

