/*
 * Decompiled with CFR 0.152.
 */
package mobi.f2time.dorado.swagger.ext;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.annotations.ApiOperation;
import io.swagger.models.Operation;
import io.swagger.models.parameters.Parameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mobi.f2time.dorado.rest.util.MethodDescriptor;

public interface SwaggerExtension {
    default public String extractOperationMethod(ApiOperation apiOperation, Method method, Iterator<SwaggerExtension> chain) {
        if (chain.hasNext()) {
            return chain.next().extractOperationMethod(apiOperation, method, chain);
        }
        return null;
    }

    default public List<Parameter> extractParameters(List<Annotation> annotations, Type type, Set<Type> typesToSkip, Iterator<SwaggerExtension> chain) {
        if (chain.hasNext()) {
            return chain.next().extractParameters(annotations, type, typesToSkip, chain);
        }
        return Collections.emptyList();
    }

    default public void decorateOperation(Operation operation, Method method, Iterator<SwaggerExtension> chain) {
        if (chain.hasNext()) {
            chain.next().decorateOperation(operation, method, chain);
        }
    }

    default public boolean shouldIgnoreClass(Class<?> cls) {
        return false;
    }

    default public boolean shouldIgnoreType(Type type, Set<Type> typesToSkip) {
        if (typesToSkip.contains(type)) {
            return true;
        }
        if (this.shouldIgnoreClass(this.constructType(type).getRawClass())) {
            typesToSkip.add(type);
            return true;
        }
        return false;
    }

    default public JavaType constructType(Type type) {
        return TypeFactory.defaultInstance().constructType(type);
    }

    public List<Parameter> extractParameters(List<Annotation> var1, Type var2, Set<Type> var3, Iterator<SwaggerExtension> var4, MethodDescriptor var5);
}

