/*
 * Decompiled with CFR 0.152.
 */
package ai.konduit.serving.models.samediff.step;

import ai.konduit.serving.annotation.json.JsonName;
import ai.konduit.serving.pipeline.api.step.PipelineStep;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.List;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonName(value="SAMEDIFF")
@Schema(description="A pipeline step that configures a SameDiff model that is to be executed.")
public class SameDiffStep
implements PipelineStep {
    @Schema(description="Specifies the location of a saved model file.")
    private String modelUri;
    @Schema(description="A list of names of the output arrays - i.e., the names of the arrays to predict/return.")
    private List<String> outputNames;
    @Schema(description="Enable debug mode, defaults to false")
    private boolean debugMode = false;
    @Schema(description="Enable verbose mode, defaults to false")
    private boolean verboseMode = false;

    public SameDiffStep(@JsonProperty(value="modelUri") String modelUri, @JsonProperty(value="outputNames") List<String> outputNames, @JsonProperty(value="debugMode") boolean debugMode, @JsonProperty(value="verboseMode") boolean verboseMode) {
        this.modelUri = modelUri;
        this.outputNames = outputNames;
        this.debugMode = debugMode;
        this.verboseMode = verboseMode;
    }

    public SameDiffStep(String modelUri, List<String> outputNames) {
        this.modelUri = modelUri;
        this.outputNames = outputNames;
    }

    public SameDiffStep outputNames(String ... outputNames) {
        return this.outputNames(Arrays.asList(outputNames));
    }

    protected SameDiffStep(SameDiffStepBuilder<?, ?> b) {
        this.modelUri = ((SameDiffStepBuilder)b).modelUri;
        this.outputNames = ((SameDiffStepBuilder)b).outputNames;
        this.debugMode = ((SameDiffStepBuilder)b).debugMode;
        this.verboseMode = ((SameDiffStepBuilder)b).verboseMode;
    }

    public static SameDiffStepBuilder<?, ?> builder() {
        return new SameDiffStepBuilderImpl();
    }

    public String modelUri() {
        return this.modelUri;
    }

    public List<String> outputNames() {
        return this.outputNames;
    }

    public boolean debugMode() {
        return this.debugMode;
    }

    public boolean verboseMode() {
        return this.verboseMode;
    }

    public SameDiffStep modelUri(String modelUri) {
        this.modelUri = modelUri;
        return this;
    }

    public SameDiffStep outputNames(List<String> outputNames) {
        this.outputNames = outputNames;
        return this;
    }

    public SameDiffStep debugMode(boolean debugMode) {
        this.debugMode = debugMode;
        return this;
    }

    public SameDiffStep verboseMode(boolean verboseMode) {
        this.verboseMode = verboseMode;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SameDiffStep)) {
            return false;
        }
        SameDiffStep other = (SameDiffStep)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.debugMode() != other.debugMode()) {
            return false;
        }
        if (this.verboseMode() != other.verboseMode()) {
            return false;
        }
        String this$modelUri = this.modelUri();
        String other$modelUri = other.modelUri();
        if (this$modelUri == null ? other$modelUri != null : !this$modelUri.equals(other$modelUri)) {
            return false;
        }
        List<String> this$outputNames = this.outputNames();
        List<String> other$outputNames = other.outputNames();
        return !(this$outputNames == null ? other$outputNames != null : !((Object)this$outputNames).equals(other$outputNames));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SameDiffStep;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.debugMode() ? 79 : 97);
        result = result * 59 + (this.verboseMode() ? 79 : 97);
        String $modelUri = this.modelUri();
        result = result * 59 + ($modelUri == null ? 43 : $modelUri.hashCode());
        List<String> $outputNames = this.outputNames();
        result = result * 59 + ($outputNames == null ? 43 : ((Object)$outputNames).hashCode());
        return result;
    }

    public String toString() {
        return "SameDiffStep(modelUri=" + this.modelUri() + ", outputNames=" + this.outputNames() + ", debugMode=" + this.debugMode() + ", verboseMode=" + this.verboseMode() + ")";
    }

    public SameDiffStep() {
    }

    private static final class SameDiffStepBuilderImpl
    extends SameDiffStepBuilder<SameDiffStep, SameDiffStepBuilderImpl> {
        private SameDiffStepBuilderImpl() {
        }

        @Override
        protected SameDiffStepBuilderImpl self() {
            return this;
        }

        @Override
        public SameDiffStep build() {
            return new SameDiffStep(this);
        }
    }

    public static abstract class SameDiffStepBuilder<C extends SameDiffStep, B extends SameDiffStepBuilder<C, B>> {
        private String modelUri;
        private List<String> outputNames;
        private boolean debugMode;
        private boolean verboseMode;

        protected abstract B self();

        public abstract C build();

        public B modelUri(String modelUri) {
            this.modelUri = modelUri;
            return this.self();
        }

        public B outputNames(List<String> outputNames) {
            this.outputNames = outputNames;
            return this.self();
        }

        public B debugMode(boolean debugMode) {
            this.debugMode = debugMode;
            return this.self();
        }

        public B verboseMode(boolean verboseMode) {
            this.verboseMode = verboseMode;
            return this.self();
        }

        public String toString() {
            return "SameDiffStep.SameDiffStepBuilder(modelUri=" + this.modelUri + ", outputNames=" + this.outputNames + ", debugMode=" + this.debugMode + ", verboseMode=" + this.verboseMode + ")";
        }
    }
}

