/*
 * Decompiled with CFR 0.152.
 */
package ai.konduit.serving.vertx.config;

import ai.konduit.serving.pipeline.api.TextConfig;
import ai.konduit.serving.pipeline.api.pipeline.Pipeline;
import ai.konduit.serving.pipeline.util.ObjectMappers;
import ai.konduit.serving.vertx.config.KafkaConfiguration;
import ai.konduit.serving.vertx.config.MqttConfiguration;
import ai.konduit.serving.vertx.config.ServerProtocol;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@Schema(description="The main object that's used to configure the whole konduit serving pipeline and the server itself.")
public class InferenceConfiguration
implements Serializable,
TextConfig {
    @Schema(description="Server host", defaultValue="localhost")
    private String host = "localhost";
    @Schema(description="Server port. 0 means that a random port will be selected.", defaultValue="0")
    private int port = 0;
    @Schema(description="Server port. 0 means that a random port will be selected.", defaultValue="0")
    private boolean useSsl = false;
    @Schema(description="Server port. 0 means that a random port will be selected.", defaultValue="0")
    private String sslKeyPath = null;
    @Schema(description="Server port. 0 means that a random port will be selected.", defaultValue="0")
    private String sslCertificatePath = null;
    @Schema(description="Server type.", defaultValue="HTTP")
    private ServerProtocol protocol = ServerProtocol.HTTP;
    @Schema(description="Static HTTP content root.", defaultValue="static-content")
    private String staticContentRoot = "static-content";
    @Schema(description="Static HTTP content URL.", defaultValue="/static-content")
    private String staticContentUrl = "/static-content";
    @Schema(description="Static HTTP content index page", defaultValue="index.html")
    private String staticContentIndexPage = "/index.html";
    @Schema(description="Kafka related configuration.", defaultValue="{}")
    private KafkaConfiguration kafkaConfiguration = new KafkaConfiguration();
    @Schema(description="Mqtt related configuration.", defaultValue="{}")
    private MqttConfiguration mqttConfiguration = new MqttConfiguration();
    @Schema(description="List of custom endpoint class names that are configured to provide custom endpoints functionality (fully qualified Java path - for example com.mycompany.MyEndpointsClass).")
    private List<String> customEndpoints = new ArrayList<String>();
    @Schema(description="The main konduit serving pipeline configuration.")
    private Pipeline pipeline;

    public static InferenceConfiguration fromJson(String json) {
        return (InferenceConfiguration)ObjectMappers.fromJson((String)json, InferenceConfiguration.class);
    }

    public static InferenceConfiguration fromYaml(String yaml) {
        return (InferenceConfiguration)ObjectMappers.fromYaml((String)yaml, InferenceConfiguration.class);
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public boolean useSsl() {
        return this.useSsl;
    }

    public String sslKeyPath() {
        return this.sslKeyPath;
    }

    public String sslCertificatePath() {
        return this.sslCertificatePath;
    }

    public ServerProtocol protocol() {
        return this.protocol;
    }

    public String staticContentRoot() {
        return this.staticContentRoot;
    }

    public String staticContentUrl() {
        return this.staticContentUrl;
    }

    public String staticContentIndexPage() {
        return this.staticContentIndexPage;
    }

    public KafkaConfiguration kafkaConfiguration() {
        return this.kafkaConfiguration;
    }

    public MqttConfiguration mqttConfiguration() {
        return this.mqttConfiguration;
    }

    public List<String> customEndpoints() {
        return this.customEndpoints;
    }

    public Pipeline pipeline() {
        return this.pipeline;
    }

    public InferenceConfiguration host(String host) {
        this.host = host;
        return this;
    }

    public InferenceConfiguration port(int port) {
        this.port = port;
        return this;
    }

    public InferenceConfiguration useSsl(boolean useSsl) {
        this.useSsl = useSsl;
        return this;
    }

    public InferenceConfiguration sslKeyPath(String sslKeyPath) {
        this.sslKeyPath = sslKeyPath;
        return this;
    }

    public InferenceConfiguration sslCertificatePath(String sslCertificatePath) {
        this.sslCertificatePath = sslCertificatePath;
        return this;
    }

    public InferenceConfiguration protocol(ServerProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public InferenceConfiguration staticContentRoot(String staticContentRoot) {
        this.staticContentRoot = staticContentRoot;
        return this;
    }

    public InferenceConfiguration staticContentUrl(String staticContentUrl) {
        this.staticContentUrl = staticContentUrl;
        return this;
    }

    public InferenceConfiguration staticContentIndexPage(String staticContentIndexPage) {
        this.staticContentIndexPage = staticContentIndexPage;
        return this;
    }

    public InferenceConfiguration kafkaConfiguration(KafkaConfiguration kafkaConfiguration) {
        this.kafkaConfiguration = kafkaConfiguration;
        return this;
    }

    public InferenceConfiguration mqttConfiguration(MqttConfiguration mqttConfiguration) {
        this.mqttConfiguration = mqttConfiguration;
        return this;
    }

    public InferenceConfiguration customEndpoints(List<String> customEndpoints) {
        this.customEndpoints = customEndpoints;
        return this;
    }

    public InferenceConfiguration pipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InferenceConfiguration)) {
            return false;
        }
        InferenceConfiguration other = (InferenceConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.port() != other.port()) {
            return false;
        }
        if (this.useSsl() != other.useSsl()) {
            return false;
        }
        String this$host = this.host();
        String other$host = other.host();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$sslKeyPath = this.sslKeyPath();
        String other$sslKeyPath = other.sslKeyPath();
        if (this$sslKeyPath == null ? other$sslKeyPath != null : !this$sslKeyPath.equals(other$sslKeyPath)) {
            return false;
        }
        String this$sslCertificatePath = this.sslCertificatePath();
        String other$sslCertificatePath = other.sslCertificatePath();
        if (this$sslCertificatePath == null ? other$sslCertificatePath != null : !this$sslCertificatePath.equals(other$sslCertificatePath)) {
            return false;
        }
        ServerProtocol this$protocol = this.protocol();
        ServerProtocol other$protocol = other.protocol();
        if (this$protocol == null ? other$protocol != null : !((Object)((Object)this$protocol)).equals((Object)other$protocol)) {
            return false;
        }
        String this$staticContentRoot = this.staticContentRoot();
        String other$staticContentRoot = other.staticContentRoot();
        if (this$staticContentRoot == null ? other$staticContentRoot != null : !this$staticContentRoot.equals(other$staticContentRoot)) {
            return false;
        }
        String this$staticContentUrl = this.staticContentUrl();
        String other$staticContentUrl = other.staticContentUrl();
        if (this$staticContentUrl == null ? other$staticContentUrl != null : !this$staticContentUrl.equals(other$staticContentUrl)) {
            return false;
        }
        String this$staticContentIndexPage = this.staticContentIndexPage();
        String other$staticContentIndexPage = other.staticContentIndexPage();
        if (this$staticContentIndexPage == null ? other$staticContentIndexPage != null : !this$staticContentIndexPage.equals(other$staticContentIndexPage)) {
            return false;
        }
        KafkaConfiguration this$kafkaConfiguration = this.kafkaConfiguration();
        KafkaConfiguration other$kafkaConfiguration = other.kafkaConfiguration();
        if (this$kafkaConfiguration == null ? other$kafkaConfiguration != null : !((Object)this$kafkaConfiguration).equals(other$kafkaConfiguration)) {
            return false;
        }
        MqttConfiguration this$mqttConfiguration = this.mqttConfiguration();
        MqttConfiguration other$mqttConfiguration = other.mqttConfiguration();
        if (this$mqttConfiguration == null ? other$mqttConfiguration != null : !((Object)this$mqttConfiguration).equals(other$mqttConfiguration)) {
            return false;
        }
        List<String> this$customEndpoints = this.customEndpoints();
        List<String> other$customEndpoints = other.customEndpoints();
        if (this$customEndpoints == null ? other$customEndpoints != null : !((Object)this$customEndpoints).equals(other$customEndpoints)) {
            return false;
        }
        Pipeline this$pipeline = this.pipeline();
        Pipeline other$pipeline = other.pipeline();
        return !(this$pipeline == null ? other$pipeline != null : !this$pipeline.equals(other$pipeline));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InferenceConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.port();
        result = result * 59 + (this.useSsl() ? 79 : 97);
        String $host = this.host();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $sslKeyPath = this.sslKeyPath();
        result = result * 59 + ($sslKeyPath == null ? 43 : $sslKeyPath.hashCode());
        String $sslCertificatePath = this.sslCertificatePath();
        result = result * 59 + ($sslCertificatePath == null ? 43 : $sslCertificatePath.hashCode());
        ServerProtocol $protocol = this.protocol();
        result = result * 59 + ($protocol == null ? 43 : ((Object)((Object)$protocol)).hashCode());
        String $staticContentRoot = this.staticContentRoot();
        result = result * 59 + ($staticContentRoot == null ? 43 : $staticContentRoot.hashCode());
        String $staticContentUrl = this.staticContentUrl();
        result = result * 59 + ($staticContentUrl == null ? 43 : $staticContentUrl.hashCode());
        String $staticContentIndexPage = this.staticContentIndexPage();
        result = result * 59 + ($staticContentIndexPage == null ? 43 : $staticContentIndexPage.hashCode());
        KafkaConfiguration $kafkaConfiguration = this.kafkaConfiguration();
        result = result * 59 + ($kafkaConfiguration == null ? 43 : ((Object)$kafkaConfiguration).hashCode());
        MqttConfiguration $mqttConfiguration = this.mqttConfiguration();
        result = result * 59 + ($mqttConfiguration == null ? 43 : ((Object)$mqttConfiguration).hashCode());
        List<String> $customEndpoints = this.customEndpoints();
        result = result * 59 + ($customEndpoints == null ? 43 : ((Object)$customEndpoints).hashCode());
        Pipeline $pipeline = this.pipeline();
        result = result * 59 + ($pipeline == null ? 43 : $pipeline.hashCode());
        return result;
    }

    public String toString() {
        return "InferenceConfiguration(host=" + this.host() + ", port=" + this.port() + ", useSsl=" + this.useSsl() + ", sslKeyPath=" + this.sslKeyPath() + ", sslCertificatePath=" + this.sslCertificatePath() + ", protocol=" + (Object)((Object)this.protocol()) + ", staticContentRoot=" + this.staticContentRoot() + ", staticContentUrl=" + this.staticContentUrl() + ", staticContentIndexPage=" + this.staticContentIndexPage() + ", kafkaConfiguration=" + this.kafkaConfiguration() + ", mqttConfiguration=" + this.mqttConfiguration() + ", customEndpoints=" + this.customEndpoints() + ", pipeline=" + this.pipeline() + ")";
    }

    public InferenceConfiguration() {
    }

    public InferenceConfiguration(String host, int port, boolean useSsl, String sslKeyPath, String sslCertificatePath, ServerProtocol protocol, String staticContentRoot, String staticContentUrl, String staticContentIndexPage, KafkaConfiguration kafkaConfiguration, MqttConfiguration mqttConfiguration, List<String> customEndpoints, Pipeline pipeline) {
        this.host = host;
        this.port = port;
        this.useSsl = useSsl;
        this.sslKeyPath = sslKeyPath;
        this.sslCertificatePath = sslCertificatePath;
        this.protocol = protocol;
        this.staticContentRoot = staticContentRoot;
        this.staticContentUrl = staticContentUrl;
        this.staticContentIndexPage = staticContentIndexPage;
        this.kafkaConfiguration = kafkaConfiguration;
        this.mqttConfiguration = mqttConfiguration;
        this.customEndpoints = customEndpoints;
        this.pipeline = pipeline;
    }
}

