/*
 * Decompiled with CFR 0.152.
 */
package ai.konduit.serving.vertx.config;

import io.swagger.v3.oas.annotations.media.Schema;

@Schema(description="Kafka related configuration.")
public class KafkaConfiguration {
    @Schema(description="Whether to start an http server alongside the kafka server for some standard endpoints.", defaultValue="true")
    private boolean startHttpServerForKafka = true;
    @Schema(description="Whether to start an http server alongside the kafka server for some standard endpoints.", defaultValue="localhost")
    private String httpKafkaHost = "localhost";
    @Schema(description="Whether to start an http server alongside the kafka server for some standard endpoints.", defaultValue="0")
    private int httpKafkaPort = 0;
    @Schema(description="Topic name for the consumer.", defaultValue="inference-in")
    private String consumerTopicName = "inference-in";
    @Schema(description="Deserializer class for key that implements the <code>org.apache.kafka.common.serialization.Deserializer</code> interface.", defaultValue="io.vertx.kafka.client.serialization.JsonObjectDeserializer")
    private String consumerKeyDeserializerClass = "io.vertx.kafka.client.serialization.JsonObjectDeserializer";
    @Schema(description="Deserializer class for value that implements the <code>org.apache.kafka.common.serialization.Deserializer</code> interface.", defaultValue="io.vertx.kafka.client.serialization.JsonObjectDeserializer")
    private String consumerValueDeserializerClass = "io.vertx.kafka.client.serialization.JsonObjectDeserializer";
    @Schema(description="A unique string that identifies the consumer group this consumer belongs to. This property is required if the consumer uses either the group management functionality by using <code>subscribe(topic)</code> or the Kafka-based offset management strategy.", defaultValue="konduit-serving-consumer-group")
    private String consumerGroupId = "konduit-serving-consumer-group";
    @Schema(description="What to do when there is no initial offset in Kafka or if the current offset does not exist any more on the server (e.g. because that data has been deleted): <ul><li>earliest: automatically reset the offset to the earliest offset<li>latest: automatically reset the offset to the latest offset</li><li>none: throw exception to the consumer if no previous offset is found for the consumer's group</li><li>anything else: throw exception to the consumer.</li></ul>", defaultValue="earliest")
    private String consumerAutoOffsetReset = "earliest";
    @Schema(description="If true the consumer's offset will be periodically committed in the background.", defaultValue="true")
    private String consumerAutoCommit = "true";
    @Schema(description="Topic name for producer", defaultValue="inference-out")
    private String producerTopicName = "inference-out";
    @Schema(description="Serializer class for key that implements the <code>org.apache.kafka.common.serialization.Serializer</code> interface.", defaultValue="io.vertx.kafka.client.serialization.JsonObjectSerializer")
    private String producerKeySerializerClass = "io.vertx.kafka.client.serialization.JsonObjectSerializer";
    @Schema(description="Serializer class for value that implements the <code>org.apache.kafka.common.serialization.Serializer</code> interface.", defaultValue="io.vertx.kafka.client.serialization.JsonObjectSerializer")
    private String producerValueSerializerClass = "io.vertx.kafka.client.serialization.JsonObjectSerializer";
    @Schema(description="The number of acknowledgments the producer requires the leader to have received before considering a request complete. This controls the  durability of records that are sent. The following settings are allowed:  <ul> <li><code>acks=0</code> If set to zero then the producer will not wait for any acknowledgment from the server at all. The record will be immediately added to the socket buffer and considered sent. No guarantee can be made that the server has received the record in this case, and the <code>retries</code> configuration will not take effect (as the client won't generally know of any failures). The offset given back for each record will always be set to <code>-1</code>. <li><code>acks=1</code> This will mean the leader will write the record to its local log but will respond without awaiting full acknowledgement from all followers. In this case should the leader fail immediately after acknowledging the record but before the followers have replicated it then the record will be lost. <li><code>acks=all</code> This means the leader will wait for the full set of in-sync replicas to acknowledge the record. This guarantees that the record will not be lost as long as at least one in-sync replica remains alive. This is the strongest available guarantee. This is equivalent to the acks=-1 setting.</ul>", defaultValue="1")
    private String producerAcks = "1";

    public boolean startHttpServerForKafka() {
        return this.startHttpServerForKafka;
    }

    public String httpKafkaHost() {
        return this.httpKafkaHost;
    }

    public int httpKafkaPort() {
        return this.httpKafkaPort;
    }

    public String consumerTopicName() {
        return this.consumerTopicName;
    }

    public String consumerKeyDeserializerClass() {
        return this.consumerKeyDeserializerClass;
    }

    public String consumerValueDeserializerClass() {
        return this.consumerValueDeserializerClass;
    }

    public String consumerGroupId() {
        return this.consumerGroupId;
    }

    public String consumerAutoOffsetReset() {
        return this.consumerAutoOffsetReset;
    }

    public String consumerAutoCommit() {
        return this.consumerAutoCommit;
    }

    public String producerTopicName() {
        return this.producerTopicName;
    }

    public String producerKeySerializerClass() {
        return this.producerKeySerializerClass;
    }

    public String producerValueSerializerClass() {
        return this.producerValueSerializerClass;
    }

    public String producerAcks() {
        return this.producerAcks;
    }

    public KafkaConfiguration startHttpServerForKafka(boolean startHttpServerForKafka) {
        this.startHttpServerForKafka = startHttpServerForKafka;
        return this;
    }

    public KafkaConfiguration httpKafkaHost(String httpKafkaHost) {
        this.httpKafkaHost = httpKafkaHost;
        return this;
    }

    public KafkaConfiguration httpKafkaPort(int httpKafkaPort) {
        this.httpKafkaPort = httpKafkaPort;
        return this;
    }

    public KafkaConfiguration consumerTopicName(String consumerTopicName) {
        this.consumerTopicName = consumerTopicName;
        return this;
    }

    public KafkaConfiguration consumerKeyDeserializerClass(String consumerKeyDeserializerClass) {
        this.consumerKeyDeserializerClass = consumerKeyDeserializerClass;
        return this;
    }

    public KafkaConfiguration consumerValueDeserializerClass(String consumerValueDeserializerClass) {
        this.consumerValueDeserializerClass = consumerValueDeserializerClass;
        return this;
    }

    public KafkaConfiguration consumerGroupId(String consumerGroupId) {
        this.consumerGroupId = consumerGroupId;
        return this;
    }

    public KafkaConfiguration consumerAutoOffsetReset(String consumerAutoOffsetReset) {
        this.consumerAutoOffsetReset = consumerAutoOffsetReset;
        return this;
    }

    public KafkaConfiguration consumerAutoCommit(String consumerAutoCommit) {
        this.consumerAutoCommit = consumerAutoCommit;
        return this;
    }

    public KafkaConfiguration producerTopicName(String producerTopicName) {
        this.producerTopicName = producerTopicName;
        return this;
    }

    public KafkaConfiguration producerKeySerializerClass(String producerKeySerializerClass) {
        this.producerKeySerializerClass = producerKeySerializerClass;
        return this;
    }

    public KafkaConfiguration producerValueSerializerClass(String producerValueSerializerClass) {
        this.producerValueSerializerClass = producerValueSerializerClass;
        return this;
    }

    public KafkaConfiguration producerAcks(String producerAcks) {
        this.producerAcks = producerAcks;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaConfiguration)) {
            return false;
        }
        KafkaConfiguration other = (KafkaConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.startHttpServerForKafka() != other.startHttpServerForKafka()) {
            return false;
        }
        if (this.httpKafkaPort() != other.httpKafkaPort()) {
            return false;
        }
        String this$httpKafkaHost = this.httpKafkaHost();
        String other$httpKafkaHost = other.httpKafkaHost();
        if (this$httpKafkaHost == null ? other$httpKafkaHost != null : !this$httpKafkaHost.equals(other$httpKafkaHost)) {
            return false;
        }
        String this$consumerTopicName = this.consumerTopicName();
        String other$consumerTopicName = other.consumerTopicName();
        if (this$consumerTopicName == null ? other$consumerTopicName != null : !this$consumerTopicName.equals(other$consumerTopicName)) {
            return false;
        }
        String this$consumerKeyDeserializerClass = this.consumerKeyDeserializerClass();
        String other$consumerKeyDeserializerClass = other.consumerKeyDeserializerClass();
        if (this$consumerKeyDeserializerClass == null ? other$consumerKeyDeserializerClass != null : !this$consumerKeyDeserializerClass.equals(other$consumerKeyDeserializerClass)) {
            return false;
        }
        String this$consumerValueDeserializerClass = this.consumerValueDeserializerClass();
        String other$consumerValueDeserializerClass = other.consumerValueDeserializerClass();
        if (this$consumerValueDeserializerClass == null ? other$consumerValueDeserializerClass != null : !this$consumerValueDeserializerClass.equals(other$consumerValueDeserializerClass)) {
            return false;
        }
        String this$consumerGroupId = this.consumerGroupId();
        String other$consumerGroupId = other.consumerGroupId();
        if (this$consumerGroupId == null ? other$consumerGroupId != null : !this$consumerGroupId.equals(other$consumerGroupId)) {
            return false;
        }
        String this$consumerAutoOffsetReset = this.consumerAutoOffsetReset();
        String other$consumerAutoOffsetReset = other.consumerAutoOffsetReset();
        if (this$consumerAutoOffsetReset == null ? other$consumerAutoOffsetReset != null : !this$consumerAutoOffsetReset.equals(other$consumerAutoOffsetReset)) {
            return false;
        }
        String this$consumerAutoCommit = this.consumerAutoCommit();
        String other$consumerAutoCommit = other.consumerAutoCommit();
        if (this$consumerAutoCommit == null ? other$consumerAutoCommit != null : !this$consumerAutoCommit.equals(other$consumerAutoCommit)) {
            return false;
        }
        String this$producerTopicName = this.producerTopicName();
        String other$producerTopicName = other.producerTopicName();
        if (this$producerTopicName == null ? other$producerTopicName != null : !this$producerTopicName.equals(other$producerTopicName)) {
            return false;
        }
        String this$producerKeySerializerClass = this.producerKeySerializerClass();
        String other$producerKeySerializerClass = other.producerKeySerializerClass();
        if (this$producerKeySerializerClass == null ? other$producerKeySerializerClass != null : !this$producerKeySerializerClass.equals(other$producerKeySerializerClass)) {
            return false;
        }
        String this$producerValueSerializerClass = this.producerValueSerializerClass();
        String other$producerValueSerializerClass = other.producerValueSerializerClass();
        if (this$producerValueSerializerClass == null ? other$producerValueSerializerClass != null : !this$producerValueSerializerClass.equals(other$producerValueSerializerClass)) {
            return false;
        }
        String this$producerAcks = this.producerAcks();
        String other$producerAcks = other.producerAcks();
        return !(this$producerAcks == null ? other$producerAcks != null : !this$producerAcks.equals(other$producerAcks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.startHttpServerForKafka() ? 79 : 97);
        result = result * 59 + this.httpKafkaPort();
        String $httpKafkaHost = this.httpKafkaHost();
        result = result * 59 + ($httpKafkaHost == null ? 43 : $httpKafkaHost.hashCode());
        String $consumerTopicName = this.consumerTopicName();
        result = result * 59 + ($consumerTopicName == null ? 43 : $consumerTopicName.hashCode());
        String $consumerKeyDeserializerClass = this.consumerKeyDeserializerClass();
        result = result * 59 + ($consumerKeyDeserializerClass == null ? 43 : $consumerKeyDeserializerClass.hashCode());
        String $consumerValueDeserializerClass = this.consumerValueDeserializerClass();
        result = result * 59 + ($consumerValueDeserializerClass == null ? 43 : $consumerValueDeserializerClass.hashCode());
        String $consumerGroupId = this.consumerGroupId();
        result = result * 59 + ($consumerGroupId == null ? 43 : $consumerGroupId.hashCode());
        String $consumerAutoOffsetReset = this.consumerAutoOffsetReset();
        result = result * 59 + ($consumerAutoOffsetReset == null ? 43 : $consumerAutoOffsetReset.hashCode());
        String $consumerAutoCommit = this.consumerAutoCommit();
        result = result * 59 + ($consumerAutoCommit == null ? 43 : $consumerAutoCommit.hashCode());
        String $producerTopicName = this.producerTopicName();
        result = result * 59 + ($producerTopicName == null ? 43 : $producerTopicName.hashCode());
        String $producerKeySerializerClass = this.producerKeySerializerClass();
        result = result * 59 + ($producerKeySerializerClass == null ? 43 : $producerKeySerializerClass.hashCode());
        String $producerValueSerializerClass = this.producerValueSerializerClass();
        result = result * 59 + ($producerValueSerializerClass == null ? 43 : $producerValueSerializerClass.hashCode());
        String $producerAcks = this.producerAcks();
        result = result * 59 + ($producerAcks == null ? 43 : $producerAcks.hashCode());
        return result;
    }

    public String toString() {
        return "KafkaConfiguration(startHttpServerForKafka=" + this.startHttpServerForKafka() + ", httpKafkaHost=" + this.httpKafkaHost() + ", httpKafkaPort=" + this.httpKafkaPort() + ", consumerTopicName=" + this.consumerTopicName() + ", consumerKeyDeserializerClass=" + this.consumerKeyDeserializerClass() + ", consumerValueDeserializerClass=" + this.consumerValueDeserializerClass() + ", consumerGroupId=" + this.consumerGroupId() + ", consumerAutoOffsetReset=" + this.consumerAutoOffsetReset() + ", consumerAutoCommit=" + this.consumerAutoCommit() + ", producerTopicName=" + this.producerTopicName() + ", producerKeySerializerClass=" + this.producerKeySerializerClass() + ", producerValueSerializerClass=" + this.producerValueSerializerClass() + ", producerAcks=" + this.producerAcks() + ")";
    }

    public KafkaConfiguration() {
    }

    public KafkaConfiguration(boolean startHttpServerForKafka, String httpKafkaHost, int httpKafkaPort, String consumerTopicName, String consumerKeyDeserializerClass, String consumerValueDeserializerClass, String consumerGroupId, String consumerAutoOffsetReset, String consumerAutoCommit, String producerTopicName, String producerKeySerializerClass, String producerValueSerializerClass, String producerAcks) {
        this.startHttpServerForKafka = startHttpServerForKafka;
        this.httpKafkaHost = httpKafkaHost;
        this.httpKafkaPort = httpKafkaPort;
        this.consumerTopicName = consumerTopicName;
        this.consumerKeyDeserializerClass = consumerKeyDeserializerClass;
        this.consumerValueDeserializerClass = consumerValueDeserializerClass;
        this.consumerGroupId = consumerGroupId;
        this.consumerAutoOffsetReset = consumerAutoOffsetReset;
        this.consumerAutoCommit = consumerAutoCommit;
        this.producerTopicName = producerTopicName;
        this.producerKeySerializerClass = producerKeySerializerClass;
        this.producerValueSerializerClass = producerValueSerializerClass;
        this.producerAcks = producerAcks;
    }
}

