/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.ds.formats.messagepack;

import ai.mantik.ds.ArrayT;
import ai.mantik.ds.DataType;
import ai.mantik.ds.FundamentalType;
import ai.mantik.ds.FundamentalType$BoolType$;
import ai.mantik.ds.FundamentalType$Float32$;
import ai.mantik.ds.FundamentalType$Float64$;
import ai.mantik.ds.FundamentalType$Int32$;
import ai.mantik.ds.FundamentalType$Int64$;
import ai.mantik.ds.FundamentalType$Int8$;
import ai.mantik.ds.FundamentalType$StringType$;
import ai.mantik.ds.FundamentalType$Uint32$;
import ai.mantik.ds.FundamentalType$Uint64$;
import ai.mantik.ds.FundamentalType$Uint8$;
import ai.mantik.ds.FundamentalType$VoidType$;
import ai.mantik.ds.Image;
import ai.mantik.ds.Nullable;
import ai.mantik.ds.Struct;
import ai.mantik.ds.TabularData;
import ai.mantik.ds.Tensor;
import ai.mantik.ds.element.ArrayElement;
import ai.mantik.ds.element.Element;
import ai.mantik.ds.element.EmbeddedTabularElement;
import ai.mantik.ds.element.NullElement$;
import ai.mantik.ds.element.NullableElement;
import ai.mantik.ds.element.SomeElement;
import ai.mantik.ds.element.StructElement;
import ai.mantik.ds.element.TabularRow;
import ai.mantik.ds.element.TensorElement;
import ai.mantik.ds.formats.messagepack.MessagePackAdapters;
import ai.mantik.ds.formats.messagepack.MessagePackAdapters$;
import ai.mantik.ds.formats.messagepack.MessagePackAdapters$imageAdapter$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.mutable.Builder;
import scala.math.BigInt;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class MessagePackAdapters$ {
    public static MessagePackAdapters$ MODULE$;
    private final MessagePackAdapters.FundamentalMessagePackAdapter<FundamentalType$BoolType$, Object> boolAdapter;
    private final MessagePackAdapters.FundamentalMessagePackAdapter<FundamentalType$Int32$, Object> int32Adapter;
    private final MessagePackAdapters.FundamentalMessagePackAdapter<FundamentalType$Uint32$, Object> uint32Adapter;
    private final MessagePackAdapters.FundamentalMessagePackAdapter<FundamentalType$Int8$, Object> int8Adapter;
    private final MessagePackAdapters.FundamentalMessagePackAdapter<FundamentalType$Uint8$, Object> uint8Adapter;
    private final MessagePackAdapters.FundamentalMessagePackAdapter<FundamentalType$Int64$, Object> int64Adapter;
    private final MessagePackAdapters.FundamentalMessagePackAdapter<FundamentalType$Uint64$, Object> uint64Adapter;
    private final MessagePackAdapters.FundamentalMessagePackAdapter<FundamentalType$StringType$, String> stringAdapter;
    private final MessagePackAdapters.FundamentalMessagePackAdapter<FundamentalType$Float32$, Object> float32Adapter;
    private final MessagePackAdapters.FundamentalMessagePackAdapter<FundamentalType$Float64$, Object> float64Adapter;
    private final MessagePackAdapters.FundamentalMessagePackAdapter<FundamentalType$VoidType$, BoxedUnit> voidAdapter;

    static {
        new MessagePackAdapters$();
    }

    private <T extends FundamentalType, ST> MessagePackAdapters.FundamentalMessagePackAdapter<T, ST> makeFundamentalAdapter(Function2<MessagePacker, ST, BoxedUnit> writer, Function1<MessageUnpacker, ST> reader, ClassTag<ST> evidence$2) {
        return new MessagePackAdapters.FundamentalMessagePackAdapter(writer, reader, evidence$2);
    }

    public MessagePackAdapters.FundamentalMessagePackAdapter<FundamentalType$BoolType$, Object> boolAdapter() {
        return this.boolAdapter;
    }

    public MessagePackAdapters.FundamentalMessagePackAdapter<FundamentalType$Int32$, Object> int32Adapter() {
        return this.int32Adapter;
    }

    public MessagePackAdapters.FundamentalMessagePackAdapter<FundamentalType$Uint32$, Object> uint32Adapter() {
        return this.uint32Adapter;
    }

    public MessagePackAdapters.FundamentalMessagePackAdapter<FundamentalType$Int8$, Object> int8Adapter() {
        return this.int8Adapter;
    }

    public MessagePackAdapters.FundamentalMessagePackAdapter<FundamentalType$Uint8$, Object> uint8Adapter() {
        return this.uint8Adapter;
    }

    public MessagePackAdapters.FundamentalMessagePackAdapter<FundamentalType$Int64$, Object> int64Adapter() {
        return this.int64Adapter;
    }

    public MessagePackAdapters.FundamentalMessagePackAdapter<FundamentalType$Uint64$, Object> uint64Adapter() {
        return this.uint64Adapter;
    }

    public MessagePackAdapters.FundamentalMessagePackAdapter<FundamentalType$StringType$, String> stringAdapter() {
        return this.stringAdapter;
    }

    public MessagePackAdapters.FundamentalMessagePackAdapter<FundamentalType$Float32$, Object> float32Adapter() {
        return this.float32Adapter;
    }

    public MessagePackAdapters.FundamentalMessagePackAdapter<FundamentalType$Float64$, Object> float64Adapter() {
        return this.float64Adapter;
    }

    public MessagePackAdapters.FundamentalMessagePackAdapter<FundamentalType$VoidType$, BoxedUnit> voidAdapter() {
        return this.voidAdapter;
    }

    public MessagePackAdapters.MessagePackAdapter<TabularData> embeddedTabularAdapter(TabularData tabularData) {
        return new MessagePackAdapters.MessagePackAdapter<TabularData>(tabularData){
            private final MessagePackAdapters.TabularContext context;

            public void elementWriter(MessagePacker messagePacker, Element value) {
                MessagePackAdapters.MessagePackAdapter.elementWriter$(this, messagePacker, value);
            }

            private MessagePackAdapters.TabularContext context() {
                return this.context;
            }

            public void write(MessagePacker messagePacker, EmbeddedTabularElement elementType) {
                messagePacker.packArrayHeader(elementType.rows().length());
                elementType.rows().foreach((Function1 & Serializable & scala.Serializable)row -> {
                    anon.1.$anonfun$write$1(this, messagePacker, row);
                    return BoxedUnit.UNIT;
                });
            }

            public EmbeddedTabularElement read(MessageUnpacker messageUnpacker) {
                int elementCount = messageUnpacker.unpackArrayHeader();
                Builder buffer = package$.MODULE$.IndexedSeq().newBuilder();
                buffer.sizeHint(elementCount);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), elementCount).foreach((Function1 & Serializable & scala.Serializable)i -> anon.1.$anonfun$read$1(this, buffer, messageUnpacker, BoxesRunTime.unboxToInt((Object)i)));
                return new EmbeddedTabularElement((IndexedSeq<TabularRow>)((IndexedSeq)buffer.result()));
            }

            public static final /* synthetic */ void $anonfun$write$1(anon.1 $this, MessagePacker messagePacker$1, TabularRow row) {
                $this.context().write(messagePacker$1, row);
            }

            public static final /* synthetic */ Builder $anonfun$read$1(anon.1 $this, Builder buffer$1, MessageUnpacker messageUnpacker$1, int i) {
                return buffer$1.$plus$eq((Object)$this.context().read(messageUnpacker$1));
            }
            {
                MessagePackAdapters.MessagePackAdapter.$init$(this);
                this.context = new MessagePackAdapters.TabularContext(tabularData$1);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$write$1$adapted(ai.mantik.ds.formats.messagepack.MessagePackAdapters$$anon$1 org.msgpack.core.MessagePacker ai.mantik.ds.element.TabularRow ), $anonfun$read$1$adapted(ai.mantik.ds.formats.messagepack.MessagePackAdapters$$anon$1 scala.collection.mutable.Builder org.msgpack.core.MessageUnpacker java.lang.Object )}, serializedLambda);
            }
        };
    }

    public <ST> MessagePackAdapters.MessagePackAdapter<Tensor> tensorAdapter(Tensor tensor) {
        return new MessagePackAdapters.MessagePackAdapter<Tensor>(tensor){
            private final MessagePackAdapters.FundamentalMessagePackAdapter<?, ST> underlyingAdapter;
            private final Tensor tensor$1;

            public void elementWriter(MessagePacker messagePacker, Element value) {
                MessagePackAdapters.MessagePackAdapter.elementWriter$(this, messagePacker, value);
            }

            private MessagePackAdapters.FundamentalMessagePackAdapter<?, ST> underlyingAdapter() {
                return this.underlyingAdapter;
            }

            public void write(MessagePacker messagePacker, TensorElement<ST> elementType) {
                Predef$.MODULE$.require((long)elementType.elements().length() == this.tensor$1.packedElementCount(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Tensor element count mismatch, expected: ").append($this.tensor$1.packedElementCount()).append(", got: ").append(elementType.elements().length()).toString());
                messagePacker.packArrayHeader(elementType.elements().length());
                elementType.elements().foreach((Function1 & Serializable & scala.Serializable)element -> {
                    anon.2.$anonfun$write$3(this, messagePacker, element);
                    return BoxedUnit.UNIT;
                });
            }

            public TensorElement<ST> read(MessageUnpacker messageUnpacker) {
                int arrayLength = messageUnpacker.unpackArrayHeader();
                Object array = this.underlyingAdapter().allocateArray(arrayLength);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), arrayLength).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> ScalaRunTime$.MODULE$.array_update(array, i, this.underlyingAdapter().reader().apply((Object)messageUnpacker)));
                return new TensorElement<X>(Predef$.MODULE$.genericWrapArray(array));
            }

            public static final /* synthetic */ void $anonfun$write$3(anon.2 $this, MessagePacker messagePacker$2, Object element) {
                $this.underlyingAdapter().writer().apply((Object)messagePacker$2, element);
            }
            {
                this.tensor$1 = tensor$1;
                MessagePackAdapters.MessagePackAdapter.$init$(this);
                this.underlyingAdapter = (MessagePackAdapters.FundamentalMessagePackAdapter)MessagePackAdapters$.MODULE$.lookupAdapter(tensor$1.componentType());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$write$2(ai.mantik.ds.formats.messagepack.MessagePackAdapters$$anon$2 ai.mantik.ds.element.TensorElement ), $anonfun$write$3$adapted(ai.mantik.ds.formats.messagepack.MessagePackAdapters$$anon$2 org.msgpack.core.MessagePacker java.lang.Object ), $anonfun$read$2(ai.mantik.ds.formats.messagepack.MessagePackAdapters$$anon$2 java.lang.Object org.msgpack.core.MessageUnpacker int )}, serializedLambda);
            }
        };
    }

    public MessagePackAdapters.MessagePackAdapter<Nullable> nullableAdapter(Nullable nullable) {
        return new MessagePackAdapters.MessagePackAdapter<Nullable>(nullable){
            private final MessagePackAdapters.AnonymousMessagePackAdapter underlyingAdapter;

            public void elementWriter(MessagePacker messagePacker, Element value) {
                MessagePackAdapters.MessagePackAdapter.elementWriter$(this, messagePacker, value);
            }

            private MessagePackAdapters.AnonymousMessagePackAdapter underlyingAdapter() {
                return this.underlyingAdapter;
            }

            public void write(MessagePacker messagePacker, NullableElement elementType) {
                NullableElement nullableElement = elementType;
                if (NullElement$.MODULE$.equals(nullableElement)) {
                    messagePacker.packNil();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (nullableElement instanceof SomeElement) {
                    SomeElement someElement = (SomeElement)nullableElement;
                    Element e = someElement.x();
                    this.underlyingAdapter().elementWriter(messagePacker, e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)nullableElement);
                }
            }

            public NullableElement read(MessageUnpacker messageUnpacker) {
                return messageUnpacker.tryUnpackNil() ? NullElement$.MODULE$ : new SomeElement(this.underlyingAdapter().read(messageUnpacker));
            }
            {
                MessagePackAdapters.MessagePackAdapter.$init$(this);
                this.underlyingAdapter = MessagePackAdapters$.MODULE$.lookupAdapter(nullable$1.underlying());
            }
        };
    }

    public MessagePackAdapters.MessagePackAdapter<ArrayT> arrayAdapter(ArrayT array) {
        return new MessagePackAdapters.MessagePackAdapter<ArrayT>(array){
            private final MessagePackAdapters.AnonymousMessagePackAdapter underlying;

            public void elementWriter(MessagePacker messagePacker, Element value) {
                MessagePackAdapters.MessagePackAdapter.elementWriter$(this, messagePacker, value);
            }

            private MessagePackAdapters.AnonymousMessagePackAdapter underlying() {
                return this.underlying;
            }

            public void write(MessagePacker messagePacker, ArrayElement elementType) {
                messagePacker.packArrayHeader(elementType.elements().size());
                elementType.elements().foreach((Function1 & Serializable & scala.Serializable)e -> {
                    anon.4.$anonfun$write$4(this, messagePacker, e);
                    return BoxedUnit.UNIT;
                });
            }

            public ArrayElement read(MessageUnpacker messageUnpacker) {
                int length = messageUnpacker.unpackArrayHeader();
                Builder resultBuilder = package$.MODULE$.IndexedSeq().newBuilder();
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), length).foreach((Function1 & Serializable & scala.Serializable)i -> anon.4.$anonfun$read$3(this, resultBuilder, messageUnpacker, BoxesRunTime.unboxToInt((Object)i)));
                return new ArrayElement((IndexedSeq<Element>)((IndexedSeq)resultBuilder.result()));
            }

            public static final /* synthetic */ void $anonfun$write$4(anon.4 $this, MessagePacker messagePacker$3, Element e) {
                $this.underlying().elementWriter(messagePacker$3, e);
            }

            public static final /* synthetic */ Builder $anonfun$read$3(anon.4 $this, Builder resultBuilder$1, MessageUnpacker messageUnpacker$3, int i) {
                return resultBuilder$1.$plus$eq((Object)$this.underlying().read(messageUnpacker$3));
            }
            {
                MessagePackAdapters.MessagePackAdapter.$init$(this);
                this.underlying = MessagePackAdapters$.MODULE$.lookupAdapter(array$2.underlying());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$write$4$adapted(ai.mantik.ds.formats.messagepack.MessagePackAdapters$$anon$4 org.msgpack.core.MessagePacker ai.mantik.ds.element.Element ), $anonfun$read$3$adapted(ai.mantik.ds.formats.messagepack.MessagePackAdapters$$anon$4 scala.collection.mutable.Builder org.msgpack.core.MessageUnpacker java.lang.Object )}, serializedLambda);
            }
        };
    }

    public MessagePackAdapters.MessagePackAdapter<Struct> structAdapter(Struct nt) {
        return new MessagePackAdapters.MessagePackAdapter<Struct>(nt){
            private final MessagePackAdapters.TupleContext context;

            public void elementWriter(MessagePacker messagePacker, Element value) {
                MessagePackAdapters.MessagePackAdapter.elementWriter$(this, messagePacker, value);
            }

            private MessagePackAdapters.TupleContext context() {
                return this.context;
            }

            public void write(MessagePacker messagePacker, StructElement elementType) {
                this.context().write(messagePacker, elementType.elements());
            }

            public StructElement read(MessageUnpacker messageUnpacker) {
                return new StructElement(this.context().read(messageUnpacker));
            }
            {
                MessagePackAdapters.MessagePackAdapter.$init$(this);
                this.context = new MessagePackAdapters.TupleContext((Iterable<DataType>)nt$1.fields().values());
            }
        };
    }

    public MessagePackAdapters.RootElementContext createRootElementContext(DataType dataType) {
        MessagePackAdapters.RootElementContext rootElementContext;
        DataType dataType2 = dataType;
        if (dataType2 instanceof TabularData) {
            TabularData tabularData = (TabularData)dataType2;
            rootElementContext = new MessagePackAdapters.TabularContext(tabularData);
        } else {
            rootElementContext = new MessagePackAdapters.SingleElementContext(dataType2);
        }
        return rootElementContext;
    }

    /*
     * WARNING - void declaration
     */
    public MessagePackAdapters.AnonymousMessagePackAdapter lookupAdapter(DataType dt) {
        void var3_9;
        MessagePackAdapters.MessagePackAdapter<Object> messagePackAdapter;
        DataType dataType = dt;
        if (FundamentalType$BoolType$.MODULE$.equals(dataType)) {
            messagePackAdapter = this.boolAdapter();
        } else if (FundamentalType$Int8$.MODULE$.equals(dataType)) {
            messagePackAdapter = this.int8Adapter();
        } else if (FundamentalType$Uint8$.MODULE$.equals(dataType)) {
            messagePackAdapter = this.uint8Adapter();
        } else if (FundamentalType$Int32$.MODULE$.equals(dataType)) {
            messagePackAdapter = this.int32Adapter();
        } else if (FundamentalType$Uint32$.MODULE$.equals(dataType)) {
            messagePackAdapter = this.uint32Adapter();
        } else if (FundamentalType$Int64$.MODULE$.equals(dataType)) {
            messagePackAdapter = this.int64Adapter();
        } else if (FundamentalType$Uint64$.MODULE$.equals(dataType)) {
            messagePackAdapter = this.uint64Adapter();
        } else if (FundamentalType$StringType$.MODULE$.equals(dataType)) {
            messagePackAdapter = this.stringAdapter();
        } else if (FundamentalType$Float32$.MODULE$.equals(dataType)) {
            messagePackAdapter = this.float32Adapter();
        } else if (FundamentalType$Float64$.MODULE$.equals(dataType)) {
            messagePackAdapter = this.float64Adapter();
        } else if (FundamentalType$VoidType$.MODULE$.equals(dataType)) {
            messagePackAdapter = this.voidAdapter();
        } else if (dataType instanceof Image) {
            messagePackAdapter = MessagePackAdapters$imageAdapter$.MODULE$;
        } else if (dataType instanceof TabularData) {
            TabularData tabularData = (TabularData)dataType;
            messagePackAdapter = this.embeddedTabularAdapter(tabularData);
        } else if (dataType instanceof Tensor) {
            Tensor tensor = (Tensor)dataType;
            messagePackAdapter = this.tensorAdapter(tensor);
        } else if (dataType instanceof Nullable) {
            Nullable nullable = (Nullable)dataType;
            messagePackAdapter = this.nullableAdapter(nullable);
        } else if (dataType instanceof ArrayT) {
            ArrayT arrayT = (ArrayT)dataType;
            messagePackAdapter = this.arrayAdapter(arrayT);
        } else if (dataType instanceof Struct) {
            Struct struct = (Struct)dataType;
            messagePackAdapter = this.structAdapter(struct);
        } else {
            throw new MatchError((Object)dataType);
        }
        MessagePackAdapters.FundamentalMessagePackAdapter<FundamentalType$BoolType$, Object> result = messagePackAdapter;
        return var3_9;
    }

    public static final /* synthetic */ int $anonfun$uint32Adapter$2(MessageUnpacker unpacker) {
        int n;
        MessageFormat messageFormat = unpacker.getNextFormat();
        if (MessageFormat.UINT32.equals(messageFormat)) {
            long data = unpacker.unpackLong();
            n = (int)data;
        } else {
            n = unpacker.unpackInt();
        }
        return n;
    }

    public static final /* synthetic */ void $anonfun$uint8Adapter$1(MessagePacker packer, byte by) {
        if (by < 0) {
            short unsignedShort = (short)(by & (short)255);
            packer.packShort(unsignedShort);
        } else {
            packer.packByte(by);
        }
    }

    public static final /* synthetic */ byte $anonfun$uint8Adapter$2(MessageUnpacker unpacker) {
        byte by;
        MessageFormat messageFormat = unpacker.getNextFormat();
        if (MessageFormat.UINT8.equals(messageFormat)) {
            short s = unpacker.unpackShort();
            by = (byte)s;
        } else {
            by = unpacker.unpackByte();
        }
        return by;
    }

    public static final /* synthetic */ void $anonfun$uint64Adapter$1(MessagePacker packer, long l) {
        if (l < 0L) {
            long highBytes = l >> 32 & 0xFFFFFFFFL;
            long lowBytes = l & 0xFFFFFFFFL;
            BigInt bigInt = package$.MODULE$.BigInt().apply(highBytes).$less$less(32).$plus(package$.MODULE$.BigInt().apply(lowBytes));
            packer.packBigInteger(bigInt.bigInteger());
        } else {
            packer.packLong(l);
        }
    }

    public static final /* synthetic */ long $anonfun$uint64Adapter$2(MessageUnpacker unpacker) {
        long l;
        MessageFormat messageFormat = unpacker.getNextFormat();
        if (MessageFormat.UINT64.equals(messageFormat)) {
            long result;
            BigInt bigInt = package$.MODULE$.BigInt().apply(unpacker.unpackBigInteger());
            l = result = bigInt.toLong();
        } else {
            l = unpacker.unpackLong();
        }
        return l;
    }

    private MessagePackAdapters$() {
        MODULE$ = this;
        this.boolAdapter = this.makeFundamentalAdapter((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> {
            x$1.packBoolean(BoxesRunTime.unboxToBoolean((Object)x$2));
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.unpackBoolean()), ClassTag$.MODULE$.Boolean());
        this.int32Adapter = this.makeFundamentalAdapter((Function2 & Serializable & scala.Serializable)(x$4, x$5) -> {
            x$4.packInt(BoxesRunTime.unboxToInt((Object)x$5));
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.unpackInt()), ClassTag$.MODULE$.Int());
        this.uint32Adapter = this.makeFundamentalAdapter((Function2 & Serializable & scala.Serializable)(packer, value) -> {
            packer.packLong(Integer.toUnsignedLong(BoxesRunTime.unboxToInt((Object)value)));
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)unpacker -> BoxesRunTime.boxToInteger((int)MessagePackAdapters$.$anonfun$uint32Adapter$2(unpacker)), ClassTag$.MODULE$.Int());
        this.int8Adapter = this.makeFundamentalAdapter((Function2 & Serializable & scala.Serializable)(x$7, x$8) -> {
            x$7.packByte(BoxesRunTime.unboxToByte((Object)x$8));
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToByte((byte)x$9.unpackByte()), ClassTag$.MODULE$.Byte());
        this.uint8Adapter = this.makeFundamentalAdapter((Function2 & Serializable & scala.Serializable)(packer, object) -> {
            MessagePackAdapters$.$anonfun$uint8Adapter$1(packer, BoxesRunTime.unboxToByte((Object)object));
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)unpacker -> BoxesRunTime.boxToByte((byte)MessagePackAdapters$.$anonfun$uint8Adapter$2(unpacker)), ClassTag$.MODULE$.Byte());
        this.int64Adapter = this.makeFundamentalAdapter((Function2 & Serializable & scala.Serializable)(x$10, x$11) -> {
            x$10.packLong(BoxesRunTime.unboxToLong((Object)x$11));
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.unpackLong()), ClassTag$.MODULE$.Long());
        this.uint64Adapter = this.makeFundamentalAdapter((Function2 & Serializable & scala.Serializable)(packer, object) -> {
            MessagePackAdapters$.$anonfun$uint64Adapter$1(packer, BoxesRunTime.unboxToLong((Object)object));
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)unpacker -> BoxesRunTime.boxToLong((long)MessagePackAdapters$.$anonfun$uint64Adapter$2(unpacker)), ClassTag$.MODULE$.Long());
        this.stringAdapter = this.makeFundamentalAdapter((Function2 & Serializable & scala.Serializable)(x$13, x$14) -> {
            x$13.packString(x$14);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$15 -> x$15.unpackString(), ClassTag$.MODULE$.apply(String.class));
        this.float32Adapter = this.makeFundamentalAdapter((Function2 & Serializable & scala.Serializable)(x$16, x$17) -> {
            x$16.packFloat(BoxesRunTime.unboxToFloat((Object)x$17));
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToFloat((float)x$18.unpackFloat()), ClassTag$.MODULE$.Float());
        this.float64Adapter = this.makeFundamentalAdapter((Function2 & Serializable & scala.Serializable)(x$19, x$20) -> {
            x$19.packDouble(BoxesRunTime.unboxToDouble((Object)x$20));
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToDouble((double)x$21.unpackDouble()), ClassTag$.MODULE$.Double());
        this.voidAdapter = this.makeFundamentalAdapter((Function2 & Serializable & scala.Serializable)(packer, x$22) -> {
            packer.packNil();
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)unpacker -> {
            unpacker.unpackNil();
            return BoxedUnit.UNIT;
        }, ClassTag$.MODULE$.Unit());
    }
}

