/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.ds.sql.run;

import ai.mantik.ds.Errors;
import ai.mantik.ds.Errors$FeatureNotSupported$;
import ai.mantik.ds.converter.Cast;
import ai.mantik.ds.converter.Cast$;
import ai.mantik.ds.element.ArrayElement;
import ai.mantik.ds.element.Element;
import ai.mantik.ds.element.NullElement$;
import ai.mantik.ds.element.Primitive;
import ai.mantik.ds.element.Primitive$mcI$sp;
import ai.mantik.ds.element.Primitive$mcZ$sp;
import ai.mantik.ds.element.SingleElementBundle;
import ai.mantik.ds.element.SomeElement;
import ai.mantik.ds.element.StructElement;
import ai.mantik.ds.operations.BinaryFunction;
import ai.mantik.ds.operations.BinaryFunction$;
import ai.mantik.ds.sql.run.OpCode;
import ai.mantik.ds.sql.run.OpCode$And$;
import ai.mantik.ds.sql.run.OpCode$ArrayGet$;
import ai.mantik.ds.sql.run.OpCode$ArraySize$;
import ai.mantik.ds.sql.run.OpCode$IsNull$;
import ai.mantik.ds.sql.run.OpCode$Neg$;
import ai.mantik.ds.sql.run.OpCode$Or$;
import ai.mantik.ds.sql.run.OpCode$PackNullable$;
import ai.mantik.ds.sql.run.OpCode$Pop$;
import ai.mantik.ds.sql.run.OpCode$ReturnOnFalse$;
import ai.mantik.ds.sql.run.Program;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.IndexedSeq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayStack;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001\u0002\u0006\f\u0001YA\u0001\"\b\u0001\u0003\u0002\u0003\u0006IA\b\u0005\u0006E\u0001!\taI\u0003\u0005M\u0001\u0001q%\u0002\u00036\u0001\u00011\u0004bB'\u0001\u0005\u0004%IA\u0014\u0005\u0007'\u0002\u0001\u000b\u0011B(\t\u000b1\u0001A\u0011\u0001+\t\u000b]\u0003A\u0011\u0002-\t\u000by\u0003A\u0011B0\u0003\u001bA\u0013xn\u001a:b[J+hN\\3s\u0015\taQ\"A\u0002sk:T!AD\b\u0002\u0007M\fHN\u0003\u0002\u0011#\u0005\u0011Am\u001d\u0006\u0003%M\ta!\\1oi&\\'\"\u0001\u000b\u0002\u0005\u0005L7\u0001A\n\u0003\u0001]\u0001\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011a!\u00118z%\u00164\u0017a\u00029s_\u001e\u0014\u0018-\u001c\t\u0003?\u0001j\u0011aC\u0005\u0003C-\u0011q\u0001\u0015:pOJ\fW.\u0001\u0004=S:LGO\u0010\u000b\u0003I\u0015\u0002\"a\b\u0001\t\u000bu\u0011\u0001\u0019\u0001\u0010\u0003\u0013M#\u0018mY6UsB,\u0007c\u0001\u0015._5\t\u0011F\u0003\u0002+W\u00059Q.\u001e;bE2,'B\u0001\u0017\u001a\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003]%\u0012!\"\u0011:sCf\u001cF/Y2l!\t\u00014'D\u00012\u0015\t\u0011t\"A\u0004fY\u0016lWM\u001c;\n\u0005Q\n$aB#mK6,g\u000e\u001e\u0002\r\u000bb,7-\u001e;bE2,w\n\u001d\t\u00061]JTiR\u0005\u0003qe\u0011\u0011BR;oGRLwN\u001c\u001a\u0011\u0007i\u0012uF\u0004\u0002<\u0001:\u0011AhP\u0007\u0002{)\u0011a(F\u0001\u0007yI|w\u000e\u001e \n\u0003iI!!Q\r\u0002\u000fA\f7m[1hK&\u00111\t\u0012\u0002\u000b\u0013:$W\r_3e'\u0016\f(BA!\u001a!\t15!D\u0001\u0001!\rA\u0002JS\u0005\u0003\u0013f\u0011aa\u00149uS>t\u0007C\u0001\rL\u0013\ta\u0015DA\u0002J]R\f1\"\u001a=fGV$\u0018M\u00197fgV\tq\nE\u0002;!JK!!\u0015#\u0003\rY+7\r^8s!\t1E!\u0001\u0007fq\u0016\u001cW\u000f^1cY\u0016\u001c\b\u0005\u0006\u0002:+\")ak\u0002a\u0001s\u0005!\u0011M]4t\u0003=y\u0007OM#yK\u000e,H/\u00192mK>\u0003HC\u0001*Z\u0011\u0015Q\u0006\u00021\u0001\\\u0003\ty\u0007\u000f\u0005\u0002 9&\u0011Ql\u0003\u0002\u0007\u001fB\u001cu\u000eZ3\u00027\u0015LG\u000f[3s\u001fJ4U-\u0019;ve\u0016tu\u000e^*vaB|'\u000f^3e+\t\u00017\r\u0006\u0002bYB\u0011!m\u0019\u0007\u0001\t\u0015!\u0017B1\u0001f\u0005\u0005!\u0016C\u00014j!\tAr-\u0003\u0002i3\t9aj\u001c;iS:<\u0007C\u0001\rk\u0013\tY\u0017DA\u0002B]fDQ!\\\u0005A\u00029\f!!\u001b8\u0011\tiz\u0017/Y\u0005\u0003a\u0012\u0013a!R5uQ\u0016\u0014\bC\u0001:w\u001d\t\u0019H\u000f\u0005\u0002=3%\u0011Q/G\u0001\u0007!J,G-\u001a4\n\u0005]D(AB*ue&twM\u0003\u0002v3!\"\u0001A_A\u000b!\rA20`\u0005\u0003yf\u0011a\u0001\u001e5s_^\u001c\bc\u0001@\u0002\u00109\u0019q0a\u0003\u000f\t\u0005\u0005\u0011\u0011\u0002\b\u0005\u0003\u0007\t9AD\u0002=\u0003\u000bI\u0011\u0001F\u0005\u0003%MI!\u0001E\t\n\u0007\u00055q\"\u0001\u0004FeJ|'o]\u0005\u0005\u0003#\t\u0019BA\nGK\u0006$XO]3O_R\u001cV\u000f\u001d9peR,GMC\u0002\u0002\u000e=\t#!a\u0006\u0002Q%4\u0007e]8nK\u0002z\u0007\u000fI2pI\u0016\u00043m\\;mI\u0002rw\u000e\u001e\u0011cK\u0002\"(/\u00198tY\u0006$X\r\u001a\u0018")
public class ProgramRunner {
    private final Program program;
    private final Vector<Function2<IndexedSeq<Element>, ArrayStack<Element>, Option<Object>>> executables;

    private Vector<Function2<IndexedSeq<Element>, ArrayStack<Element>, Option<Object>>> executables() {
        return this.executables;
    }

    public IndexedSeq<Element> run(IndexedSeq<Element> args) {
        int offset;
        Predef$.MODULE$.require(args.length() >= this.program.args(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Program needs minimal ").append($this.program.args()).append(" arguments").toString());
        ArrayStack stack = new ArrayStack();
        for (int position = 0; position < this.executables().size(); position += offset) {
            Function2 op = (Function2)this.executables().apply(position);
            Option option = (Option)op.apply(args, (Object)stack);
            if (option instanceof Some) {
                Some some = (Some)option;
                offset = BoxesRunTime.unboxToInt((Object)some.value());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (None$.MODULE$.equals(option)) {
                return ((TraversableOnce)stack.reverse()).toVector();
            }
            throw new MatchError((Object)option);
        }
        return ((TraversableOnce)stack.reverse()).toVector();
    }

    private Function2<IndexedSeq<Element>, ArrayStack<Element>, Option<Object>> op2ExecutableOp(OpCode op) {
        Function2 & Serializable & scala.Serializable intersect;
        OpCode opCode = op;
        if (opCode instanceof OpCode.Constant) {
            OpCode.Constant constant = (OpCode.Constant)opCode;
            SingleElementBundle value = constant.value();
            intersect = ProgramRunner.makeContinueOp$1((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.push((Object)value.element());
                return BoxedUnit.UNIT;
            });
        } else if (opCode instanceof OpCode.Get) {
            OpCode.Get get = (OpCode.Get)opCode;
            int i = get.id();
            intersect = (Function2 & Serializable & scala.Serializable)(a, s) -> {
                s.push(a.apply(i));
                return new Some((Object)BoxesRunTime.boxToInteger((int)1));
            };
        } else if (opCode instanceof OpCode.Cast) {
            OpCode.Cast cast = (OpCode.Cast)opCode;
            Cast cast2 = this.eitherOrFeatureNotSupported(Cast$.MODULE$.findCast(cast.from(), cast.to()));
            intersect = ProgramRunner.makeTransformContinueOp$1(cast2.op());
        } else if (OpCode$Neg$.MODULE$.equals(opCode)) {
            intersect = ProgramRunner.makeTransformContinueOp$1((Function1 & Serializable & scala.Serializable)e -> new Primitive$mcZ$sp(!((Primitive)e).x$mcZ$sp()));
        } else if (OpCode$IsNull$.MODULE$.equals(opCode)) {
            intersect = ProgramRunner.makeTransformContinueOp$1((Function1 & Serializable & scala.Serializable)e -> {
                Element element = e;
                NullElement$ nullElement$ = NullElement$.MODULE$;
                return new Primitive$mcZ$sp(!(element != null ? !element.equals(nullElement$) : nullElement$ != null));
            });
        } else if (opCode instanceof OpCode.Equals) {
            intersect = ProgramRunner.makeContinueOp$1((Function1 & Serializable & scala.Serializable)s -> {
                ProgramRunner.$anonfun$op2ExecutableOp$7(s);
                return BoxedUnit.UNIT;
            });
        } else if (OpCode$And$.MODULE$.equals(opCode)) {
            intersect = ProgramRunner.makeContinueOp$1((Function1 & Serializable & scala.Serializable)s -> {
                ProgramRunner.$anonfun$op2ExecutableOp$8(s);
                return BoxedUnit.UNIT;
            });
        } else if (OpCode$Or$.MODULE$.equals(opCode)) {
            intersect = ProgramRunner.makeContinueOp$1((Function1 & Serializable & scala.Serializable)s -> {
                ProgramRunner.$anonfun$op2ExecutableOp$9(s);
                return BoxedUnit.UNIT;
            });
        } else if (OpCode$ReturnOnFalse$.MODULE$.equals(opCode)) {
            intersect = (Function2 & Serializable & scala.Serializable)(x$3, s) -> {
                boolean last = ((Primitive)s.last()).x$mcZ$sp();
                return !last ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)1));
            };
        } else if (OpCode$Pop$.MODULE$.equals(opCode)) {
            intersect = ProgramRunner.makeContinueOp$1((Function1 & Serializable & scala.Serializable)s -> {
                s.pop();
                return BoxedUnit.UNIT;
            });
        } else if (opCode instanceof OpCode.BinaryOp) {
            OpCode.BinaryOp binaryOp = (OpCode.BinaryOp)opCode;
            BinaryFunction function = this.eitherOrFeatureNotSupported(BinaryFunction$.MODULE$.findBinaryFunction(binaryOp.op(), binaryOp.dataType()));
            intersect = ProgramRunner.makeContinueOp$1((Function1 & Serializable & scala.Serializable)s -> {
                ProgramRunner.$anonfun$op2ExecutableOp$12(function, s);
                return BoxedUnit.UNIT;
            });
        } else if (OpCode$ArrayGet$.MODULE$.equals(opCode)) {
            intersect = ProgramRunner.makeContinueOp$1((Function1 & Serializable & scala.Serializable)s -> {
                ProgramRunner.$anonfun$op2ExecutableOp$13(s);
                return BoxedUnit.UNIT;
            });
        } else if (OpCode$ArraySize$.MODULE$.equals(opCode)) {
            intersect = ProgramRunner.makeContinueOp$1((Function1 & Serializable & scala.Serializable)s -> {
                ProgramRunner.$anonfun$op2ExecutableOp$14(s);
                return BoxedUnit.UNIT;
            });
        } else if (opCode instanceof OpCode.StructGet) {
            OpCode.StructGet structGet = (OpCode.StructGet)opCode;
            int index = structGet.idx();
            intersect = ProgramRunner.makeContinueOp$1((Function1 & Serializable & scala.Serializable)s -> {
                ProgramRunner.$anonfun$op2ExecutableOp$15(index, s);
                return BoxedUnit.UNIT;
            });
        } else if (opCode instanceof OpCode.UnpackNullableJump) {
            OpCode.UnpackNullableJump unpackNullableJump = (OpCode.UnpackNullableJump)opCode;
            int offset = unpackNullableJump.offset();
            int drop = unpackNullableJump.drop();
            intersect = (Function2 & Serializable & scala.Serializable)(x$4, s) -> {
                Some some;
                Element value = (Element)s.pop();
                Element element = value;
                if (element instanceof SomeElement) {
                    SomeElement someElement = (SomeElement)element;
                    Element value2 = someElement.x();
                    s.push((Object)value2);
                    some = new Some((Object)BoxesRunTime.boxToInteger((int)1));
                } else if (NullElement$.MODULE$.equals(element)) {
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), drop).foreach((Function1 & Serializable & scala.Serializable)_ -> ProgramRunner.$anonfun$op2ExecutableOp$17(s, BoxesRunTime.unboxToInt((Object)_)));
                    s.push((Object)NullElement$.MODULE$);
                    some = new Some((Object)BoxesRunTime.boxToInteger((int)(1 + offset)));
                } else {
                    throw new IllegalArgumentException(new StringBuilder(23).append("Expected nullable, got ").append(element).toString());
                }
                return some;
            };
        } else if (OpCode$PackNullable$.MODULE$.equals(opCode)) {
            intersect = ProgramRunner.makeContinueOp$1((Function1 & Serializable & scala.Serializable)s -> {
                ProgramRunner.$anonfun$op2ExecutableOp$18(s);
                return BoxedUnit.UNIT;
            });
        } else {
            throw new MatchError((Object)opCode);
        }
        return intersect;
    }

    private <T> T eitherOrFeatureNotSupported(Either<String, T> in) {
        Object value;
        Either<String, T> either = in;
        if (either instanceof Left) {
            Left left = (Left)either;
            String error = (String)left.value();
            throw new Errors.FeatureNotSupported(error, Errors$FeatureNotSupported$.MODULE$.$lessinit$greater$default$2());
        }
        if (!(either instanceof Right)) {
            throw new MatchError(either);
        }
        Right right = (Right)either;
        Object object = value = right.value();
        return (T)object;
    }

    private static final Function2 makeContinueOp$1(Function1 f) {
        return (Function2 & Serializable & scala.Serializable)(x$1, s) -> {
            f.apply(s);
            return new Some((Object)BoxesRunTime.boxToInteger((int)1));
        };
    }

    private static final Function2 makeTransformContinueOp$1(Function1 f) {
        return ProgramRunner.makeContinueOp$1((Function1 & Serializable & scala.Serializable)s -> {
            s.push(f.apply(s.pop()));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$op2ExecutableOp$7(ArrayStack s) {
        Element left;
        Element right = (Element)s.pop();
        Element element = left = (Element)s.pop();
        Element element2 = right;
        s.push((Object)new Primitive$mcZ$sp(!(element != null ? !element.equals(element2) : element2 != null)));
    }

    public static final /* synthetic */ void $anonfun$op2ExecutableOp$8(ArrayStack s) {
        boolean result = ((Primitive)s.pop()).x$mcZ$sp() && ((Primitive)s.pop()).x$mcZ$sp();
        s.push((Object)new Primitive$mcZ$sp(result));
    }

    public static final /* synthetic */ void $anonfun$op2ExecutableOp$9(ArrayStack s) {
        boolean result = ((Primitive)s.pop()).x$mcZ$sp() || ((Primitive)s.pop()).x$mcZ$sp();
        s.push((Object)new Primitive$mcZ$sp(result));
    }

    public static final /* synthetic */ void $anonfun$op2ExecutableOp$12(BinaryFunction function$1, ArrayStack s) {
        Element right = (Element)s.pop();
        Element left = (Element)s.pop();
        s.push(function$1.op().apply((Object)left, (Object)right));
    }

    public static final /* synthetic */ void $anonfun$op2ExecutableOp$13(ArrayStack s) {
        Element right = (Element)s.pop();
        Element left = (Element)s.pop();
        ArrayElement array = (ArrayElement)left;
        int index = ((Primitive)right).x$mcI$sp() - 1;
        if (index >= 0 && index < array.elements().length()) {
            SomeElement someElement;
            Element element = (Element)array.elements().apply(index);
            Product product = element instanceof SomeElement ? (someElement = (SomeElement)element) : (NullElement$.MODULE$.equals(element) ? NullElement$.MODULE$ : new SomeElement(element));
            SomeElement e = product;
            s.push((Object)e);
        } else {
            s.push((Object)NullElement$.MODULE$);
        }
    }

    public static final /* synthetic */ void $anonfun$op2ExecutableOp$14(ArrayStack s) {
        Element array = (Element)s.pop();
        int len = ((ArrayElement)array).elements().size();
        s.push((Object)new Primitive$mcI$sp(len));
    }

    public static final /* synthetic */ void $anonfun$op2ExecutableOp$15(int index$1, ArrayStack s) {
        StructElement struct = (StructElement)s.pop();
        s.push(struct.elements().apply(index$1));
    }

    public static final /* synthetic */ Element $anonfun$op2ExecutableOp$17(ArrayStack s$1, int _) {
        return (Element)s$1.pop();
    }

    public static final /* synthetic */ void $anonfun$op2ExecutableOp$18(ArrayStack s) {
        Element value = (Element)s.pop();
        s.push((Object)new SomeElement(value));
    }

    public ProgramRunner(Program program) {
        this.program = program;
        this.executables = (Vector)program.ops().map((Function1 & Serializable & scala.Serializable)op -> this.op2ExecutableOp((OpCode)op), Vector$.MODULE$.canBuildFrom());
    }
}

