/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.ds.converter;

import ai.mantik.ds.ArrayT;
import ai.mantik.ds.DataType;
import ai.mantik.ds.FundamentalType;
import ai.mantik.ds.FundamentalType$VoidType$;
import ai.mantik.ds.Image;
import ai.mantik.ds.ImageComponent;
import ai.mantik.ds.Nullable;
import ai.mantik.ds.Struct;
import ai.mantik.ds.Tensor;
import ai.mantik.ds.converter.Cast;
import ai.mantik.ds.converter.casthelper.FundamentalCasts$;
import ai.mantik.ds.converter.casthelper.ImageHelper$;
import ai.mantik.ds.converter.casthelper.TensorHelper$;
import ai.mantik.ds.element.ArrayElement;
import ai.mantik.ds.element.Element;
import ai.mantik.ds.element.ImageElement;
import ai.mantik.ds.element.NullElement$;
import ai.mantik.ds.element.NullableElement;
import ai.mantik.ds.element.Primitive;
import ai.mantik.ds.element.SomeElement;
import ai.mantik.ds.element.StructElement;
import ai.mantik.ds.element.StructElement$;
import ai.mantik.ds.element.TensorElement;
import cats.Applicative;
import cats.implicits$;
import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.GenIterable;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.IterableLike;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Vector$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;

public final class Cast$
implements scala.Serializable {
    public static Cast$ MODULE$;

    static {
        new Cast$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Either<String, Cast> findCast(DataType from, DataType to) {
        Tuple2 tuple2 = new Tuple2((Object)from, (Object)to);
        if (tuple2 != null) {
            DataType f = (DataType)tuple2._1();
            DataType t = (DataType)tuple2._2();
            if (f instanceof FundamentalType) {
                FundamentalType fundamentalType = (FundamentalType)f;
                if (t instanceof FundamentalType) {
                    FundamentalType fundamentalType2 = (FundamentalType)t;
                    return this.findFundamentalCast(fundamentalType, fundamentalType2);
                }
            }
        }
        if (tuple2 != null) {
            DataType f = (DataType)tuple2._1();
            DataType t = (DataType)tuple2._2();
            if (f instanceof FundamentalType) {
                FundamentalType fundamentalType = (FundamentalType)f;
                if (t instanceof Tensor) {
                    Tensor tensor = (Tensor)t;
                    return this.findFundamentalToTensorCast(fundamentalType, tensor);
                }
            }
        }
        if (tuple2 != null) {
            DataType t = (DataType)tuple2._1();
            DataType f = (DataType)tuple2._2();
            if (t instanceof Tensor) {
                Tensor tensor = (Tensor)t;
                if (f instanceof FundamentalType) {
                    FundamentalType fundamentalType = (FundamentalType)f;
                    return this.findTensorToFundamentalCast(tensor, fundamentalType);
                }
            }
        }
        if (tuple2 != null) {
            DataType t = (DataType)tuple2._1();
            DataType i = (DataType)tuple2._2();
            if (t instanceof Tensor) {
                Tensor tensor = (Tensor)t;
                if (i instanceof Image) {
                    Image image = (Image)i;
                    return this.findTensorToImageCast(tensor, image);
                }
            }
        }
        if (tuple2 != null) {
            DataType i = (DataType)tuple2._1();
            DataType t = (DataType)tuple2._2();
            if (i instanceof Image) {
                Image image = (Image)i;
                if (t instanceof Tensor) {
                    Tensor tensor = (Tensor)t;
                    return this.findImageToTensorCast(image, tensor);
                }
            }
        }
        if (tuple2 != null) {
            DataType from2 = (DataType)tuple2._1();
            DataType to2 = (DataType)tuple2._2();
            if (from2 instanceof Tensor) {
                Tensor tensor = (Tensor)from2;
                if (to2 instanceof Tensor) {
                    Tensor tensor2 = (Tensor)to2;
                    return this.findTensorToTensorCast(tensor, tensor2);
                }
            }
        }
        if (tuple2 != null) {
            DataType from3 = (DataType)tuple2._1();
            DataType to3 = (DataType)tuple2._2();
            if (from3 instanceof Image) {
                Image image = (Image)from3;
                if (to3 instanceof Image) {
                    Image image2 = (Image)to3;
                    return this.findImageToImageCast(image, image2);
                }
            }
        }
        if (tuple2 != null) {
            DataType from4 = (DataType)tuple2._1();
            DataType to4 = (DataType)tuple2._2();
            if (from4 instanceof Nullable) {
                Nullable nullable = (Nullable)from4;
                if (to4 instanceof Nullable) {
                    Nullable nullable2 = (Nullable)to4;
                    DataType dataType = nullable.underlying();
                    FundamentalType$VoidType$ fundamentalType$VoidType$ = FundamentalType$VoidType$.MODULE$;
                    if (dataType == null) {
                        if (fundamentalType$VoidType$ == null) return package$.MODULE$.Right().apply((Object)this.nullableVoidToAnyNullable(nullable2));
                    } else if (dataType.equals(fundamentalType$VoidType$)) {
                        return package$.MODULE$.Right().apply((Object)this.nullableVoidToAnyNullable(nullable2));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType from5 = (DataType)tuple2._1();
            DataType to5 = (DataType)tuple2._2();
            if (from5 instanceof Nullable) {
                Nullable nullable = (Nullable)from5;
                if (to5 instanceof Nullable) {
                    Nullable nullable3 = (Nullable)to5;
                    return this.findNullableToNullableCast(nullable, nullable3);
                }
            }
        }
        if (tuple2 != null) {
            DataType from6 = (DataType)tuple2._1();
            DataType to6 = (DataType)tuple2._2();
            if (from6 instanceof Nullable) {
                Nullable nullable = (Nullable)from6;
                return this.findNullableToNonNullableCast(nullable, to6);
            }
        }
        if (tuple2 != null) {
            DataType from7 = (DataType)tuple2._1();
            DataType to7 = (DataType)tuple2._2();
            if (to7 instanceof Nullable) {
                Nullable nullable = (Nullable)to7;
                return this.findNonNullableToNullableCast(from7, nullable);
            }
        }
        if (tuple2 != null) {
            DataType from8 = (DataType)tuple2._1();
            DataType to8 = (DataType)tuple2._2();
            if (from8 instanceof ArrayT) {
                ArrayT arrayT = (ArrayT)from8;
                if (to8 instanceof ArrayT) {
                    ArrayT arrayT2 = (ArrayT)to8;
                    return this.findArrayCast(arrayT, arrayT2);
                }
            }
        }
        if (tuple2 != null) {
            DataType from9 = (DataType)tuple2._1();
            DataType to9 = (DataType)tuple2._2();
            if (from9 instanceof Struct) {
                Struct struct = (Struct)from9;
                if (to9 instanceof Struct) {
                    Struct struct2 = (Struct)to9;
                    return this.findStructCast(struct, struct2);
                }
            }
        }
        if (tuple2 != null) {
            DataType from10 = (DataType)tuple2._1();
            DataType to10 = (DataType)tuple2._2();
            if (from10 instanceof Struct) {
                Struct struct = (Struct)from10;
                if (to10 != null) {
                    DataType dataType = to10;
                    return this.findUnpackingCast(struct, dataType);
                }
            }
        }
        if (tuple2 == null) return package$.MODULE$.Left().apply((Object)new StringBuilder(21).append("Cannot cast from ").append(from).append(" to ").append(to).toString());
        DataType from11 = (DataType)tuple2._1();
        DataType to11 = (DataType)tuple2._2();
        if (from11 == null) return package$.MODULE$.Left().apply((Object)new StringBuilder(21).append("Cannot cast from ").append(from).append(" to ").append(to).toString());
        DataType dataType = from11;
        if (!(to11 instanceof Struct)) return package$.MODULE$.Left().apply((Object)new StringBuilder(21).append("Cannot cast from ").append(from).append(" to ").append(to).toString());
        Struct struct = (Struct)to11;
        return this.findPackingCast(dataType, struct);
    }

    public Either<String, Cast> findFundamentalCast(FundamentalType from, FundamentalType to) {
        return FundamentalCasts$.MODULE$.findFundamentalCast(from, to);
    }

    private Either<String, Cast> findFundamentalToTensorCast(FundamentalType ft, Tensor tensor) {
        Seq<Object> seq = tensor.shape();
        List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}));
        if (seq == null ? list != null : !seq.equals((Object)list)) {
            return package$.MODULE$.Left().apply((Object)"Cannot cast a fundamental type into a non 1 Tensor");
        }
        return this.findFundamentalCast(ft, tensor.componentType()).map((Function1 & Serializable & scala.Serializable)toTensorType -> {
            Function1<IndexedSeq<Primitive<?>>, TensorElement<?>> packer = TensorHelper$.MODULE$.tensorPacker(tensor.componentType());
            return new Tuple2(toTensorType, packer);
        }).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Cast toTensorType = (Cast)tuple2._1();
            Function1 packer = (Function1)tuple2._2();
            Cast cast = toTensorType.append(new Cast(tensor.componentType(), tensor, false, false, (Function1<Element, Element>)(Function1 & Serializable & scala.Serializable)e -> (TensorElement)packer.apply((Object)package$.MODULE$.IndexedSeq().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Primitive[]{(Primitive)e})))));
            return cast;
        });
    }

    private Either<String, Cast> findTensorToFundamentalCast(Tensor tensor, FundamentalType ft) {
        Seq<Object> seq = tensor.shape();
        List list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}));
        if (seq == null ? list != null : !seq.equals((Object)list)) {
            return package$.MODULE$.Left().apply((Object)"Cannot cast a non-1 tensor to a fundamental type");
        }
        return this.findFundamentalCast(tensor.componentType(), ft).map((Function1 & Serializable & scala.Serializable)toSingleType -> {
            Function1<TensorElement<?>, IndexedSeq<Primitive<?>>> unpacker = TensorHelper$.MODULE$.tensorUnpacker(tensor.componentType());
            return new Tuple2(toSingleType, unpacker);
        }).map((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Cast toSingleType = (Cast)tuple2._1();
            Function1 unpacker = (Function1)tuple2._2();
            Cast cast = new Cast(tensor, tensor.componentType(), false, false, (Function1<Element, Element>)(Function1 & Serializable & scala.Serializable)e -> (Primitive)((IterableLike)unpacker.apply((Object)((TensorElement)e))).head()).append(toSingleType);
            return cast;
        });
    }

    private Either<String, Cast> findTensorToImageCast(Tensor tensor, Image image) {
        FundamentalType single;
        List list;
        Some some;
        if ((long)(image.width() * image.height()) != tensor.packedElementCount()) {
            return package$.MODULE$.Left().apply((Object)"Cannot cast a tensor with different element count to a image");
        }
        Iterable iterable = (Iterable)image.components().map((Function1 & Serializable & scala.Serializable)x$3 -> ((ImageComponent)x$3._2()).componentType(), Iterable$.MODULE$.canBuildFrom());
        if (!(iterable instanceof List) || (some = List$.MODULE$.unapplySeq((Seq)(list = (List)iterable))).isEmpty() || some.get() == null || ((LinearSeqOptimized)some.get()).lengthCompare(1) != 0) {
            return package$.MODULE$.Left().apply((Object)"Can only create single component images");
        }
        FundamentalType fundamentalType = single = (FundamentalType)((LinearSeqOptimized)some.get()).apply(0);
        FundamentalType imageComponentType = fundamentalType;
        return ImageHelper$.MODULE$.imagePacker(image).flatMap((Function1 & Serializable & scala.Serializable)imagePacker -> MODULE$.findFundamentalCast(tensor.componentType(), imageComponentType).map((Function1 & Serializable & scala.Serializable)typeConversion -> {
            Function1<TensorElement<?>, IndexedSeq<Primitive<?>>> tensorUnpacker = TensorHelper$.MODULE$.tensorUnpacker(tensor.componentType());
            return new Tuple2(typeConversion, tensorUnpacker);
        }).map((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Cast typeConversion = (Cast)tuple2._1();
            Function1 tensorUnpacker = (Function1)tuple2._2();
            Cast cast = new Cast(tensor, image, typeConversion.loosing(), typeConversion.canFail(), (Function1<Element, Element>)(Function1 & Serializable & scala.Serializable)e -> {
                IndexedSeq elements = (IndexedSeq)tensorUnpacker.apply((Object)((TensorElement)e));
                IndexedSeq casted = typeConversion.isIdentity() ? elements : (IndexedSeq)elements.map((Function1 & Serializable & scala.Serializable)x -> (Primitive)typeConversion.op().apply(x), IndexedSeq$.MODULE$.canBuildFrom());
                return (ImageElement)imagePacker.apply((Object)casted);
            });
            return cast;
        }));
    }

    private Either<String, Cast> findImageToTensorCast(Image image, Tensor tensor) {
        FundamentalType single;
        List list;
        Some some;
        if ((long)(image.width() * image.height()) != tensor.packedElementCount()) {
            return package$.MODULE$.Left().apply((Object)"Cannot cast a tensor with different element count to a image");
        }
        Iterable iterable = (Iterable)image.components().map((Function1 & Serializable & scala.Serializable)x$5 -> ((ImageComponent)x$5._2()).componentType(), Iterable$.MODULE$.canBuildFrom());
        if (!(iterable instanceof List) || (some = List$.MODULE$.unapplySeq((Seq)(list = (List)iterable))).isEmpty() || some.get() == null || ((LinearSeqOptimized)some.get()).lengthCompare(1) != 0) {
            return package$.MODULE$.Left().apply((Object)"Can only cast single component images");
        }
        FundamentalType fundamentalType = single = (FundamentalType)((LinearSeqOptimized)some.get()).apply(0);
        FundamentalType imageComponentType = fundamentalType;
        return ImageHelper$.MODULE$.imageUnpacker(image).flatMap((Function1 & Serializable & scala.Serializable)imageUnpacker -> MODULE$.findFundamentalCast(imageComponentType, tensor.componentType()).map((Function1 & Serializable & scala.Serializable)typeConversion -> {
            Function1<IndexedSeq<Primitive<?>>, TensorElement<?>> tensorPacker = TensorHelper$.MODULE$.tensorPacker(tensor.componentType());
            return new Tuple2(typeConversion, tensorPacker);
        }).map((Function1 & Serializable & scala.Serializable)x$6 -> {
            Tuple2 tuple2 = x$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Cast typeConversion = (Cast)tuple2._1();
            Function1 tensorPacker = (Function1)tuple2._2();
            Cast cast = new Cast(image, tensor, typeConversion.loosing(), typeConversion.canFail(), (Function1<Element, Element>)(Function1 & Serializable & scala.Serializable)i -> {
                IndexedSeq imageElements = (IndexedSeq)imageUnpacker.apply((Object)((ImageElement)i));
                IndexedSeq casted = typeConversion.isIdentity() ? imageElements : (IndexedSeq)imageElements.map((Function1 & Serializable & scala.Serializable)x -> (Primitive)typeConversion.op().apply(x), IndexedSeq$.MODULE$.canBuildFrom());
                return (TensorElement)tensorPacker.apply((Object)casted);
            });
            return cast;
        }));
    }

    private Either<String, Cast> findTensorToTensorCast(Tensor from, Tensor to) {
        if (from.packedElementCount() != to.packedElementCount()) {
            return package$.MODULE$.Left().apply((Object)new StringBuilder(39).append("Cannot cast ").append(from).append(" to ").append(to).append(" due incompatible shape").toString());
        }
        return this.findFundamentalCast(from.componentType(), to.componentType()).map((Function1 & Serializable & scala.Serializable)componentCast -> {
            Function1<TensorElement<?>, IndexedSeq<Primitive<?>>> unpacker = TensorHelper$.MODULE$.tensorUnpacker(from.componentType());
            Function1<IndexedSeq<Primitive<?>>, TensorElement<?>> packer = TensorHelper$.MODULE$.tensorPacker(to.componentType());
            return new Tuple3(componentCast, unpacker, packer);
        }).map((Function1 & Serializable & scala.Serializable)x$7 -> {
            Tuple3 tuple3 = x$7;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Cast componentCast = (Cast)tuple3._1();
            Function1 unpacker = (Function1)tuple3._2();
            Function1 packer = (Function1)tuple3._3();
            Cast cast = new Cast(from, to, componentCast.loosing(), componentCast.canFail(), (Function1<Element, Element>)(Function1 & Serializable & scala.Serializable)e -> {
                Element element;
                if (componentCast.isIdentity()) {
                    element = e;
                } else {
                    IndexedSeq unpacked = (IndexedSeq)unpacker.apply((Object)((TensorElement)e));
                    IndexedSeq converted = (IndexedSeq)unpacked.map((Function1 & Serializable & scala.Serializable)x -> (Primitive)componentCast.op().apply(x), IndexedSeq$.MODULE$.canBuildFrom());
                    element = (Element)packer.apply((Object)converted);
                }
                return element;
            });
            return cast;
        });
    }

    private Either<String, Cast> findImageToImageCast(Image from, Image to) {
        FundamentalType single;
        List list;
        Some some;
        FundamentalType single2;
        List list2;
        Some some2;
        Iterable iterable = (Iterable)from.components().map((Function1 & Serializable & scala.Serializable)x$8 -> ((ImageComponent)x$8._2()).componentType(), Iterable$.MODULE$.canBuildFrom());
        if (!(iterable instanceof List) || (some2 = List$.MODULE$.unapplySeq((Seq)(list2 = (List)iterable))).isEmpty() || some2.get() == null || ((LinearSeqOptimized)some2.get()).lengthCompare(1) != 0) {
            return package$.MODULE$.Left().apply((Object)"Can only cast single component images");
        }
        FundamentalType fundamentalType = single2 = (FundamentalType)((LinearSeqOptimized)some2.get()).apply(0);
        FundamentalType srcComponentType = fundamentalType;
        Iterable iterable2 = (Iterable)to.components().map((Function1 & Serializable & scala.Serializable)x$9 -> ((ImageComponent)x$9._2()).componentType(), Iterable$.MODULE$.canBuildFrom());
        if (!(iterable2 instanceof List) || (some = List$.MODULE$.unapplySeq((Seq)(list = (List)iterable2))).isEmpty() || some.get() == null || ((LinearSeqOptimized)some.get()).lengthCompare(1) != 0) {
            return package$.MODULE$.Left().apply((Object)"Can only cast single component images");
        }
        FundamentalType fundamentalType2 = single = (FundamentalType)((LinearSeqOptimized)some.get()).apply(0);
        FundamentalType dstComponentType = fundamentalType2;
        if (from.width() != to.width() || from.height() != to.height()) {
            return package$.MODULE$.Left().apply((Object)"Can only cast images with same size. You can override this through a tensor cast");
        }
        return this.findFundamentalCast(srcComponentType, dstComponentType).flatMap((Function1 & Serializable & scala.Serializable)componentCast -> ImageHelper$.MODULE$.imageUnpacker(from).flatMap((Function1 & Serializable & scala.Serializable)imageUnpacker -> ImageHelper$.MODULE$.imagePacker(to).map((Function1 & Serializable & scala.Serializable)imagePacker -> new Cast(from, to, componentCast.loosing(), componentCast.canFail(), (Function1<Element, Element>)(Function1 & Serializable & scala.Serializable)e -> {
            IndexedSeq unpacked = (IndexedSeq)imageUnpacker.apply((Object)((ImageElement)e));
            IndexedSeq casted = (IndexedSeq)unpacked.map((Function1 & Serializable & scala.Serializable)x -> (Primitive)componentCast.op().apply(x), IndexedSeq$.MODULE$.canBuildFrom());
            return (ImageElement)imagePacker.apply((Object)casted);
        }))));
    }

    private Either<String, Cast> findNullableToNullableCast(Nullable from, Nullable to) {
        return this.findCast(from.underlying(), to.underlying()).map((Function1 & Serializable & scala.Serializable)underlyingCast -> new Cast(from, to, underlyingCast.loosing(), underlyingCast.canFail(), (Function1<Element, Element>)(Function1 & Serializable & scala.Serializable)e -> {
            Product product;
            NullableElement nullableElement = (NullableElement)e;
            if (NullElement$.MODULE$.equals(nullableElement)) {
                product = NullElement$.MODULE$;
            } else if (nullableElement instanceof SomeElement) {
                SomeElement someElement = (SomeElement)nullableElement;
                Element x = someElement.x();
                product = new SomeElement(underlyingCast.convert(x));
            } else {
                throw new MatchError((Object)nullableElement);
            }
            return product;
        }));
    }

    private Either<String, Cast> findNullableToNonNullableCast(Nullable from, DataType to) {
        return this.findCast(from.underlying(), to).map((Function1 & Serializable & scala.Serializable)underlyingCast -> new Cast(from, to, underlyingCast.loosing(), true, (Function1<Element, Element>)(Function1 & Serializable & scala.Serializable)e -> {
            NullableElement nullableElement = (NullableElement)e;
            if (NullElement$.MODULE$.equals(nullableElement)) {
                throw new NoSuchElementException("Could not convert null to existing value");
            }
            if (!(nullableElement instanceof SomeElement)) {
                throw new MatchError((Object)nullableElement);
            }
            SomeElement someElement = (SomeElement)nullableElement;
            Element x = someElement.x();
            Element element = underlyingCast.convert(x);
            return element;
        }));
    }

    private Either<String, Cast> findNonNullableToNullableCast(DataType from, Nullable to) {
        return this.findCast(from, to.underlying()).map((Function1 & Serializable & scala.Serializable)underlyingCast -> new Cast(from, to, underlyingCast.loosing(), underlyingCast.canFail(), (Function1<Element, Element>)(Function1 & Serializable & scala.Serializable)e -> new SomeElement(underlyingCast.convert((Element)e))));
    }

    private Cast nullableVoidToAnyNullable(Nullable to) {
        return new Cast(new Nullable(FundamentalType$VoidType$.MODULE$), to, true, false, (Function1<Element, Element>)(Function1 & Serializable & scala.Serializable)x$10 -> NullElement$.MODULE$);
    }

    private Either<String, Cast> findArrayCast(ArrayT from, ArrayT to) {
        return this.findCast(from.underlying(), to.underlying()).map((Function1 & Serializable & scala.Serializable)underlyingCast -> new Cast(from, to, underlyingCast.loosing(), underlyingCast.canFail(), (Function1<Element, Element>)(Function1 & Serializable & scala.Serializable)from -> new ArrayElement((IndexedSeq<Element>)((IndexedSeq)((ArrayElement)from).elements().map(underlyingCast.op(), IndexedSeq$.MODULE$.canBuildFrom())))));
    }

    private Either<String, Cast> findStructCast(Struct from, Struct to) {
        return from.arity() != to.arity() ? package$.MODULE$.Left().apply((Object)new StringBuilder(38).append("Can not cast from ").append(from).append("(arity=").append(from.arity()).append(") to ").append(to).append("(arity=").append(to.arity()).append(")").toString()) : ((Either)implicits$.MODULE$.toTraverseOps(((TraversableLike)from.fields().values().toVector().zip((GenIterable)to.fields().values().toVector(), Vector$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DataType fromDt = (DataType)tuple2._1();
            DataType toDt = (DataType)tuple2._2();
            Either<String, Cast> either = MODULE$.findCast(fromDt, toDt);
            return either;
        }, Vector$.MODULE$.canBuildFrom()), implicits$.MODULE$.catsStdInstancesForVector()).sequence(Predef$.MODULE$.$conforms(), (Applicative)implicits$.MODULE$.catsStdInstancesForEither())).map((Function1 & Serializable & scala.Serializable)casts -> {
            Struct x$1 = from;
            Struct x$2 = to;
            boolean x$3 = casts.exists((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.canFail()));
            boolean x$4 = casts.exists((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.loosing()));
            Function1 & Serializable & scala.Serializable x$5 = (Function1 & Serializable & scala.Serializable)from -> new StructElement((IndexedSeq<Element>)((IndexedSeq)((TraversableLike)((StructElement)from).elements().zip((GenIterable)casts, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Element e = (Element)tuple2._1();
                Cast cast = (Cast)tuple2._2();
                Element element = (Element)cast.op().apply((Object)e);
                return element;
            }, IndexedSeq$.MODULE$.canBuildFrom())));
            return new Cast(x$1, x$2, x$4, x$3, (Function1<Element, Element>)x$5);
        });
    }

    private Either<String, Cast> findPackingCast(DataType from, Struct to) {
        Left left;
        if (to.arity() != 1) {
            left = package$.MODULE$.Left().apply((Object)"Can only pack single-arity tuples");
        } else {
            DataType singleType = (DataType)to.fields().values().head();
            left = this.findCast(from, singleType).map((Function1 & Serializable & scala.Serializable)cast -> {
                DataType x$1 = from;
                Struct x$2 = to;
                boolean x$3 = cast.canFail();
                boolean x$4 = cast.loosing();
                Function1 & Serializable & scala.Serializable x$5 = (Function1 & Serializable & scala.Serializable)from -> StructElement$.MODULE$.apply((Seq<Element>)Predef$.MODULE$.wrapRefArray((Object[])new Element[]{(Element)cast.op().apply(from)}));
                return new Cast(x$1, x$2, x$4, x$3, (Function1<Element, Element>)x$5);
            });
        }
        return left;
    }

    private Either<String, Cast> findUnpackingCast(Struct from, DataType to) {
        Left left;
        if (from.arity() != 1) {
            left = package$.MODULE$.Left().apply((Object)"Can only unpack single-arity tuples");
        } else {
            DataType singleType = (DataType)from.fields().values().head();
            left = this.findCast(singleType, to).map((Function1 & Serializable & scala.Serializable)cast -> {
                Struct x$1 = from;
                DataType x$2 = to;
                boolean x$3 = cast.canFail();
                boolean x$4 = cast.loosing();
                Function1 & Serializable & scala.Serializable x$5 = (Function1 & Serializable & scala.Serializable)from -> (Element)cast.op().apply(((StructElement)from).elements().head());
                return new Cast(x$1, x$2, x$4, x$3, (Function1<Element, Element>)x$5);
            });
        }
        return left;
    }

    public Cast apply(DataType from, DataType to, boolean loosing, boolean canFail, Function1<Element, Element> op) {
        return new Cast(from, to, loosing, canFail, op);
    }

    public Option<Tuple5<DataType, DataType, Object, Object, Function1<Element, Element>>> unapply(Cast x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)x$0.from(), (Object)x$0.to(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.loosing()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.canFail()), x$0.op()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Cast$() {
        MODULE$ = this;
    }
}

