/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.planner.repository.impl;

import ai.mantik.componently.AkkaRuntime;
import ai.mantik.componently.ComponentBase;
import ai.mantik.elements.errors.ConfigurationException;
import ai.mantik.planner.repository.FileRepository;
import ai.mantik.planner.repository.FileRepository$;
import ai.mantik.planner.repository.impl.LocalFileRepository$;
import akka.NotUsed;
import akka.NotUsed$;
import akka.actor.Cancellable;
import akka.stream.IOResult;
import akka.stream.scaladsl.FileIO$;
import akka.stream.scaladsl.Sink;
import akka.stream.scaladsl.Source;
import akka.util.ByteString;
import com.typesafe.config.Config;
import io.circe.Decoder;
import io.circe.Encoder;
import io.circe.Error;
import io.circe.parser.package$;
import io.circe.syntax.package;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\r=f\u0001\u0002%J\u0001QC\u0001b\u0018\u0001\u0003\u0006\u0004%\t\u0001\u0019\u0005\tW\u0002\u0011\t\u0011)A\u0005C\"IA\u000e\u0001B\u0001B\u0003-Q\u000e\u001d\u0005\u0006c\u0002!\tA\u001d\u0005\u0006c\u0002!\t\u0001\u001f\u0005\n\u0003\u0013\u0001!\u0019!C\t\u0003\u0017A\u0001\"!\t\u0001A\u0003%\u0011Q\u0002\u0005\n\u0003G\u0001!\u0019!C\u0001\u0003KA\u0001\"a\u000f\u0001A\u0003%\u0011q\u0005\u0005\n\u0003{\u0001!\u0019!C\u0001\u0003KA\u0001\"a\u0010\u0001A\u0003%\u0011q\u0005\u0005\b\u0003\u0003\u0002A\u0011BA\"\u0011)\ti\u0005\u0001b\u0001\n\u0003I\u0015q\n\u0005\t\u0003C\u0002\u0001\u0015!\u0003\u0002R!9\u00111\r\u0001\u0005\n\u0005\u0015\u0004bBA?\u0001\u0011\u0005\u0013q\u0010\u0005\b\u0003K\u0003A\u0011IAT\u0011\u001d\tI\f\u0001C!\u0003wCq!!:\u0001\t\u0003\n9\u000fC\u0004\u0002t\u0002!\t%!>\t\u000f\t\u0005\u0001\u0001\"\u0003\u0003\u0004!9!q\u0001\u0001\u0005\n\t%\u0001b\u0002B\u0007\u0001\u0011%!q\u0002\u0005\b\u0005'\u0001A\u0011\u0002B\u000b\u0011\u001d\u0011i\u0002\u0001C\u0005\u0005?Aqa!\u001f\u0001\t\u0013\u0019Y\bC\u0004\u0004\u0004\u0002!\t!a\u0011\t\u000f\r\u0015\u0005\u0001\"\u0003\u0004\b\"A1\u0011\u0013\u0001\u0005\u0002%\u001b\u0019\nC\u0004\u0004\u0016\u0002!\tea&\t\u000f\ru\u0005\u0001\"\u0003\u0004 \"i11\u0015\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0004&B<qA!\u000fJ\u0011\u0003\u0011YD\u0002\u0004I\u0013\"\u0005!Q\b\u0005\u0007c\n\"\tA!\u0012\t\u0013\t\u001d#E1A\u0005\u0002\t%\u0003\u0002\u0003B+E\u0001\u0006IAa\u0013\t\u0013\t]#E1A\u0005\u0002\t%\u0003\u0002\u0003B-E\u0001\u0006IAa\u0013\u0007\r\tm#\u0005\u0011B/\u0011)\tI\n\u000bBK\u0002\u0013\u0005!q\u000f\u0005\u000b\u0005sB#\u0011#Q\u0001\n\u0005\u001d\u0004BCAOQ\tU\r\u0011\"\u0001\u0003|!Q!Q\u0010\u0015\u0003\u0012\u0003\u0006I!a(\t\u0015\t}\u0004F!f\u0001\n\u0003\u0011\t\t\u0003\u0006\u0003\u0010\"\u0012\t\u0012)A\u0005\u0005\u0007Ca!\u001d\u0015\u0005\u0002\tE\u0005\"CAzQ\u0005\u0005I\u0011\u0001BO\u0011%\u0011)\u000bKI\u0001\n\u0003\u00119\u000bC\u0005\u0003>\"\n\n\u0011\"\u0001\u0003@\"I!1\u0019\u0015\u0012\u0002\u0013\u0005!Q\u0019\u0005\n\u0005\u0013D\u0013\u0011!C!\u0005\u0013B\u0011Ba3)\u0003\u0003%\tA!4\t\u0013\tU\u0007&!A\u0005\u0002\t]\u0007\"\u0003BrQ\u0005\u0005I\u0011\tBs\u0011%\u0011\u0019\u0010KA\u0001\n\u0003\u0011)\u0010C\u0005\u0003z\"\n\t\u0011\"\u0011\u0003|\"I!q \u0015\u0002\u0002\u0013\u00053\u0011\u0001\u0005\n\u0007\u0007A\u0013\u0011!C!\u0007\u000bA\u0011ba\u0002)\u0003\u0003%\te!\u0003\b\u0013\r5!%!A\t\u0002\r=a!\u0003B.E\u0005\u0005\t\u0012AB\t\u0011\u0019\th\b\"\u0001\u0004*!I11\u0001 \u0002\u0002\u0013\u00153Q\u0001\u0005\n\u0007Wq\u0014\u0011!CA\u0007[A\u0011b!\u000e?#\u0003%\tAa0\t\u0013\r]b(!A\u0005\u0002\u000ee\u0002\"CB&}E\u0005I\u0011\u0001B`\u0011%\u0019iEPA\u0001\n\u0013\u0019y\u0005C\u0005\u0004X\t\u0012\r\u0011b\u0001\u0004Z!A1Q\u000f\u0012!\u0002\u0013\u0019YFA\nM_\u000e\fGNR5mKJ+\u0007o\\:ji>\u0014\u0018P\u0003\u0002K\u0017\u0006!\u0011.\u001c9m\u0015\taU*\u0001\u0006sKB|7/\u001b;pefT!AT(\u0002\u000fAd\u0017M\u001c8fe*\u0011\u0001+U\u0001\u0007[\u0006tG/[6\u000b\u0003I\u000b!!Y5\u0004\u0001M\u0019\u0001!V.\u0011\u0005YKV\"A,\u000b\u0005a{\u0015aC2p[B|g.\u001a8uYfL!AW,\u0003\u001b\r{W\u000e]8oK:$()Y:f!\taV,D\u0001L\u0013\tq6J\u0001\bGS2,'+\u001a9pg&$xN]=\u0002\u0013\u0011L'/Z2u_JLX#A1\u0011\u0005\tLW\"A2\u000b\u0005\u0011,\u0017\u0001\u00024jY\u0016T!AZ4\u0002\u00079LwNC\u0001i\u0003\u0011Q\u0017M^1\n\u0005)\u001c'\u0001\u0002)bi\"\f!\u0002Z5sK\u000e$xN]=!\u0003-\t7n[1Sk:$\u0018.\\3\u0011\u0005Ys\u0017BA8X\u0005-\t5n[1Sk:$\u0018.\\3\n\u00051L\u0016A\u0002\u001fj]&$h\b\u0006\u0002toR\u0011AO\u001e\t\u0003k\u0002i\u0011!\u0013\u0005\u0006Y\u0012\u0001\u001d!\u001c\u0005\u0006?\u0012\u0001\r!\u0019\u000b\u0002sR\u0011AO\u001f\u0005\u0006Y\u0016\u0001\u001d!\u001c\u0015\u0003\u000bq\u00042!`A\u0003\u001b\u0005q(bA@\u0002\u0002\u00051\u0011N\u001c6fGRT!!a\u0001\u0002\u000b)\fg/\u0019=\n\u0007\u0005\u001daP\u0001\u0004J]*,7\r^\u0001\ngV\u00147i\u001c8gS\u001e,\"!!\u0004\u0011\t\u0005=\u0011QD\u0007\u0003\u0003#QA!a\u0005\u0002\u0016\u000511m\u001c8gS\u001eTA!a\u0006\u0002\u001a\u0005AA/\u001f9fg\u00064WM\u0003\u0002\u0002\u001c\u0005\u00191m\\7\n\t\u0005}\u0011\u0011\u0003\u0002\u0007\u0007>tg-[4\u0002\u0015M,(mQ8oM&<\u0007%A\bdY\u0016\fg.\u001e9J]R,'O^1m+\t\t9\u0003\u0005\u0003\u0002*\u0005]RBAA\u0016\u0015\u0011\ti#a\f\u0002\u0011\u0011,(/\u0019;j_:TA!!\r\u00024\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\u0005U\u0012!B:dC2\f\u0017\u0002BA\u001d\u0003W\u0011aBR5oSR,G)\u001e:bi&|g.\u0001\tdY\u0016\fg.\u001e9J]R,'O^1mA\u0005q1\r\\3b]V\u0004H+[7f_V$\u0018aD2mK\u0006tW\u000f\u001d+j[\u0016|W\u000f\u001e\u0011\u0002\u001f\u0015t7/\u001e:f\t&\u0014Xm\u0019;pef$\"!!\u0012\u0011\t\u0005\u001d\u0013\u0011J\u0007\u0003\u0003gIA!a\u0013\u00024\t!QK\\5u\u0003A!\u0018.\\3pkR\u001c6\r[3ek2,'/\u0006\u0002\u0002RA!\u00111KA/\u001b\t\t)F\u0003\u0003\u0002X\u0005e\u0013!B1di>\u0014(BAA.\u0003\u0011\t7n[1\n\t\u0005}\u0013Q\u000b\u0002\f\u0007\u0006t7-\u001a7mC\ndW-A\tuS6,w.\u001e;TG\",G-\u001e7fe\u0002\n\u0011\"\\1lK:+w/\u00133\u0015\u0005\u0005\u001d\u0004\u0003BA5\u0003orA!a\u001b\u0002tA!\u0011QNA\u001a\u001b\t\tyGC\u0002\u0002rM\u000ba\u0001\u0010:p_Rt\u0014\u0002BA;\u0003g\ta\u0001\u0015:fI\u00164\u0017\u0002BA=\u0003w\u0012aa\u0015;sS:<'\u0002BA;\u0003g\t!C]3rk\u0016\u001cHOR5mKN#xN]1hKR1\u0011\u0011QAL\u00037\u0003b!a!\u0002\u0006\u0006%UBAA\u0018\u0013\u0011\t9)a\f\u0003\r\u0019+H/\u001e:f!\u0011\tY)!%\u000f\u0007q\u000bi)C\u0002\u0002\u0010.\u000baBR5mKJ+\u0007o\\:ji>\u0014\u00180\u0003\u0003\u0002\u0014\u0006U%!\u0005$jY\u0016\u001cFo\u001c:bO\u0016\u0014Vm];mi*\u0019\u0011qR&\t\u000f\u0005e\u0005\u00031\u0001\u0002h\u0005Y1m\u001c8uK:$H+\u001f9f\u0011\u001d\ti\n\u0005a\u0001\u0003?\u000b\u0011\u0002^3na>\u0014\u0018M]=\u0011\t\u0005\u001d\u0013\u0011U\u0005\u0005\u0003G\u000b\u0019DA\u0004C_>dW-\u00198\u0002\u001dI,\u0017/^3ti\u001aKG.Z$fiR1\u0011\u0011VAY\u0003k\u0003b!a!\u0002\u0006\u0006-\u0006\u0003BAF\u0003[KA!a,\u0002\u0016\nia)\u001b7f\u000f\u0016$(+Z:vYRDq!a-\u0012\u0001\u0004\t9'\u0001\u0002jI\"I\u0011qW\t\u0011\u0002\u0003\u0007\u0011qT\u0001\u000b_B$\u0018.\\5ti&\u001c\u0017!C:u_J,g)\u001b7f)\u0011\ti,a9\u0011\r\u0005\r\u0015QQA`!!\t\t-a3\u0002P\u0006mWBAAb\u0015\u0011\t)-a2\u0002\u0011M\u001c\u0017\r\\1eg2TA!!3\u0002Z\u000511\u000f\u001e:fC6LA!!4\u0002D\n!1+\u001b8l!\u0011\t\t.a6\u000e\u0005\u0005M'\u0002BAk\u00033\nA!\u001e;jY&!\u0011\u0011\\Aj\u0005)\u0011\u0015\u0010^3TiJLgn\u001a\t\u0007\u0003\u0007\u000b))!8\u0011\t\u0005\u001d\u0013q\\\u0005\u0005\u0003C\f\u0019D\u0001\u0003M_:<\u0007bBAZ%\u0001\u0007\u0011qM\u0001\tY>\fGMR5mKR!\u0011\u0011^Ay!\u0019\t\u0019)!\"\u0002lB!\u00111RAw\u0013\u0011\ty/!&\u0003\u001d1{\u0017\r\u001a$jY\u0016\u0014Vm];mi\"9\u00111W\nA\u0002\u0005\u001d\u0014\u0001B2paf$b!a>\u0002z\u0006u\bCBAB\u0003\u000b\u000b)\u0005C\u0004\u0002|R\u0001\r!a\u001a\u0002\t\u0019\u0014x.\u001c\u0005\b\u0003\u007f$\u0002\u0019AA4\u0003\t!x.\u0001\u0005gS2,g*Y7f)\r\t'Q\u0001\u0005\b\u0003g+\u0002\u0019AA4\u00031iW\r^1GS2,g*Y7f)\r\t'1\u0002\u0005\b\u0003g3\u0002\u0019AA4\u00031\u0001\u0018M\u001d;GS2,g*Y7f)\r\t'\u0011\u0003\u0005\b\u0003g;\u0002\u0019AA4\u0003\u001d\u0011Xm]8mm\u0016$R!\u0019B\f\u00053Aq!a-\u0019\u0001\u0004\t9\u0007C\u0004\u0003\u001ca\u0001\r!a\u001a\u0002\r\u0015tG-\u001b8h\u0003!aw.\u00193NKR\fG\u0003\u0002B\u0011\u0007o\u00022Aa\t)\u001d\r\u0011)#\t\b\u0005\u0005O\u00119D\u0004\u0003\u0003*\tUb\u0002\u0002B\u0016\u0005gqAA!\f\u000329!\u0011Q\u000eB\u0018\u0013\u0005\u0011\u0016B\u0001)R\u0013\tqu*\u0003\u0002M\u001b&\u0011!jS\u0001\u0014\u0019>\u001c\u0017\r\u001c$jY\u0016\u0014V\r]8tSR|'/\u001f\t\u0003k\n\u001a2A\tB !\u0011\t9E!\u0011\n\t\t\r\u00131\u0007\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\tm\u0012A\u0005#je\u0016\u001cGo\u001c:z\u0007>tg-[4LKf,\"Aa\u0013\u0011\t\t5#1K\u0007\u0003\u0005\u001fR1A!\u0015h\u0003\u0011a\u0017M\\4\n\t\u0005e$qJ\u0001\u0014\t&\u0014Xm\u0019;pef\u001cuN\u001c4jO.+\u0017\u0010I\u0001\u000b\u001b\u0016$\u0018-\u00128eS:<\u0017aC'fi\u0006,e\u000eZ5oO\u0002\u0012ABR5mK6+G/\u0019#bi\u0006\u001cr\u0001\u000bB \u0005?\u0012)\u0007\u0005\u0003\u0002H\t\u0005\u0014\u0002\u0002B2\u0003g\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0003\u0003h\tEd\u0002\u0002B5\u0005[rA!!\u001c\u0003l%\u0011\u0011QG\u0005\u0005\u0005_\n\u0019$A\u0004qC\u000e\\\u0017mZ3\n\t\tM$Q\u000f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0005\u0005_\n\u0019$\u0006\u0002\u0002h\u0005a1m\u001c8uK:$H+\u001f9fAU\u0011\u0011qT\u0001\u000bi\u0016l\u0007o\u001c:bef\u0004\u0013a\u0003:fcV,7\u000f\u001e+j[\u0016,\"Aa!\u0011\t\t\u0015%1R\u0007\u0003\u0005\u000fS1A!#h\u0003\u0011!\u0018.\\3\n\t\t5%q\u0011\u0002\b\u0013:\u001cH/\u00198u\u00031\u0011X-];fgR$\u0016.\\3!)!\u0011\u0019Ja&\u0003\u001a\nm\u0005c\u0001BKQ5\t!\u0005C\u0004\u0002\u001a>\u0002\r!a\u001a\t\u0013\u0005uu\u0006%AA\u0002\u0005}\u0005b\u0002B@_\u0001\u0007!1\u0011\u000b\t\u0005'\u0013yJ!)\u0003$\"I\u0011\u0011\u0014\u0019\u0011\u0002\u0003\u0007\u0011q\r\u0005\n\u0003;\u0003\u0004\u0013!a\u0001\u0003?C\u0011Ba 1!\u0003\u0005\rAa!\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!\u0011\u0016\u0016\u0005\u0003O\u0012Yk\u000b\u0002\u0003.B!!q\u0016B]\u001b\t\u0011\tL\u0003\u0003\u00034\nU\u0016!C;oG\",7m[3e\u0015\u0011\u00119,a\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003<\nE&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001BaU\u0011\tyJa+\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!q\u0019\u0016\u0005\u0005\u0007\u0013Y+A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005\u001f\u0004B!a\u0012\u0003R&!!1[A\u001a\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011INa8\u0011\t\u0005\u001d#1\\\u0005\u0005\u0005;\f\u0019DA\u0002B]fD\u0011B!97\u0003\u0003\u0005\rAa4\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u00119\u000f\u0005\u0004\u0003j\n=(\u0011\\\u0007\u0003\u0005WTAA!<\u00024\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tE(1\u001e\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002 \n]\b\"\u0003Bqq\u0005\u0005\t\u0019\u0001Bm\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\t-#Q \u0005\n\u0005CL\u0014\u0011!a\u0001\u0005\u001f\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0005\u001f\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005\u0017\na!Z9vC2\u001cH\u0003BAP\u0007\u0017A\u0011B!9=\u0003\u0003\u0005\rA!7\u0002\u0019\u0019KG.Z'fi\u0006$\u0015\r^1\u0011\u0007\tUehE\u0003?\u0007'\u0019y\u0002\u0005\u0007\u0004\u0016\rm\u0011qMAP\u0005\u0007\u0013\u0019*\u0004\u0002\u0004\u0018)!1\u0011DA\u001a\u0003\u001d\u0011XO\u001c;j[\u0016LAa!\b\u0004\u0018\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001a\u0011\t\r\u00052qE\u0007\u0003\u0007GQ1a!\nh\u0003\tIw.\u0003\u0003\u0003t\r\rBCAB\b\u0003\u0015\t\u0007\u000f\u001d7z)!\u0011\u0019ja\f\u00042\rM\u0002bBAM\u0003\u0002\u0007\u0011q\r\u0005\n\u0003;\u000b\u0005\u0013!a\u0001\u0003?CqAa B\u0001\u0004\u0011\u0019)A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0003\u001d)h.\u00199qYf$Baa\u000f\u0004HA1\u0011qIB\u001f\u0007\u0003JAaa\u0010\u00024\t1q\n\u001d;j_:\u0004\"\"a\u0012\u0004D\u0005\u001d\u0014q\u0014BB\u0013\u0011\u0019)%a\r\u0003\rQ+\b\u000f\\34\u0011%\u0019IeQA\u0001\u0002\u0004\u0011\u0019*A\u0002yIA\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAB)!\u0011\u0011iea\u0015\n\t\rU#q\n\u0002\u0007\u001f\nTWm\u0019;\u0002\u001d5,G/\u0019#bi\u00064uN]7biV\u001111\f\n\u0007\u0007;\u001a\tga\u001c\u0007\r\r}#\u0005AB.\u00051a$/\u001a4j]\u0016lWM\u001c;?!\u0019\u0019\u0019ga\u001b\u0003\u00146\u00111Q\r\u0006\u0005\u0007O\u001aI'A\u0003dSJ\u001cWM\u0003\u0002\u0004&%!1QNB3\u0005\u001d)enY8eKJ\u0004baa\u0019\u0004r\tM\u0015\u0002BB:\u0007K\u0012q\u0001R3d_\u0012,'/A\bnKR\fG)\u0019;b\r>\u0014X.\u0019;!\u0011\u001d\t\u0019,\u0007a\u0001\u0003O\n\u0001b]1wK6+G/\u0019\u000b\u0007\u0003\u000b\u001aiha \t\u000f\u0005M&\u00041\u0001\u0002h!91\u0011\u0011\u000eA\u0002\t\u0005\u0012\u0001B7fi\u0006\fAC]3n_Z,G+[7f_V$X\r\u001a$jY\u0016\u001c\u0018A\u00054j]\u0012$\u0016.\\3pkR,GMR5mKN$Ba!#\u0004\u000eB1!qMBF\u0003OJAA!=\u0003v!91q\u0012\u000fA\u0002\t\r\u0015A\u00022pe\u0012,'/A\u0005mSN$h)\u001b7fgR\u00111\u0011R\u0001\u000bI\u0016dW\r^3GS2,G\u0003BBM\u00077\u0003b!a!\u0002\u0006\u0006}\u0005bBAZ=\u0001\u0007\u0011qM\u0001\u000fI\u0016dW\r^3GS2,\u0017*\u001c9m)\u0011\tyj!)\t\u000f\u0005Mv\u00041\u0001\u0002h\u0005\t2/\u001e9fe\u0012\n7n[1Sk:$\u0018.\\3\u0016\u00035D3\u0001ABU!\ri81V\u0005\u0004\u0007[s(!C*j]\u001edW\r^8o\u0001")
public class LocalFileRepository
extends ComponentBase
implements FileRepository {
    private final Path directory;
    private final Config subConfig;
    private final FiniteDuration cleanupInterval;
    private final FiniteDuration cleanupTimeout;
    private final Cancellable timeoutScheduler;

    public static Encoder<FileMetaData> metaDataFormat() {
        return LocalFileRepository$.MODULE$.metaDataFormat();
    }

    public static String MetaEnding() {
        return LocalFileRepository$.MODULE$.MetaEnding();
    }

    public static String DirectoryConfigKey() {
        return LocalFileRepository$.MODULE$.DirectoryConfigKey();
    }

    @Override
    public boolean requestFileGet$default$2() {
        return FileRepository.requestFileGet$default$2$(this);
    }

    private /* synthetic */ AkkaRuntime super$akkaRuntime() {
        return super.akkaRuntime();
    }

    public Path directory() {
        return this.directory;
    }

    public Config subConfig() {
        return this.subConfig;
    }

    public FiniteDuration cleanupInterval() {
        return this.cleanupInterval;
    }

    public FiniteDuration cleanupTimeout() {
        return this.cleanupTimeout;
    }

    private void ensureDirectory() {
        try {
            Files.createDirectories(this.directory(), new FileAttribute[0]);
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not create directory for local file repository. Check configuration.", (Throwable)e);
        }
    }

    public Cancellable timeoutScheduler() {
        return this.timeoutScheduler;
    }

    private String makeNewId() {
        return UUID.randomUUID().toString();
    }

    @Override
    public Future<FileRepository.FileStorageResult> requestFileStorage(String contentType, boolean temporary) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            FileMetaData meta = new FileMetaData(contentType, temporary, this.super$akkaRuntime().clock().instant());
            String id = this.makeNewId();
            this.saveMeta(id, meta);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Requested storage of new file {}", (Object)id);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return new FileRepository.FileStorageResult(id, FileRepository$.MODULE$.makePath(id));
        }, this.executionContext());
    }

    @Override
    public Future<FileRepository.FileGetResult> requestFileGet(String id, boolean optimistic) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> {
            None$ fileSize;
            FileMetaData fileMeta = this.loadMeta(id);
            File file = this.fileName(id).toFile();
            boolean fileExits = file.isFile();
            Object object = fileSize = fileExits ? Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable)() -> file.length()).toOption() : None$.MODULE$;
            if (!optimistic && !fileExits) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("File {} is not existing and request is not optimistic", (Object)id);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                throw FileRepository$.MODULE$.NotFoundCode().throwIt(new StringBuilder(24).append("File ").append(id).append(" is not yet written").toString(), FileRepository$.MODULE$.NotFoundCode().throwIt$default$2());
            }
            return new FileRepository.FileGetResult(id, fileMeta.temporary(), FileRepository$.MODULE$.makePath(id), fileMeta.contentType(), (Option<Object>)fileSize);
        }, this.executionContext());
    }

    @Override
    public Future<Sink<ByteString, Future<Object>>> storeFile(String id) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> this.loadMeta(id), this.executionContext()).map((Function1 & Serializable)meta -> {
            Path part = this.partFileName(id);
            Path file = this.fileName(id);
            Sink sink = FileIO$.MODULE$.toPath(part, FileIO$.MODULE$.toPath$default$2());
            return new Tuple4(meta, (Object)part, (Object)file, (Object)sink);
        }, this.executionContext()).map((Function1 & Serializable)x$1 -> {
            Tuple4 tuple4 = x$1;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            Path part = (Path)tuple4._2();
            Path file = (Path)tuple4._3();
            Sink sink = (Sink)tuple4._4();
            Sink sink2 = sink.mapMaterializedValue((Function1 & Serializable)writeResult -> writeResult.map((Function1 & Serializable)ioResult -> BoxesRunTime.boxToLong((long)LocalFileRepository.$anonfun$storeFile$5(this, part, file, ioResult)), this.executionContext()));
            return sink2;
        }, this.executionContext());
    }

    @Override
    public Future<FileRepository.LoadFileResult> loadFile(String id) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> {
            Path name = this.fileName(id);
            FileMetaData meta = this.loadMeta(id);
            boolean exists = Files.isRegularFile(name, new LinkOption[0]);
            long fileSize = name.toFile().length();
            if (!exists) {
                throw FileRepository$.MODULE$.NotFoundCode().throwIt(new StringBuilder(19).append("File ").append(id).append(" doesn't exist").toString(), FileRepository$.MODULE$.NotFoundCode().throwIt$default$2());
            }
            Source source = FileIO$.MODULE$.fromPath(name, FileIO$.MODULE$.fromPath$default$2()).mapMaterializedValue((Function1 & Serializable)x$2 -> NotUsed$.MODULE$);
            String x$1 = meta.contentType();
            long x$22 = fileSize;
            Source x$3 = source;
            return new FileRepository.LoadFileResult(x$22, x$1, (Source<ByteString, NotUsed>)x$3);
        }, this.executionContext());
    }

    @Override
    public Future<BoxedUnit> copy(String from, String to) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Path fromName = this.fileName(from);
            Path toName = this.fileName(to);
            FileMetaData fromMeta = this.loadMeta(from);
            FileMetaData toMeta = this.loadMeta(to);
            boolean exists = Files.isRegularFile(fromName, new LinkOption[0]);
            if (!exists) {
                throw FileRepository$.MODULE$.NotFoundCode().throwIt(new StringBuilder(19).append("File ").append(from).append(" doesn't exist").toString(), FileRepository$.MODULE$.NotFoundCode().throwIt$default$2());
            }
            String string = fromMeta.contentType();
            String string2 = toMeta.contentType();
            if (string == null ? string2 != null : !string.equals(string2)) {
                throw FileRepository$.MODULE$.InvalidContentType().throwIt(new StringBuilder(31).append("Content Type from=").append(fromMeta.contentType()).append(" to=").append(toMeta.contentType()).append(" mismatch").toString(), FileRepository$.MODULE$.InvalidContentType().throwIt$default$2());
            }
            Files.copy(fromName, toName, new CopyOption[0]);
            FileMetaData newMeta = toMeta.copy(fromMeta.contentType(), toMeta.copy$default$2(), toMeta.copy$default$3());
            this.saveMeta(to, newMeta);
        }, this.executionContext());
    }

    private Path fileName(String id) {
        return this.resolve(id, "");
    }

    private Path metaFileName(String id) {
        return this.resolve(id, LocalFileRepository$.MODULE$.MetaEnding());
    }

    private Path partFileName(String id) {
        return this.resolve(id, ".part");
    }

    private Path resolve(String id, String ending) {
        Predef$.MODULE$.require(!id.contains("/") && !id.contains("."), (Function0 & Serializable)() -> "Ids may not contain / or .");
        Predef$.MODULE$.require(ending.isEmpty() || ending.startsWith("."));
        Predef$.MODULE$.require(!ending.contains("/"));
        Predef$.MODULE$.require(!ending.contains("\\"));
        return this.directory().resolve(new StringBuilder(0).append(id).append(ending).toString());
    }

    private FileMetaData loadMeta(String id) {
        FileMetaData ok;
        String string;
        try {
            string = FileUtils.readFileToString((File)this.metaFileName(id).toFile(), (Charset)StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("File {} not found when loading meta data", (Object)id);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw FileRepository$.MODULE$.NotFoundCode().throwIt(new StringBuilder(23).append("File with id ").append(id).append(" not found").toString(), FileRepository$.MODULE$.NotFoundCode().throwIt$default$2());
        }
        String metaJson = string;
        Either either = package$.MODULE$.parse(metaJson).flatMap((Function1 & Serializable)x$3 -> x$3.as((Decoder)LocalFileRepository$.MODULE$.metaDataFormat()));
        if (either instanceof Left) {
            Left left = (Left)either;
            Error error = (Error)left.value();
            throw new RuntimeException("Could not parse Metadata", (Throwable)error);
        }
        if (!(either instanceof Right)) {
            throw new MatchError((Object)either);
        }
        Right right = (Right)either;
        FileMetaData fileMetaData = ok = (FileMetaData)right.value();
        FileMetaData parsed = fileMetaData;
        return parsed;
    }

    private void saveMeta(String id, FileMetaData meta) {
        Path metaFile = this.metaFileName(id);
        FileUtils.write((File)metaFile.toFile(), (CharSequence)package.EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps((Object)meta), LocalFileRepository$.MODULE$.metaDataFormat()).spaces2(), (Charset)StandardCharsets.UTF_8);
    }

    public void removeTimeoutedFiles() {
        BoxedUnit boxedUnit;
        Instant border = super.akkaRuntime().clock().instant().minus(this.cleanupTimeout().toSeconds(), ChronoUnit.SECONDS);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Checking for timeouted files, border: {}", (Object)border);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.findTimeoutedFiles(border).foreach((Function1 & Serializable)timeoutedFileId -> BoxesRunTime.boxToBoolean((boolean)this.deleteFileImpl(timeoutedFileId)));
    }

    private Iterator<String> findTimeoutedFiles(Instant border) {
        return this.listFiles().filter((Function1 & Serializable)id -> BoxesRunTime.boxToBoolean((boolean)LocalFileRepository.$anonfun$findTimeoutedFiles$1(this, border, id)));
    }

    public Iterator<String> listFiles() {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(Files.list(this.directory()).iterator()).asScala().collect((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends Path, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (((Object)A1.getFileName()).toString().endsWith(LocalFileRepository$.MODULE$.MetaEnding())) {
                    String id = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(((Object)A1.getFileName()).toString()), LocalFileRepository$.MODULE$.MetaEnding());
                    object = id;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Path x1) {
                Path path = x1;
                boolean bl = ((Object)path.getFileName()).toString().endsWith(LocalFileRepository$.MODULE$.MetaEnding());
                return bl;
            }
        });
    }

    @Override
    public Future<Object> deleteFile(String id) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> this.deleteFileImpl(id), this.executionContext());
    }

    /*
     * WARNING - void declaration
     */
    private boolean deleteFileImpl(String id) {
        boolean bl;
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Deleting {}...", (Object)id);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        try {
            void var2_2;
            boolean exists = Files.deleteIfExists(this.fileName(id));
            Files.deleteIfExists(this.partFileName(id));
            Files.deleteIfExists(this.metaFileName(id));
            bl = var2_2;
        }
        catch (Exception e) {
            BoxedUnit boxedUnit2;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Error on deleting file", (Throwable)e);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ long $anonfun$storeFile$5(LocalFileRepository $this, Path part$1, Path file$2, IOResult ioResult) {
        BoxedUnit boxedUnit;
        if ($this.logger().underlying().isDebugEnabled()) {
            $this.logger().underlying().debug("Written {} bytes to {}, moving to {}", new Object[]{BoxesRunTime.boxToLong((long)ioResult.count()), part$1, file$2});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Files.move(part$1, file$2, StandardCopyOption.ATOMIC_MOVE);
        return ioResult.count();
    }

    public static final /* synthetic */ boolean $anonfun$findTimeoutedFiles$1(LocalFileRepository $this, Instant border$1, String id) {
        boolean bl;
        block5: {
            try {
                FileMetaData meta = $this.loadMeta(id);
                if (meta.temporary() && meta.requestTime().isBefore(border$1)) {
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            catch (Exception e) {
                BoxedUnit boxedUnit;
                if ($this.logger().underlying().isDebugEnabled()) {
                    $this.logger().underlying().debug("Could not analyze meta", (Throwable)e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                bl = false;
            }
        }
        return bl;
    }

    public LocalFileRepository(Path directory, AkkaRuntime akkaRuntime) {
        BoxedUnit boxedUnit;
        this.directory = directory;
        super(akkaRuntime);
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Initializing Local File Repository in directory {}", (Object)directory);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.subConfig = this.config().getConfig("mantik.repository.fileRepository");
        this.cleanupInterval = Duration$.MODULE$.fromNanos(this.subConfig().getDuration("local.cleanupInterval").toNanos());
        this.cleanupTimeout = Duration$.MODULE$.fromNanos(this.subConfig().getDuration("local.cleanupTimeout").toNanos());
        this.ensureDirectory();
        this.timeoutScheduler = this.actorSystem().scheduler().scheduleWithFixedDelay(new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(10)).seconds(), this.cleanupInterval(), () -> this.removeTimeoutedFiles(), this.executionContext());
        this.addShutdownHook((Function0 & Serializable)() -> {
            this.timeoutScheduler().cancel();
            return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        });
    }

    @Inject
    public LocalFileRepository(AkkaRuntime akkaRuntime) {
        this(new File(akkaRuntime.config().getString(LocalFileRepository$.MODULE$.DirectoryConfigKey())).toPath(), akkaRuntime);
    }

    public static class FileMetaData
    implements Product,
    Serializable {
        private final String contentType;
        private final boolean temporary;
        private final Instant requestTime;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String contentType() {
            return this.contentType;
        }

        public boolean temporary() {
            return this.temporary;
        }

        public Instant requestTime() {
            return this.requestTime;
        }

        public FileMetaData copy(String contentType, boolean temporary, Instant requestTime) {
            return new FileMetaData(contentType, temporary, requestTime);
        }

        public String copy$default$1() {
            return this.contentType();
        }

        public boolean copy$default$2() {
            return this.temporary();
        }

        public Instant copy$default$3() {
            return this.requestTime();
        }

        public String productPrefix() {
            return "FileMetaData";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.contentType();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.temporary());
                    break;
                }
                case 2: {
                    object = this.requestTime();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof FileMetaData;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "contentType";
                    break;
                }
                case 1: {
                    string = "temporary";
                    break;
                }
                case 2: {
                    string = "requestTime";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.contentType()));
            n = Statics.mix((int)n, (int)(this.temporary() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.requestTime()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof FileMetaData)) return false;
            boolean bl = true;
            if (!bl) return false;
            FileMetaData fileMetaData = (FileMetaData)x$1;
            if (this.temporary() != fileMetaData.temporary()) return false;
            String string = this.contentType();
            String string2 = fileMetaData.contentType();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            Instant instant = this.requestTime();
            Instant instant2 = fileMetaData.requestTime();
            if (instant == null) {
                if (instant2 != null) {
                    return false;
                }
            } else if (!((Object)instant).equals(instant2)) return false;
            if (!fileMetaData.canEqual(this)) return false;
            return true;
        }

        public FileMetaData(String contentType, boolean temporary, Instant requestTime) {
            this.contentType = contentType;
            this.temporary = temporary;
            this.requestTime = requestTime;
            Product.$init$((Product)this);
        }
    }
}

