/*
 * Decompiled with CFR 0.152.
 */
package ai.mantik.planner.impl.exec;

import ai.mantik.componently.collections.DiGraph;
import ai.mantik.componently.collections.DiLink;
import ai.mantik.elements.MantikId;
import ai.mantik.elements.NamedMantikId;
import ai.mantik.planner.Plan;
import ai.mantik.planner.PlanFileReference;
import ai.mantik.planner.PlanFileReference$;
import ai.mantik.planner.PlanNodeService;
import ai.mantik.planner.PlanOp;
import ai.mantik.planner.graph.Link;
import ai.mantik.planner.graph.NodePort;
import ai.mantik.planner.impl.exec.UiStateService$;
import ai.mantik.ui.model.Operation;
import ai.mantik.ui.model.Operation$;
import ai.mantik.ui.model.OperationDefinition;
import ai.mantik.ui.model.OperationId;
import ai.mantik.ui.model.OperationState;
import ai.mantik.ui.model.RunGraphLink;
import ai.mantik.ui.model.RunGraphNode;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class UiTranslation$ {
    public static final UiTranslation$ MODULE$ = new UiTranslation$();

    public Seq<Operation> translateOperations(Plan<?> plan) {
        Seq alwaysPresent = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Operation[]{UiTranslation$.make$1((Either)package$.MODULE$.Left().apply((Object)UiStateService$.MODULE$.PrepareContainerName()), (OperationDefinition)new OperationDefinition.PrepareContainers()), UiTranslation$.make$1((Either)package$.MODULE$.Left().apply((Object)UiStateService$.MODULE$.PrepareFilesName()), (OperationDefinition)new OperationDefinition.PrepareFiles(plan.files().size()))}));
        Seq planOperations = (Seq)plan.flatWithCoordinates().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List coordinates = (List)tuple2._1();
            PlanOp op = (PlanOp)tuple2._2();
            OperationDefinition translated = MODULE$.translateOp(plan, op);
            Operation operation = UiTranslation$.make$1((Either)package$.MODULE$.Right().apply((Object)coordinates), translated);
            return operation;
        });
        return (Seq)alwaysPresent.$plus$plus((IterableOnce)planOperations);
    }

    private OperationDefinition translateOp(Plan<?> plan, PlanOp<?> planOp) {
        OperationDefinition.RunGraph runGraph;
        PlanOp<?> planOp2 = planOp;
        if (planOp2 instanceof PlanOp.RunGraph) {
            runGraph = new OperationDefinition.RunGraph();
        } else if (planOp2 instanceof PlanOp.UploadFile) {
            PlanOp.UploadFile uploadFile = (PlanOp.UploadFile)planOp2;
            runGraph = new OperationDefinition.UploadFile(Integer.toString(uploadFile.fileReference()), (String)plan.fileMap().get((Object)new PlanFileReference(uploadFile.fileReference())).map((Function1 & Serializable)x$1 -> x$1.contentType()).getOrElse((Function0 & Serializable)() -> "Unknown"), (Option)new Some((Object)BoxesRunTime.boxToLong((long)uploadFile.data().length())));
        } else if (planOp2 instanceof PlanOp.AddMantikItem) {
            PlanOp.AddMantikItem addMantikItem = (PlanOp.AddMantikItem)planOp2;
            runGraph = new OperationDefinition.ItemOp("add", (MantikId)addMantikItem.item().itemId(), UiTranslation$.nameOf$1(addMantikItem.item().mantikId()));
        } else if (planOp2 instanceof PlanOp.TagMantikItem) {
            PlanOp.TagMantikItem tagMantikItem = (PlanOp.TagMantikItem)planOp2;
            runGraph = new OperationDefinition.ItemOp("tag", (MantikId)tagMantikItem.item().itemId(), (Option)new Some((Object)tagMantikItem.id()));
        } else if (planOp2 instanceof PlanOp.PushMantikItem) {
            PlanOp.PushMantikItem pushMantikItem = (PlanOp.PushMantikItem)planOp2;
            runGraph = new OperationDefinition.ItemOp("push", (MantikId)pushMantikItem.item().itemId(), UiTranslation$.nameOf$1(pushMantikItem.item().mantikId()));
        } else if (planOp2 instanceof PlanOp.DeployAlgorithm) {
            PlanOp.DeployAlgorithm deployAlgorithm = (PlanOp.DeployAlgorithm)planOp2;
            runGraph = new OperationDefinition.UpdateDeployState((MantikId)deployAlgorithm.item().itemId(), true);
        } else if (planOp2 instanceof PlanOp.DeployPipeline) {
            PlanOp.DeployPipeline deployPipeline = (PlanOp.DeployPipeline)planOp2;
            runGraph = new OperationDefinition.UpdateDeployState((MantikId)deployPipeline.item().itemId(), true);
        } else {
            runGraph = new OperationDefinition.Other(planOp2.getClass().getSimpleName());
        }
        return runGraph;
    }

    public Seq<Tuple2<OperationId, DiGraph<String, RunGraphNode, RunGraphLink>>> translateRunGraphs(Plan<?> plan) {
        return (Seq)plan.flatWithCoordinates().collect((PartialFunction)new Serializable(plan){
            private static final long serialVersionUID = 0L;
            private final Plan plan$2;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<List<Object>, PlanOp<?>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    List coordinates = (List)A1._1();
                    PlanOp planOp = (PlanOp)A1._2();
                    if (planOp instanceof PlanOp.RunGraph) {
                        PlanOp.RunGraph runGraph = (PlanOp.RunGraph)planOp;
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new OperationId((Either)package$.MODULE$.Right().apply((Object)coordinates))), UiTranslation$.MODULE$.ai$mantik$planner$impl$exec$UiTranslation$$translateRunGraph(this.plan$2, runGraph));
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<List<Object>, PlanOp<?>> x1) {
                PlanOp planOp;
                Tuple2<List<Object>, PlanOp<?>> tuple2 = x1;
                boolean bl = tuple2 != null && (planOp = (PlanOp)tuple2._2()) instanceof PlanOp.RunGraph;
                return bl;
            }
            {
                this.plan$2 = plan$2;
            }
        });
    }

    public DiGraph<String, RunGraphNode, RunGraphLink> ai$mantik$planner$impl$exec$UiTranslation$$translateRunGraph(Plan<?> plan, PlanOp.RunGraph runGraph) {
        Map nodes = runGraph.graph().nodes().view().mapValues((Function1 & Serializable)n -> MODULE$.translateNode(plan, (PlanNodeService)n.service())).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Vector links = ((IterableOnceOps)runGraph.graph().links().map((Function1 & Serializable)link -> MODULE$.translateLink(runGraph, (Link)link))).toVector();
        return new DiGraph(nodes, links);
    }

    private RunGraphNode translateNode(Plan<?> plan, PlanNodeService node) {
        RunGraphNode.FileNode fileNode;
        PlanNodeService planNodeService = node;
        if (planNodeService instanceof PlanNodeService.File) {
            PlanNodeService.File file = (PlanNodeService.File)planNodeService;
            fileNode = new RunGraphNode.FileNode(file.fileReference(), (String)plan.fileMap().get((Object)new PlanFileReference(PlanFileReference$.MODULE$.fromInt(file.fileReference()))).map((Function1 & Serializable)x$2 -> x$2.contentType()).getOrElse((Function0 & Serializable)() -> "Unknown"));
        } else if (planNodeService instanceof PlanNodeService.DockerContainer) {
            PlanNodeService.DockerContainer dockerContainer = (PlanNodeService.DockerContainer)planNodeService;
            Option payloadFileContentType = dockerContainer.data().flatMap((Function1 & Serializable)id -> UiTranslation$.$anonfun$translateNode$3(plan, ((PlanFileReference)id).id())).map((Function1 & Serializable)x$3 -> x$3.contentType()).orElse((Function0 & Serializable)() -> dockerContainer.embeddedData().map((Function1 & Serializable)x$4 -> (String)x$4._1()));
            fileNode = new RunGraphNode.MnpNode(dockerContainer.container().image(), dockerContainer.container().parameters(), dockerContainer.mantikHeader().toJsonValue(), payloadFileContentType, dockerContainer.embeddedData().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)UiTranslation$.$anonfun$translateNode$7(x$5))));
        } else {
            throw new MatchError((Object)planNodeService);
        }
        return fileNode;
    }

    private DiLink<String, RunGraphLink> translateLink(PlanOp.RunGraph graph, Link link) {
        String contentType = (String)graph.graph().resolveOutput(link.from()).map((Function1 & Serializable)x$6 -> ((NodePort)x$6._2()).contentType()).orElse((Function0 & Serializable)() -> graph.graph().resolveInput(link.from()).map((Function1 & Serializable)x$7 -> ((NodePort)x$7._2()).contentType())).getOrElse((Function0 & Serializable)() -> "Unknown");
        return new DiLink((Object)link.from().node(), (Object)link.to().node(), (Object)new RunGraphLink(link.from().port(), link.to().port(), contentType, (Option)None$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    private static final Operation make$1(Either subId, OperationDefinition definition) {
        void var3_9;
        OperationId operationId;
        OperationId x$1 = operationId = new OperationId(subId);
        OperationState.Pending$ x$2 = OperationState.Pending$.MODULE$;
        OperationDefinition x$3 = definition;
        Option x$4 = Operation$.MODULE$.apply$default$3();
        Option x$5 = Operation$.MODULE$.apply$default$4();
        Option x$6 = Operation$.MODULE$.apply$default$5();
        Operation operation = new Operation(x$1, (OperationState)x$2, x$4, x$5, x$6, x$3);
        return var3_9;
    }

    private static final Option nameOf$1(MantikId mantikId) {
        None$ none$;
        MantikId mantikId2 = mantikId;
        if (mantikId2 instanceof NamedMantikId) {
            NamedMantikId namedMantikId = (NamedMantikId)mantikId2;
            none$ = new Some((Object)namedMantikId);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static final /* synthetic */ Option $anonfun$translateNode$3(Plan plan$4, int id) {
        return plan$4.fileMap().get((Object)new PlanFileReference(id));
    }

    public static final /* synthetic */ long $anonfun$translateNode$7(Tuple2 x$5) {
        return ((SeqOps)x$5._2()).length();
    }

    private UiTranslation$() {
    }
}

