package com.ai.osmos.AdRenderSDK


// Enum for Ad Types
enum class AdType {
    IMAGE, VIDEO, CAROUSEL,MULTI_AD, UNKNOWN;

    companion object {
        fun fromString(type: String?): AdType {
            return when (type?.uppercase()) {
                "IMAGE" -> IMAGE
                "VIDEO" -> VIDEO
                "CAROUSEL" -> CAROUSEL
                "MULTI_AD" -> MULTI_AD
                else -> UNKNOWN
            }
        }
    }
}

// Landing Product List
data class LandingProductList(
    val sku_id: String,
    val e_currency: String,
    val e_image_link: String
)

// Ad Element for Image and Video Ads
data class AdElement(
    val value: String,
    val height: Int,
    val width: Int,
    val type: String,
    val destination_url: String? = null,
    val landing_product_list: List<LandingProductList>? = emptyList(),
    val video_progress_sec: Int? = 3,
    val close_button_sec: Int? = 2
)

// Image Ad Model
data class ImageAd(
    val client_id: Long,
    val au: String,
    val rank: Int,
    val click_tracking_url: String,
    val impression_tracking_url: String,
    val uclid: String,
    override val crt: String,
    val elements: AdElement,
    override val adMetadata: Map<String, Any>? = null,
    override val cli_ubid: String? = ""
) : BaseAd() {
    override val elementsType: AdType
        get() = AdType.fromString(elements.type)
}

// Video Ad Model
data class VideoAd(
    val client_id: Long,
    val au: String,
    val rank: Int,
    val click_tracking_url: String,
    val impression_tracking_url: String,
    val uclid: String,
    override val crt: String,
    val elements: AdElement,
    override val adMetadata: Map<String, Any>? = null,
    override val cli_ubid: String? = ""
) : BaseAd() {
    override val elementsType: AdType
        get() = AdType.fromString(elements.type)
}

// Media Element for Carousel Ads
data class MediaElement(
    val value: String,
    val height: Int,
    val width: Int,
    val type: String
)

// Carousel Ad Element
data class CarouselAdElement(
    val media: MediaElement,
    val destination_url: String
)

data class CarouselAdElementsWrapper(
    val carousel_cards: List<CarouselAdElement>
)

// Carousel Ad Model
data class CarouselAd(
    val client_id: Long,
    val au: String,
    val rank: Int,
    val click_tracking_url: String,
    val impression_tracking_url: String,
    val uclid: String,
    override val crt: String,
    val elements: CarouselAdElementsWrapper,
    override val adMetadata: Map<String, Any>? = null,
    override val cli_ubid: String? = ""
) : BaseAd() {
    override val elementsType: AdType = AdType.CAROUSEL
}


// Carousel Ad Model
data class MultiAd(
    val client_id: Long,
    val au: String,
    val rank: Int,
    val click_tracking_url: String,
    val impression_tracking_url: String,
    val uclid: String,
    override val crt: String,
    val elements: AdElement,
    override val adMetadata: Map<String, Any>? = null,
    override val cli_ubid: String? = ""
) : BaseAd() {
    override val elementsType: AdType = AdType.MULTI_AD
}

// AdData Wrapper to Handle Multiple Ad Types
data class AdData(
    val ads: Map<String, List<BaseAd>>,
    val imageAdList: List<ImageAd> = emptyList(),
    val videoAdList: List<VideoAd> = emptyList(),
    val carouselAdList: List<CarouselAd> = emptyList()
)


