package com.ai.osmos.AdRenderSDK

/**
 * Created by adeshmukh on 06/05/25.
 * Project Name: OSMOS-Android-SDK
 * File Name: BaseAdExtensions
 */

fun mapAdElement(element: AdElement): Map<String, Any?> {
    return mapOf(
        "value" to element.value,
        "height" to element.height,
        "width" to element.width,
        "type" to element.type,
        "destination_url" to element.destination_url,
        "landing_product_list" to element.landing_product_list,
        "video_progress_sec" to element.video_progress_sec,
        "close_button_sec" to element.close_button_sec
    )
}

fun BaseAd.toMap(): Map<String, Any> {
    val baseMap = mutableMapOf<String, Any?>(
        "client_id" to when (this) {
            is ImageAd -> this.client_id
            is VideoAd -> this.client_id
            is CarouselAd -> this.client_id
            is MultiAd -> this.client_id
            else -> null
        },
        "au" to when (this) {
            is ImageAd -> this.au
            is VideoAd -> this.au
            is CarouselAd -> this.au
            is MultiAd -> this.au
            else -> null
        },
        "rank" to when (this) {
            is ImageAd -> this.rank
            is VideoAd -> this.rank
            is CarouselAd -> this.rank
            is MultiAd -> this.rank
            else -> null
        },
        "uclid" to when (this) {
            is ImageAd -> this.uclid
            is VideoAd -> this.uclid
            is CarouselAd -> this.uclid
            is MultiAd -> this.uclid
            else -> null
        },
        "crt" to this.crt,
        "cli_ubid" to this.cli_ubid,
        "adMetadata" to this.adMetadata,
        "elementsType" to this.elementsType.name
    )

    when (this) {
        is ImageAd -> baseMap["elements"] = mapAdElement(this.elements)
        is VideoAd -> baseMap["elements"] = mapAdElement(this.elements)
        is MultiAd -> baseMap["elements"] = mapAdElement(this.elements)
        is CarouselAd -> {
            baseMap["carousel_cards"] = this.elements.carousel_cards.map { element ->
                mapOf(
                    "media" to mapOf(
                        "value" to element.media.value,
                        "height" to element.media.height,
                        "width" to element.media.width,
                        "type" to element.media.type
                    ),
                    "destination_url" to element.destination_url
                )
            }
        }
    }

    return baseMap.filterValues { it != null } as Map<String, Any>
}

fun List<MultiAd>.toMapList(): List<Map<String, Any>> {
    return this.map { it.toMap() }
}
