package com.ai.osmos.AdRenderSDK

import android.annotation.SuppressLint
import android.app.Activity
import android.content.Context
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext

/**
 * Created by adeshmukh on 23/04/25.
 * Project Name: OSMOS-Android-SDK
 * File Name: CarouselAdView
 */
@SuppressLint("ViewConstructor")
class CarouselAdView @JvmOverloads constructor(
    context: Context,
    adData: Map<String, Any>,
    private val width: Int? = null,
    private val height: Int? = null,
) : BaseAdView(context) {

    private val adTracker = AdTracker(coroutineScope)
    private val carouselLoader = CarouselLoader(coroutineScope,adTracker)

    init {
        if (adData.isNotEmpty()) loadAd(adData,context) else showEmptyView(context)
    }

    override fun loadAd(adData: Map<String, Any>, context: Context) {
        removeAllViews()
        coroutineScope.launch(Dispatchers.IO) {
            try {
                if (isRecyclerViewAvailable()){
                    val ad = adData["ad"] as? BaseAd
                    if (ad != null) {
                        val cliUbid = getCliUbid(ad)
                        if (isSupportedCrtCarousel(ad.crt)) {
                            withContext(Dispatchers.Main) {
                                val carouselAd = ad as? CarouselAd
                                if (carouselAd != null){

                                    val view = carouselLoader.renderCarouselView(
                                        context,
                                        width = width,
                                        height = height,
                                        cliUbid = cliUbid,
                                        adList = carouselAd.elements.carousel_cards,
                                        carouselAd = carouselAd,
                                        adClickedListener = itemClickedListener)
                                    addView(view)
                                } else showEmptyView(context)
                            }
                        } else showEmptyView(context)
                    } else showEmptyView(context)
                } else showEmptyView(context)
            }
            catch (e: Exception){
                 showEmptyView(context)
            }
        }
    }

    override fun loadAd(adData: Map<String, Any>, activity: Activity?) {

    }


    override fun onDetachedFromWindow() {
        carouselLoader.releaseAllPlayers()
        super.onDetachedFromWindow()
    }
}
