package com.ai.osmos.AdRenderSDK

import android.util.Log
import org.json.JSONObject

/**
 * Created by adeshmukh on 19/03/25.
 * Project Name: OSMOS-Android-SDK
 * File Name: JSONParsingData
 */

class JSONParsing {
    companion object {
        private fun mapToJson(map: Map<String, Any>?): String {
            return try {
                JSONObject(map ?: emptyMap<String, Any>()).toString()
            } catch (e: Exception) {
                "{}"
            }
        }

        fun parseAdData(response: Map<String, Any>, cli_ubid: String): Map<String, List<BaseAd>> {
            val result = mutableMapOf<String, List<BaseAd>>()
            try {
                val jsonString = mapToJson(response)

                val root = JSONObject(jsonString)
                val responseObject = root.optJSONObject("response") ?: return result
                val dataString = responseObject.optString("data")
                val dataObject = JSONObject(dataString)
                val adsObject = dataObject.optJSONObject("ads") ?: return result

                val keys = adsObject.keys()
                while (keys.hasNext()) {
                    val key = keys.next()
                    val adArray = adsObject.getJSONArray(key)
                    val adList = mutableListOf<BaseAd>()

                    for (i in 0 until adArray.length()) {
                        val adObj = adArray.getJSONObject(i)
                        val elements = adObj.optJSONObject("elements") ?: continue

                        var adType = AdType.fromString(elements.optString("type", "IMAGE"))

                        if (elements.has("carousel_cards")) {
                            adType = AdType.fromString("CAROUSEL")
                        }
                        if (adArray.length() > 1) {
                            adType = AdType.fromString("MULTI_AD")
                        }

                        val baseAd: BaseAd? = when (adType) {
                            AdType.IMAGE -> parseImageAd(adObj, cli_ubid)
                            AdType.VIDEO -> parseVideoAd(adObj, cli_ubid)
                            AdType.CAROUSEL -> parseCarouselAd(adObj, cli_ubid)
                            AdType.MULTI_AD -> parseMultiAds(adObj, cli_ubid)
                            AdType.UNKNOWN  -> null
                        }
                        baseAd?.let { adList.add(it) }
                    }
                    result[key] = adList
                }
                return result
            }
            catch (e: Exception){
                return result
            }
        }

        private fun JSONObject.safeString(key: String, default: String = ""): String =
            if (has(key)) optString(key, default) else default

        private fun JSONObject.safeInt(key: String, default: Int = 0): Int =
            if (has(key)) optInt(key, default) else default

        private fun parseImageAd(adObject: JSONObject, cli_ubid: String): ImageAd {
            val elementsObject = adObject.getJSONObject("elements")

            val landingProducts = mutableListOf<LandingProductList>()
//            if (elementsObject.has("landing_product_list")) {
//                val landingArray = elementsObject.getJSONArray("landing_product_list")
//                for (j in 0 until landingArray.length()) {
//                    val productObj = landingArray.getJSONObject(j)
//                    landingProducts.add(
//                        LandingProductList(
//                            sku_id = productObj.getString("sku_id"),
//                            e_currency = productObj.getString("e_currency"),
//                            e_image_link = productObj.getString("e_image_link")
//                        )
//                    )
//                }
//            }

            val adElement = AdElement(
                value = elementsObject.safeString("value"),
                height = elementsObject.safeInt("height"),
                width = elementsObject.safeInt("width"),
                type = elementsObject.safeString("type"),
                destination_url = elementsObject.optString("destination_url", null),
                landing_product_list = landingProducts,
                close_button_sec = if (elementsObject.has("close_button_sec")) {
                    elementsObject.getInt("close_button_sec")
                } else null
            )

            return ImageAd(
                client_id = adObject.optLong("client_id"),
                au = adObject.optString("au"),
                rank = adObject.optInt("rank"),
                click_tracking_url = adObject.optString("click_tracking_url"),
                impression_tracking_url = adObject.optString("impression_tracking_url"),
                uclid = adObject.optString("uclid"),
                crt = adObject.optString("crt"),
                elements = adElement,
                cli_ubid = cli_ubid
            )
        }

        private fun parseVideoAd(adObject: JSONObject, cli_ubid: String): VideoAd {
            val elementsObject = adObject.getJSONObject("elements")
            val adElement = AdElement(
                value = elementsObject.safeString("value"),
                height = elementsObject.safeInt("height"),
                width = elementsObject.safeInt("width"),
                type = elementsObject.safeString("type"),
                destination_url = elementsObject.optString("destination_url", null),
                video_progress_sec = if (elementsObject.has("video_progress_sec")) {
                    elementsObject.getInt("video_progress_sec")
                } else null,
                close_button_sec = if (elementsObject.has("close_button_sec")) {
                    elementsObject.getInt("close_button_sec")
                } else null
            )

            return VideoAd(
                client_id = adObject.optLong("client_id"),
                au = adObject.optString("au"),
                rank = adObject.optInt("rank"),
                click_tracking_url = adObject.optString("click_tracking_url"),
                impression_tracking_url = adObject.optString("impression_tracking_url"),
                uclid = adObject.optString("uclid"),
                crt = adObject.optString("crt"),
                elements = adElement,
                cli_ubid = cli_ubid
            )
        }

        private fun parseCarouselAd(adObject: JSONObject, cli_ubid: String): CarouselAd {

            val elementsObject = adObject.getJSONObject("elements")
            val carouselArray = elementsObject.getJSONArray("carousel_cards")

            val carouselCards = mutableListOf<CarouselAdElement>()
            for (i in 0 until carouselArray.length()) {
                val cardObj = carouselArray.getJSONObject(i)
                val mediaObj = cardObj.getJSONObject("media")

                val media = MediaElement(
                    value = mediaObj.optString("value"),
                    height = mediaObj.optInt("height"),
                    width = mediaObj.optInt("width"),
                    type = mediaObj.optString("type")
                )

                val element = CarouselAdElement(
                    media = media,
                    destination_url = cardObj.optString("destination_url")
                )

                carouselCards.add(element)
            }

            return CarouselAd(
                client_id = adObject.optLong("client_id"),
                au = adObject.optString("au"),
                rank = adObject.optInt("rank"),
                click_tracking_url = adObject.optString("click_tracking_url"),
                impression_tracking_url = adObject.optString("impression_tracking_url"),
                uclid = adObject.optString("uclid"),
                crt = adObject.optString("crt"),
                elements = CarouselAdElementsWrapper(carousel_cards = carouselCards), // wrapped
                cli_ubid = cli_ubid
            )
        }

        private fun parseMultiAds(adObject: JSONObject, cli_ubid: String): MultiAd {

            val elementsObject =adObject.getJSONObject("elements")

            val adElement = AdElement(
                value = elementsObject.safeString("value"),
                height = elementsObject.safeInt("height"),
                width = elementsObject.safeInt("width"),
                type = elementsObject.safeString("type"),
                destination_url = elementsObject.optString("destination_url", null),
                video_progress_sec = if (elementsObject.has("video_progress_sec")) {
                    elementsObject.getInt("video_progress_sec")
                } else null,
                close_button_sec = if (elementsObject.has("close_button_sec")) {
                    elementsObject.getInt("close_button_sec")
                } else null
            )

            val multiAd = MultiAd(
                client_id = adObject.optLong("client_id"),
                au = adObject.optString("au"),
                rank = adObject.optInt("rank"),
                click_tracking_url = adObject.optString("click_tracking_url"),
                impression_tracking_url = adObject.optString("impression_tracking_url"),
                uclid = adObject.optString("uclid"),
                crt = adObject.optString("crt"),
                elements = adElement,
                cli_ubid = cli_ubid
            )
            return multiAd
        }
    }
}
