package com.ai.osmos.AdRenderSDK

import android.annotation.SuppressLint
import android.app.Activity
import android.content.Context
import android.util.Log
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext

/**
 * Created by adeshmukh on 30/04/25.
 * Project Name: OSMOS-Android-SDK
 * File Name: MultiAdCarouselView
 */

@SuppressLint("ViewConstructor")
class MultiAdCarouselView @JvmOverloads constructor(
    context: Context,
    adData: Map<String, Any>,
    private val width: Int? = null,
    private val height: Int? = null
) : BaseAdView(context) {

    private val adTracker = AdTracker(coroutineScope)
    private val carouselLoader = CarouselLoader(coroutineScope,adTracker)

    init {
        if (adData.isNotEmpty()) loadAd(adData,context) else showEmptyView(context)
    }

    override fun loadAd(adData: Map<String, Any>, context: Context) {
        removeAllViews()
        coroutineScope.launch(Dispatchers.IO) {
            try {
                if (isRecyclerViewAvailable()){
                    val ad = adData["ad"] as? List<MultiAd>

                    if (ad != null) {
                        withContext(Dispatchers.Main) {
                            val view = carouselLoader.renderMultiAdCarouselView(
                                context,
                                width = width,
                                height = height,
                                multiAd = ad,
                                adClickListener = adClickedListener)
                            addView(view)
                        }
                    } else showEmptyView(context)
                } else showEmptyView(context)

            }
            catch (e: Exception){
                withContext(Dispatchers.Main) {
                    showEmptyView(context)
                }
            }
        }
    }

    override fun loadAd(adData: Map<String, Any>, activity: Activity?) {

    }

    override fun onDetachedFromWindow() {
        carouselLoader.releaseAllPlayers()
        super.onDetachedFromWindow()
    }
}

