
package com.ai.osmos.AdRenderSDK

import android.annotation.SuppressLint
import android.app.Activity
import android.content.Context
import android.content.res.Resources
import android.util.AttributeSet
import android.util.Log
import com.ai.osmos.OsmosSDK
import com.ai.osmos.utils.ConfigManager
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext

/**
 * Created by adeshmukh on 16/04/25.
 * Project Name: OSMOS-Android-SDK
 * File Name: PIPAdView
 */

@SuppressLint("ViewConstructor")
class PIPAdView @JvmOverloads constructor(
    activity: Activity,
    adData: Map<String, Any>,
    private var width: Int? = null,
    private var height: Int? = null,
    private var coordinates: Coordinates? = Coordinates(0, 0),
    attrs: AttributeSet? = null
) : BaseAdView(activity, attrs) {

    private val adTracker = AdTracker(coroutineScope)
    private val pipLoader = PIPLoader(coroutineScope, adTracker)

    init {
        if (adData.isNotEmpty()) loadAd(adData, activity as Activity?) else showEmptyView(activity)
    }

    override fun onDetachedFromWindow() {
        Log.e("TAG", "onDetachedFromWindow: ", )
        pipLoader.cleanUp()
        super.onDetachedFromWindow()
    }
    override fun loadAd(adData: Map<String, Any>, context: Context) {

    }

    override fun loadAd(adData: Map<String, Any>, activity: Activity?) {
        coroutineScope.launch(Dispatchers.IO) {
            try {
                val ad = adData["ad"] as? VideoAd
                if (ad != null && isSupportedVideoFormat(ad)) {
                    val cliUbid = getCliUbid(ad)

                    if (isSupportedCrtVideo(ad.crt)) {
                        val (screenWidth, screenHeight) = getScreenHeightWidth()

                        val h = height ?: (ConfigManager.config.displayAds?.pipAdHeight?:screenHeight)
                        val w = width ?: (ConfigManager.config.displayAds?.pipAdWidth?: screenWidth)

                        val result = setMaxHeightWidth(h,w,coordinates!!)
                        coordinates = result.coordinates

                        val (resolvedWidth, resolvedHeight) = getAdDimensions(
                            result.finalWidth,
                            result.finalHeight,
                            ConfigManager.config.displayAds?.pipAdWidth?: screenWidth,
                            ConfigManager.config.displayAds?.pipAdHeight?:screenHeight
                        )

                        withContext(Dispatchers.Main) {
                            if (activity != null) {
                                pipLoader.showPIP(
                                    activity = activity,
                                    ad = ad,
                                    cliUbid = cliUbid,
                                    width = resolvedWidth,
                                    height = resolvedHeight,
                                    coordinates = coordinates,
                                    result.isClamped,
                                    adClickListener = adClickedListener
                                )
                            }
                        }
                    }
                    else{
                        showEmptyView(context)
                    }

                } else {
                    withContext(Dispatchers.Main) { showEmptyView(activity as Context) }
                }
            } catch (e: Exception) {
                withContext(Dispatchers.Main) { showEmptyView(activity as Context) }
            }
        }
    }
}