package com.ai.osmos.AdRenderSDK

import android.util.Log
import androidx.lifecycle.DefaultLifecycleObserver
import androidx.lifecycle.LifecycleOwner
import androidx.media3.exoplayer.ExoPlayer

/**
 * Created by adeshmukh on 23/04/25.
 * Project Name: OSMOS-Android-SDK
 * File Name: PIPPlayerLifecycleObserver
 */

class PIPPlayerLifecycleObserver(
    private val player: ExoPlayer
) : DefaultLifecycleObserver {
    override fun onPause(owner: LifecycleOwner) {
        try {
            player.pause()
        } catch (e: IllegalStateException) {
            Log.w(
                "PIPPlayerLifecycleObserver",
                "Cannot pause released player on app background: ${e.message}"
            )
        }
    }

    override fun onResume(owner: LifecycleOwner) {
        try {
            player.play()
        } catch (e: IllegalStateException) {
            Log.w(
                "PIPPlayerLifecycleObserver",
                "Cannot resume released player on app foreground: ${e.message}"
            )
        }
    }

    override fun onDestroy(owner: LifecycleOwner) {
        try {
            player.release()
            owner.lifecycle.removeObserver(this)
        } catch (e: Exception) {
            Log.e(
                "PIPPlayerLifecycleObserver",
                "Error releasing player or removing observer: ${e.message}"
            )
        }
    }
}

