package com.ai.osmos.utils

/**
 * Created by adeshmukh on 12/03/25.
 * Project Name: OSMOS-Android-SDK
 * File Name: OsmosConfig
 */
data class PLAAdConfig(
    val domainUri: String,
    val connectionTimeout: Int?
)
data class DisplayAdConfig(
    val domainUri: String,
    val connectionTimeout: Int?,
    val closeButtonSec: Int?,
    val pipAdHeight: Int?,
    val pipAdWidth: Int?
)
data class RegisterEventConfig(
    val domainUri: String,
    val connectionTimeout: Int?,
    val videoProgressSec: Int?
)

data class Config(
    val clientId: String,
    val debug: Boolean,
    val displayAds: DisplayAdConfig?,
    val plaAds: PLAAdConfig?,
    val registerEvent: RegisterEventConfig?
)
