package com.ai.osmos.utils

import android.content.Context
import android.os.Build
import android.provider.Settings

/**
 * Created by adeshmukh on 12/02/25.
 * Project Name: OSMOS-Android-SDK
 * File Name: DeviceInfoManager
 * This object provides utility functions to retrieve device-specific information
 * that does not required any specific permission.
 */
object DeviceInfoManager {

    /**
     * Retrieves a map of device-specific headers that can be used in API requests.
     */
    fun getDeviceHeaders(context: Context): Map<String, String> {
        return mapOf(
            "Device-Manufacturer" to Build.MANUFACTURER, // e.g., Samsung, Google
            "Device-Model" to Build.MODEL, // e.g., Galaxy S21, Pixel 6
            "OS-Version" to Build.VERSION.RELEASE, // e.g., 12, 13
            "SDK-Version" to Build.VERSION.SDK_INT.toString(), // e.g., 31, 32
            "Device-ID" to getDeviceId(context) // Unique device ID
        )
    }

    /**
     * Retrieves a unique device ID using ANDROID_ID.
     * ANDROID_ID is a unique identifier generated per device.
     * Note: This value may change upon factory reset.
     */
    private fun getDeviceId(context: Context): String {
        return try {
            Settings.Secure.getString(context.contentResolver, Settings.Secure.ANDROID_ID) ?: "Unknown"
        } catch (e: Exception) {
            "Unknown" // Fallback in case of any exception
        }
    }
}
