package com.ai.osmos.utils


import androidx.annotation.IntDef

/**
 * Created by adeshmukh on 20/06/25.
 * Project Name: OSMOS-Android-SDK
 * File Name: ErrorCode
 */

@IntDef(
    ErrorCode.ERROR_CODE_NETWORK_FAILURE,
    ErrorCode.ERROR_CODE_INVALID_CONFIG,
    ErrorCode.ERROR_CODE_AD_LOAD_FAILED,
    ErrorCode.ERROR_CODE_PLAYER_ERROR,
    ErrorCode.ERROR_CODE_TIMEOUT,
    ErrorCode.ERROR_CODE_UNKNOWN
)
@kotlin.annotation.Retention(AnnotationRetention.SOURCE)
annotation class ErrorCode {
    companion object {
        const val ERROR_CODE_NETWORK_FAILURE = 1001
        const val ERROR_CODE_INVALID_CONFIG = 1002
        const val ERROR_CODE_AD_LOAD_FAILED = 1003
        const val ERROR_CODE_PLAYER_ERROR = 1004
        const val ERROR_CODE_TIMEOUT = 1005
        const val ERROR_CODE_UNKNOWN = 1006
    }
}
