package com.ai.osmos.utils

import androidx.annotation.IntDef
import androidx.annotation.Nullable
import java.lang.annotation.Retention
import java.lang.annotation.RetentionPolicy
/**
 * Created by adeshmukh on 20/06/25.
 * Project Name: OSMOS-Android-SDK
 * File Name: OsmosException
 */

class ExceptionHandler protected constructor(
    message: String?,
    cause: Throwable?,
    @ErrorCode val errorCode: Int,
    val timestampMs: Long = System.currentTimeMillis()
) : Exception(message, cause) {

    companion object {
        fun networkFailure(message: String?, cause: Throwable? = null): ExceptionHandler {
            return ExceptionHandler(message, cause, ErrorCode.ERROR_CODE_NETWORK_FAILURE)
        }

        fun invalidConfig(message: String?, cause: Throwable? = null): ExceptionHandler {
            return ExceptionHandler(message, cause, ErrorCode.ERROR_CODE_INVALID_CONFIG)
        }

        fun adLoadFailed(message: String?, cause: Throwable? = null): ExceptionHandler {
            return ExceptionHandler(message, cause, ErrorCode.ERROR_CODE_AD_LOAD_FAILED)
        }

        fun playerError(message: String?, cause: Throwable? = null): ExceptionHandler {
            return ExceptionHandler(message, cause, ErrorCode.ERROR_CODE_PLAYER_ERROR)
        }

        fun timeout(message: String?, cause: Throwable? = null): ExceptionHandler {
            return ExceptionHandler(message, cause, ErrorCode.ERROR_CODE_TIMEOUT)
        }

        fun unknown(message: String?, cause: Throwable? = null): ExceptionHandler {
            return ExceptionHandler(message, cause, ErrorCode.ERROR_CODE_UNKNOWN)
        }
    }
}