package com.ai.osmos.utils

import android.graphics.Rect
import android.view.View

/**
 * Created by adeshmukh on 28/03/25.
 * Project Name: OSMOS-Android-SDK
 * File Name: ViewExtensions
 */

fun View.isVisibleInScreen(): Boolean {
    if (!isShown) return false

    val rect = Rect()
    val isVisible = getGlobalVisibleRect(rect)

    return isVisible && rect.width() * rect.height() >= (width * height * 0.5) //For 50%
//    return isVisible && rect.width() == this.width && rect.height() == this.height //For 100%
}

