package com.ai.osmos.ads.renderer

import com.ai.osmos.models.ads.TargetingParams
import com.ai.osmos.utils.error.ErrorCallback

/**
 * Project Name: OSMOS-Android-SDK
 * File Name: AdRendererInterface
 *
 * Interface for ad rendering functionality in the OSMOS SDK.
 * Provides methods for fetching and preparing different types of ads.
 */
public interface AdRendererInterface {

    /**
     * Fetch banner ads with ad units
     */
    suspend fun fetchBannerAdsWithAu(
        cliUbid: String,
        pageType: String,
        adUnit: String,
        targetingParams: List<TargetingParams>?,
        errorCallback: ErrorCallback?
    ): Map<String, Any>?

    /**
     * Fetch carousel ads with ad units
     */
    suspend fun fetchCarouselAdWithAu(
        cliUbid: String,
        pageType: String,
        adUnit: String,
        targetingParams: List<TargetingParams>?,
        errorCallback: ErrorCallback?
    ): Map<String, Any>?

    /**
     * Fetch multiple ads in carousel format with ad units
     */
    suspend fun fetchMultiAdCarouselWithAu(
        cliUbid: String,
        pageType: String,
        adUnit: String,
        productCount: Int,
        targetingParams: List<TargetingParams>?,
        errorCallback: ErrorCallback?
    ): Map<String, Any>?
}