package com.ai.osmos.models.ads

/**
 * Builder class for Product Listing Ads (PLA) filtering parameters with fluent interface
 */
class ProductAdsFilter {
    // Category parameters
    private var categoryId: String? = null
    private val categories: MutableList<String> = mutableListOf()
    private val mcategoryIds: MutableList<String> = mutableListOf()
    private val skuIds: MutableList<String> = mutableListOf()

    // Price parameters
    private var minPrice: String? = null
    private var maxPrice: String? = null

    // Attribute parameters
    private val colors: MutableList<String> = mutableListOf()
    private val sizes: MutableList<String> = mutableListOf()

    // Custom label parameters
    private val customLabels1: MutableList<String> = mutableListOf()
    private val customLabels2: MutableList<String> = mutableListOf()
    private val customLabels3: MutableList<String> = mutableListOf()
    private val customLabels4: MutableList<String> = mutableListOf()
    private val customLabels5: MutableList<String> = mutableListOf()
    private val customLabels6: MutableList<String> = mutableListOf()
    private val customLabels7: MutableList<String> = mutableListOf()
    private val customLabels8: MutableList<String> = mutableListOf()
    private val rtlCustomLabels0: MutableList<String> = mutableListOf()

    // Search parameters
    private val keywords: MutableList<String> = mutableListOf()

    // Brand parameters
    private val brands: MutableList<String> = mutableListOf()
    private val brandIds: MutableList<String> = mutableListOf()

    // Location parameters
    private val storeIds: MutableList<String> = mutableListOf()
    private val networks: MutableList<String> = mutableListOf()
    private val udps: MutableList<String> = mutableListOf()
    private var device: String? = null

    // MARK: - Category Methods

    fun categoryId(categoryId: String): ProductAdsFilter {
        this.categoryId = categoryId
        return this
    }

    fun categories(categories: List<String>): ProductAdsFilter {
        this.categories.addAll(categories)
        return this
    }

    fun mcategoryIds(mcategoryIds: List<String>): ProductAdsFilter {
        this.mcategoryIds.addAll(mcategoryIds)
        return this
    }

    fun skuIds(skuIds: List<String>): ProductAdsFilter {
        this.skuIds.addAll(skuIds)
        return this
    }

    // MARK: - Price Methods

    fun minPrice(minPrice: String): ProductAdsFilter {
        this.minPrice = minPrice
        return this
    }

    fun maxPrice(maxPrice: String): ProductAdsFilter {
        this.maxPrice = maxPrice
        return this
    }

    // MARK: - Attribute Methods

    fun colors(colors: List<String>): ProductAdsFilter {
        this.colors.addAll(colors)
        return this
    }

    fun sizes(sizes: List<String>): ProductAdsFilter {
        this.sizes.addAll(sizes)
        return this
    }

    // MARK: - Custom Label Methods

    fun customLabels1(customLabels1: List<String>): ProductAdsFilter {
        this.customLabels1.addAll(customLabels1)
        return this
    }

    fun customLabels2(customLabels2: List<String>): ProductAdsFilter {
        this.customLabels2.addAll(customLabels2)
        return this
    }

    fun customLabels3(customLabels3: List<String>): ProductAdsFilter {
        this.customLabels3.addAll(customLabels3)
        return this
    }

    fun customLabels4(customLabels4: List<String>): ProductAdsFilter {
        this.customLabels4.addAll(customLabels4)
        return this
    }

    fun customLabels5(customLabels5: List<String>): ProductAdsFilter {
        this.customLabels5.addAll(customLabels5)
        return this
    }

    fun customLabels6(customLabels6: List<String>): ProductAdsFilter {
        this.customLabels6.addAll(customLabels6)
        return this
    }

    fun customLabels7(customLabels7: List<String>): ProductAdsFilter {
        this.customLabels7.addAll(customLabels7)
        return this
    }

    fun customLabels8(customLabels8: List<String>): ProductAdsFilter {
        this.customLabels8.addAll(customLabels8)
        return this
    }

    fun rtlCustomLabels0(rtlCustomLabels0: List<String>): ProductAdsFilter {
        this.rtlCustomLabels0.addAll(rtlCustomLabels0)
        return this
    }

    // MARK: - Search Methods

    fun keywords(keywords: List<String>): ProductAdsFilter {
        this.keywords.addAll(keywords)
        return this
    }

    // MARK: - Brand Methods

    fun brands(brands: List<String>): ProductAdsFilter {
        this.brands.addAll(brands)
        return this
    }

    fun brandIds(brandIds: List<String>): ProductAdsFilter {
        this.brandIds.addAll(brandIds)
        return this
    }

    // MARK: - Location Methods

    fun storeIds(storeIds: List<String>): ProductAdsFilter {
        this.storeIds.addAll(storeIds)
        return this
    }

    fun networks(networks: List<String>): ProductAdsFilter {
        this.networks.addAll(networks)
        return this
    }

    fun udps(udps: List<String>): ProductAdsFilter {
        this.udps.addAll(udps)
        return this
    }

    fun device(device: String): ProductAdsFilter {
        this.device = device
        return this
    }

    // MARK: - Build Method

    /**
     * Convert the filter to a dictionary for API requests
     */
    fun toMap(): Map<String, Any> {
        val dict = mutableMapOf<String, Any>()

        // Category parameters
        categoryId?.let { dict["category_id"] = it }
        if (categories.isNotEmpty()) dict["categories"] = categories
        if (mcategoryIds.isNotEmpty()) dict["mcategory_ids"] = mcategoryIds
        if (skuIds.isNotEmpty()) dict["sku_ids"] = skuIds

        // Price parameters
        minPrice?.let { dict["min_price"] = it }
        maxPrice?.let { dict["max_price"] = it }

        // Attribute parameters
        if (colors.isNotEmpty()) dict["colors"] = colors
        if (sizes.isNotEmpty()) dict["sizes"] = sizes

        // Custom label parameters
        if (customLabels1.isNotEmpty()) dict["custom_label_1"] = customLabels1
        if (customLabels2.isNotEmpty()) dict["custom_label_2"] = customLabels2
        if (customLabels3.isNotEmpty()) dict["custom_label_3"] = customLabels3
        if (customLabels4.isNotEmpty()) dict["custom_label_4"] = customLabels4
        if (customLabels5.isNotEmpty()) dict["custom_label_5"] = customLabels5
        if (customLabels6.isNotEmpty()) dict["custom_label_6"] = customLabels6
        if (customLabels7.isNotEmpty()) dict["custom_label_7"] = customLabels7
        if (customLabels8.isNotEmpty()) dict["custom_label_8"] = customLabels8
        if (rtlCustomLabels0.isNotEmpty()) dict["rtl_custom_label_0"] = rtlCustomLabels0

        // Search parameters
        if (keywords.isNotEmpty()) dict["keywords"] = keywords

        // Brand parameters
        if (brands.isNotEmpty()) dict["brands"] = brands
        if (brandIds.isNotEmpty()) dict["brand_ids"] = brandIds

        // Location parameters
        if (storeIds.isNotEmpty()) dict["store_id"] = storeIds
        if (networks.isNotEmpty()) dict["network"] = networks
        if (udps.isNotEmpty()) dict["udp"] = udps
        device?.let { dict["device"] = it }

        return dict
    }
}