package com.ai.osmos.models.ads

/**
 * Base interface for all targeting parameter classes
 */
interface TargetingParams {
    fun toMap(): Map<String, Any>
}

/**
 * Platform-specific targeting parameters
 */
class PlatformTargeting : TargetingParams {
    private var device: String? = null

    fun device(device: String): PlatformTargeting {
        this.device = device
        return this
    }

    override fun toMap(): Map<String, Any> {
        val dict = mutableMapOf<String, Any>()
        device?.let { dict["f.device"] = it }
        return dict
    }
}

/**
 * Merchandise-specific targeting parameters
 */
class MerchandiseTargeting : TargetingParams {
    private var skuId: String? = null
    private var categoryId: String? = null
    private val brands: MutableList<String> = mutableListOf()
    private var categoryL1: String? = null
    private var categoryL2: String? = null
    private var categoryL3: String? = null
    private val udps: MutableList<String> = mutableListOf()

    fun skuId(skuId: String): MerchandiseTargeting {
        this.skuId = skuId
        return this
    }

    fun categoryId(categoryId: String): MerchandiseTargeting {
        this.categoryId = categoryId
        return this
    }

    fun brands(brands: List<String>): MerchandiseTargeting {
        this.brands.addAll(brands)
        return this
    }

    fun categoryL1(categoryL1: String): MerchandiseTargeting {
        this.categoryL1 = categoryL1
        return this
    }

    fun categoryL2(categoryL2: String): MerchandiseTargeting {
        this.categoryL2 = categoryL2
        return this
    }

    fun categoryL3(categoryL3: String): MerchandiseTargeting {
        this.categoryL3 = categoryL3
        return this
    }

    fun udps(udps: List<String>): MerchandiseTargeting {
        this.udps.addAll(udps)
        return this
    }

    override fun toMap(): Map<String, Any> {
        val dict = mutableMapOf<String, Any>()
        skuId?.let { dict["f.sku_id"] = it }
        categoryId?.let { dict["f.category_id"] = it }
        if (brands.isNotEmpty()) dict["f.brand"] = brands
        categoryL1?.let { dict["f.category_l1"] = it }
        categoryL2?.let { dict["f.category_l2"] = it }
        categoryL3?.let { dict["f.category_l3"] = it }
        if (udps.isNotEmpty()) dict["f.udp"] = udps
        return dict
    }
}

/**
 * Geographic targeting parameters
 */
class GeoTargeting : TargetingParams {
    private val storeIds: MutableList<String> = mutableListOf()
    private val networks: MutableList<String> = mutableListOf()
    private var city: String? = null
    private var state: String? = null
    private var country: String? = null

    fun storeIds(storeIds: List<String>): GeoTargeting {
        this.storeIds.addAll(storeIds)
        return this
    }

    fun networks(networks: List<String>): GeoTargeting {
        this.networks.addAll(networks)
        return this
    }

    fun city(city: String): GeoTargeting {
        this.city = city
        return this
    }

    fun state(state: String): GeoTargeting {
        this.state = state
        return this
    }

    fun country(country: String): GeoTargeting {
        this.country = country
        return this
    }

    override fun toMap(): Map<String, Any> {
        val dict = mutableMapOf<String, Any>()
        if (storeIds.isNotEmpty()) dict["f.store_id"] = storeIds
        if (networks.isNotEmpty()) dict["f.network"] = networks
        city?.let { dict["f.city"] = it }
        state?.let { dict["f.state"] = it }
        country?.let { dict["f.country"] = it }
        return dict
    }
}

/**
 * Context-specific targeting parameters
 */
class ContextTargeting : TargetingParams {
    private var keyword: String? = null

    fun keyword(keyword: String): ContextTargeting {
        this.keyword = keyword
        return this
    }

    override fun toMap(): Map<String, Any> {
        val dict = mutableMapOf<String, Any>()
        keyword?.let { dict["f.keyword"] = it }
        return dict
    }
}

/**
 * Custom label targeting parameters
 */
class CustomLabelTargeting : TargetingParams {
    private val customLabels1: MutableList<String> = mutableListOf()
    private val customLabels2: MutableList<String> = mutableListOf()
    private val customLabels3: MutableList<String> = mutableListOf()
    private val customLabels4: MutableList<String> = mutableListOf()
    private val customLabels5: MutableList<String> = mutableListOf()
    private val customLabels6: MutableList<String> = mutableListOf()
    private val customLabels7: MutableList<String> = mutableListOf()
    private val customLabels8: MutableList<String> = mutableListOf()

    fun customLabels1(customLabels1: List<String>): CustomLabelTargeting {
        this.customLabels1.addAll(customLabels1)
        return this
    }

    fun customLabels2(customLabels2: List<String>): CustomLabelTargeting {
        this.customLabels2.addAll(customLabels2)
        return this
    }

    fun customLabels3(customLabels3: List<String>): CustomLabelTargeting {
        this.customLabels3.addAll(customLabels3)
        return this
    }

    fun customLabels4(customLabels4: List<String>): CustomLabelTargeting {
        this.customLabels4.addAll(customLabels4)
        return this
    }

    fun customLabels5(customLabels5: List<String>): CustomLabelTargeting {
        this.customLabels5.addAll(customLabels5)
        return this
    }

    fun customLabels6(customLabels6: List<String>): CustomLabelTargeting {
        this.customLabels6.addAll(customLabels6)
        return this
    }

    fun customLabels7(customLabels7: List<String>): CustomLabelTargeting {
        this.customLabels7.addAll(customLabels7)
        return this
    }

    fun customLabels8(customLabels8: List<String>): CustomLabelTargeting {
        this.customLabels8.addAll(customLabels8)
        return this
    }

    override fun toMap(): Map<String, Any> {
        val dict = mutableMapOf<String, Any>()
        if (customLabels1.isNotEmpty()) dict["f.custom_label_1"] = customLabels1
        if (customLabels2.isNotEmpty()) dict["f.custom_label_2"] = customLabels2
        if (customLabels3.isNotEmpty()) dict["f.custom_label_3"] = customLabels3
        if (customLabels4.isNotEmpty()) dict["f.custom_label_4"] = customLabels4
        if (customLabels5.isNotEmpty()) dict["f.custom_label_5"] = customLabels5
        if (customLabels6.isNotEmpty()) dict["f.custom_label_6"] = customLabels6
        if (customLabels7.isNotEmpty()) dict["f.custom_label_7"] = customLabels7
        if (customLabels8.isNotEmpty()) dict["f.custom_label_8"] = customLabels8
        return dict
    }
}