package com.ai.osmos.models.ads

/**
 * Builder class for combining multiple targeting parameter objects into a single dictionary
 */
class TargetingParamsBuilder {
    private val targetingParams: MutableList<TargetingParams> = mutableListOf()

    /**
     * Add a targeting parameter object to the builder
     */
    fun add(targeting: TargetingParams): TargetingParamsBuilder {
        targetingParams.add(targeting)
        return this
    }

    /**
     * Build the final targeting parameters dictionary by merging all added targeting objects
     */
    fun build(): Map<String, Any> {
        val finalDict = mutableMapOf<String, Any>()
        for (targeting in targetingParams) {
            val dict = targeting.toMap()
            dict.forEach { (key, value) ->
                finalDict[key] = value
            }
        }
        return finalDict
    }
}