package com.ai.osmos.models.events

/**
 * Enum defining all event names used in event tracking
 */
enum class EventName(val eventName: String) {
    /** Product view event - tracks when user views a product */
    VIEW_PRODUCT("viewproduct"),

    /** Add to cart funnel event - tracks when user adds item to cart */
    ADD_TO_CART("funnel_add2cart"),

    /** Sale completion funnel event - tracks successful purchases */
    SALE_COMPLETE("funnel_salecomplete"),

    /** Ad impression funnel event - tracks when ads are displayed to users */
    IMPRESSION("funnel_impression"),

    /** Video progress funnel event - tracks video playback progress */
    VIDEO_PROGRESS("funnel_video_progress"),

    /** Video action funnel event - tracks user interactions with video player */
    VIDEO_ACTION("funnel_video_action");

    companion object {
        /**
         * Initialize from string (for backward compatibility)
         */
        fun fromString(string: String): EventName? {
            return values().find { it.eventName == string }
        }
    }
}

/**
 * Enum defining video player action types for event tracking
 */
enum class VideoActionType(val actionType: String) {
    /** Video mute action */
    MUTE("mute"),

    /** Video unmute action */
    UNMUTE("unmute"),

    /** Video pause action */
    PAUSE("pause"),

    /** Video play action */
    PLAY("play"),

    /** Video fullscreen action */
    FULLSCREEN("fullscreen"),

    /** Video minimize action */
    MINIMIZE("minimize");

    companion object {
        /**
         * Initialize from string (for backward compatibility)
         */
        fun fromString(string: String): VideoActionType? {
            return values().find { it.actionType == string }
        }
    }
}

/**
 * Enum defining internal event routing paths
 */
enum class EventPath(val pathName: String) {
    /** Ad click event path */
    AD_CLICK("aclick"),

    /** General events path */
    EVENTS("events");

    companion object {
        /**
         * Initialize from string (for backward compatibility)
         */
        fun fromString(string: String): EventPath? {
            return values().find { it.pathName == string }
        }
    }
}