package com.ai.osmos.models.ads


// Enum for Ad Types
enum class AdType {
    IMAGE, VIDEO, CAROUSEL, MULTI_AD, UNKNOWN;

    companion object {
        fun fromString(type: String?): AdType {
            return when (type?.uppercase()) {
                "IMAGE" -> IMAGE
                "VIDEO" -> VIDEO
                "CAROUSEL" -> CAROUSEL
                "MULTI_AD" -> MULTI_AD
                else -> UNKNOWN
            }
        }
    }
}

// Landing Product List
data class LandingProductList(
    val skuId: String,
    val currency: String,
    val imageLink: String
)

// Ad Element for Image and Video Ads
data class AdElement(
    val value: String,
    val height: Int,
    val width: Int,
    val type: String,
    val destinationUrl: String? = null,
    val landingProductList: List<LandingProductList>? = emptyList(),
    val videoProgressSec: Int? = 3,
    val closeButtonSec: Int? = 2
)

// Image Ad Model
data class ImageAd(
    val clientId: Long,
    val au: String,
    val rank: Int,
    val clickTrackingUrl: String,
    val impressionTrackingUrl: String,
    val uclid: String,
    override val crt: String,
    val elements: AdElement,
    override val adMetadata: Map<String, Any>? = null,
    override val cliUbid: String? = ""
) : BaseAd() {
    override val elementsType: AdType
        get() = AdType.fromString(elements.type)
}

// Video Ad Model
data class VideoAd(
    val clientId: Long,
    val au: String,
    val rank: Int,
    val clickTrackingUrl: String,
    val impressionTrackingUrl: String,
    val uclid: String,
    override val crt: String,
    val elements: AdElement,
    override val adMetadata: Map<String, Any>? = null,
    override val cliUbid: String? = ""
) : BaseAd() {
    override val elementsType: AdType
        get() = AdType.fromString(elements.type)
}

// Media Element for Carousel Ads
data class MediaElement(
    val value: String,
    val height: Int,
    val width: Int,
    val type: String
)

// Carousel Ad Element
data class CarouselAdElement(
    val media: MediaElement,
    val destinationUrl: String
)

data class CarouselAdElementsWrapper(
    val carouselCards: List<CarouselAdElement>
)

// Carousel Ad Model
data class CarouselAd(
    val clientId: Long,
    val au: String,
    val rank: Int,
    val clickTrackingUrl: String,
    val impressionTrackingUrl: String,
    val uclid: String,
    override val crt: String,
    val elements: CarouselAdElementsWrapper,
    override val adMetadata: Map<String, Any>? = null,
    override val cliUbid: String? = ""
) : BaseAd() {
    override val elementsType: AdType = AdType.CAROUSEL
}


// MultiAd Model
data class MultiAd(
    val clientId: Long,
    val au: String,
    val rank: Int,
    val clickTrackingUrl: String,
    val impressionTrackingUrl: String,
    val uclid: String,
    override val crt: String,
    val elements: AdElement,
    override val adMetadata: Map<String, Any>? = null,
    override val cliUbid: String? = ""
) : BaseAd() {
    override val elementsType: AdType = AdType.MULTI_AD
}

// AdData Wrapper to Handle Multiple Ad Types
data class AdData(
    val ads: Map<String, List<BaseAd>>,
    val imageAdList: List<ImageAd> = emptyList(),
    val videoAdList: List<VideoAd> = emptyList(),
    val carouselAdList: List<CarouselAd> = emptyList()
)


