package com.ai.osmos.models.ads

/**
 * Simple utility for combining multiple targeting parameter objects into a single dictionary.
 * 
 * This class is thread-safe and immutable. Much cleaner than the old builder pattern!
 */
class TargetingParamsBuilder private constructor(
    private val targetingParams: List<TargetingParams>
) {
    
    /**
     * Get the final targeting parameters dictionary by merging all targeting objects
     */
    fun toMap(): Map<String, Any> {
        val finalDict = mutableMapOf<String, Any>()
        for (targeting in targetingParams) {
            val dict = targeting.toMap()
            dict.forEach { (key, value) ->
                finalDict[key] = value
            }
        }
        return finalDict.toMap() // Return immutable copy
    }
    
    companion object {
        /**
         * Create targeting params builder from list of targeting objects
         */
        fun from(vararg targetingParams: TargetingParams): TargetingParamsBuilder {
            return TargetingParamsBuilder(targetingParams.toList())
        }
        
        /**
         * Create targeting params builder from list of targeting objects
         */
        fun from(targetingParams: List<TargetingParams>): TargetingParamsBuilder {
            return TargetingParamsBuilder(targetingParams.toList())
        }
        
        /**
         * Create empty targeting params builder
         */
        fun empty(): TargetingParamsBuilder {
            return TargetingParamsBuilder(emptyList())
        }
    }
}