package com.ai.osmos.models.enums

/**
 * Enum defining the different page types for PLA (Product Listing Ads) requests
 */
enum class PlaPageType(val pageTypeName: String) {
    PRODUCT("PRODUCT"),
    SEARCH("SEARCH"),
    HOME("HOME"),
    CATEGORY("CATEGORY"),
    PURCHASE("PURCHASE"),
    TPA("TPA");

    companion object {
        /**
         * Initialize from string (for backward compatibility)
         */
        fun fromString(string: String): PlaPageType? {
            return values().find { it.pageTypeName.equals(string, ignoreCase = true) }
        }
    }
}