package com.ai.osmos.network

import android.net.Uri

/**
 * Object to hold web-related constants and utilities for building URLs.
 *
 * Project Name: OSMOS-Android-SDK
 * File Name: WebConstants
 */
object WebConstants {

    /**
     * Builds a complete URL by appending a query string to the base URL.
     *
     * @param baseUrl The base URL to which query parameters will be appended.
     * @param params A map of query parameters where keys are parameter names,
     *               and values are the parameter values (can be lists or single values).
     * @return A fully constructed URL with the query string.
     */
    fun buildUrl(baseUrl: String, params: Map<String, Any>): String {
        val queryString = params.entries.joinToString("&") { (key, value) ->
            when (value) {
                is List<*> -> value.joinToString("&") {
                    "$key=${Uri.encode(it.toString())}"
                }

                else -> "$key=${
                    Uri.encode(value.toString())
                }"
            }
        }
        return "$baseUrl?$queryString"
    }


}
