package com.ai.osmos.utils.error

/**
 * Project Name: OSMOS-Android-SDK
 * File Name: ErrorCallback
 *
 * Callback interface for handling Ad Fetcher error scenarios only.
 * On success, the function returns Map<String,Any> as usual.
 * This callback is only invoked when an error occurs.
 */
interface ErrorCallback {

    /**
     * Called when the ad fetch operation encounters an error.
     *
     * @param errorCode The error code identifying the type of error
     * @param errorMessage A human-readable description of the error
     * @param throwable Optional throwable that caused the error (null if not applicable)
     */
    fun onError(errorCode: String, errorMessage: String, throwable: Throwable? = null)
}