package com.ai.osmos.utils.ui

import com.ai.osmos.models.ads.AdElement
import com.ai.osmos.models.ads.BaseAd
import com.ai.osmos.models.ads.CarouselAd
import com.ai.osmos.models.ads.ImageAd
import com.ai.osmos.models.ads.MultiAd
import com.ai.osmos.models.ads.VideoAd


fun mapAdElement(element: AdElement): Map<String, Any?> {
    return mapOf(
        "value" to element.value,
        "height" to element.height,
        "width" to element.width,
        "type" to element.type,
        "destination_url" to element.destinationUrl,
        "landing_product_list" to element.landingProductList,
        "video_progress_sec" to element.videoProgressSec,
        "close_button_sec" to element.closeButtonSec
    )
}

fun BaseAd.toMap(): Map<String, Any> {
    val baseMap = mutableMapOf<String, Any?>(
        "client_id" to when (this) {
            is ImageAd -> this.clientId
            is VideoAd -> this.clientId
            is CarouselAd -> this.clientId
            is MultiAd -> this.clientId
            else -> null
        },
        "au" to when (this) {
            is ImageAd -> this.au
            is VideoAd -> this.au
            is CarouselAd -> this.au
            is MultiAd -> this.au
            else -> null
        },
        "rank" to when (this) {
            is ImageAd -> this.rank
            is VideoAd -> this.rank
            is CarouselAd -> this.rank
            is MultiAd -> this.rank
            else -> null
        },
        "uclid" to when (this) {
            is ImageAd -> this.uclid
            is VideoAd -> this.uclid
            is CarouselAd -> this.uclid
            is MultiAd -> this.uclid
            else -> null
        },
        "crt" to this.crt,
        "cli_ubid" to this.cliUbid,
        "adMetadata" to this.adMetadata,
        "elementsType" to this.elementsType.name
    )

    when (this) {
        is ImageAd -> baseMap["elements"] = mapAdElement(this.elements)
        is VideoAd -> baseMap["elements"] = mapAdElement(this.elements)
        is MultiAd -> baseMap["elements"] = mapAdElement(this.elements)
        is CarouselAd -> {
            baseMap["carousel_cards"] = this.elements.carouselCards.map { element ->
                mapOf(
                    "media" to mapOf(
                        "value" to element.media.value,
                        "height" to element.media.height,
                        "width" to element.media.width,
                        "type" to element.media.type
                    ),
                    "destination_url" to element.destinationUrl
                )
            }
        }
    }

    return baseMap.filterValues { it != null } as Map<String, Any>
}

fun List<MultiAd>.toMapList(): List<Map<String, Any>> {
    return this.map { it.toMap() }
}
