package com.ai.osmos.ads.views.helpers

import android.content.Context
import android.view.View
import com.ai.osmos.ads.views.style.NativeAdCustomStyle
import com.ai.osmos.models.ads.NativeAd
import com.ai.osmos.models.enums.NativeAdLayoutType
import com.ai.osmos.utils.error.ErrorCallback

/**
 * Interface for rendering native ad views in different layouts.
 * Used internally by BaseNativeAdView to delegate rendering logic.
 */
internal interface NativeAdViewRenderer {

    fun setErrorCallback(callback: ErrorCallback?)
    fun clearErrorCallback()

    fun renderVerticalView(
        context: Context,
        adData: NativeAd,
        width: Int,
        height: Int?,
        adLabelText: String?,
        adLabelAlignment: Int?,
        style: NativeAdCustomStyle?,
        customCtaView: View?,
        customBadgeView: View?,
        isCarouselView: Boolean
    ): View

    fun renderHorizontalView(
        context: Context,
        adData: NativeAd,
        width: Int,
        height: Int?,
        adLabelText: String?,
        adLabelAlignment: Int?,
        style: NativeAdCustomStyle?,
        customCtaView: View?,
        customBadgeView: View?,
        isCarouselView: Boolean
    ): View

    fun renderProductVerticalView(
        context: Context,
        adData: NativeAd,
        adType: NativeAdLayoutType,
        width: Int,
        height: Int?,
        style: NativeAdCustomStyle?,
        customCtaView: View?
    ): View

    fun renderProductHorizontalView(
        context: Context,
        adData: NativeAd,
        adType: NativeAdLayoutType,
        width: Int,
        height: Int?,
        style: NativeAdCustomStyle?,
        customCtaView: View?
    ): View
}